/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.sensorframework.adapter;

import de.uka.ipd.sdq.codegen.simudatavisualisation.datatypes.Histogram;
import de.uka.ipd.sdq.codegen.simudatavisualisation.datatypes.HistogramBucketInformation;
import de.uka.ipd.sdq.sensorframework.adapter.DataAdapter;
import de.uka.ipd.sdq.sensorframework.adapter.MeasurementsComparator;
import de.uka.ipd.sdq.sensorframework.adapter.TimeSpanToHistogramAdapter;
import de.uka.ipd.sdq.sensorframework.entities.Measurement;
import de.uka.ipd.sdq.sensorframework.entities.SensorAndMeasurements;
import de.uka.ipd.sdq.sensorframework.entities.TimeSpanMeasurement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

public class TimeSpanToThroughputHistogramAdapter
extends DataAdapter {
    private static final double DEFAULT_HISTOGRAM_WIDTH = 1.0;
    public static final double DEFAULT_TIME_SPAN_WIDTH = 10.0;
    public static final String HISTOGRAM_WIDTH_PROPERTY_NAME = "HISTOGRAM_WIDTH";
    private static Logger log;
    private static final double PROBABILITIES_SUM_ALLOWED_EPSILON = 0.01;
    private static final String TIME_SPAN_WIDTH_PROPERTY_NAME = "TIME_SPAN_WIDTH";
    private SensorAndMeasurements samInformation;
    private boolean supportAggregation = true;
    private boolean logUsingLogger = false;

    public static synchronized SortedMap<Double, Integer> aggregateToHistogramBucketWidth(Double widthOfHistogramClass, SortedMap<Double, Integer> throughputFrequenciesDouble) {
        Double[] keysAsArray = throughputFrequenciesDouble.keySet().toArray(new Double[0]);
        TreeMap<Double, Integer> aggregatedThroughputs = new TreeMap<Double, Integer>();
        int i = 0;
        while (i < keysAsArray.length) {
            Double keyOfAggregated = ((double)new Double(keysAsArray[i] / widthOfHistogramClass).intValue() + 0.5) * widthOfHistogramClass;
            if (aggregatedThroughputs.get(keyOfAggregated) == null) {
                aggregatedThroughputs.put(keyOfAggregated, (Integer)throughputFrequenciesDouble.get(keysAsArray[i]));
            } else {
                Integer oldValueOfAggregated = (Integer)aggregatedThroughputs.get(keyOfAggregated);
                aggregatedThroughputs.put(keyOfAggregated, oldValueOfAggregated + (Integer)throughputFrequenciesDouble.get(keysAsArray[i]));
            }
            ++i;
        }
        return aggregatedThroughputs;
    }

    public static synchronized void fillHistogramFromFrequencies(Histogram hist, SortedMap<Double, Integer> aggregatedThroughputs, double histogramBucketWidth) {
        if (histogramBucketWidth <= 0.0) {
            throw new RuntimeException("Invalid, non-positive bucket width for histogram: " + histogramBucketWidth);
        }
        if (hist == null) {
            hist = new Histogram("New empty histogram", histogramBucketWidth, "Throughput");
        }
        if (aggregatedThroughputs == null || aggregatedThroughputs.size() == 0) {
            hist = new Histogram("Empty histogram", histogramBucketWidth, "Throughput");
            return;
        }
        Long sumOfAggregatedClasses = 0L;
        for (Double key : aggregatedThroughputs.keySet()) {
            if (sumOfAggregatedClasses + (long)((Integer)aggregatedThroughputs.get(key)).intValue() < sumOfAggregatedClasses) {
                throw new RuntimeException("Overflow detected while adding " + aggregatedThroughputs.get(key) + " to " + sumOfAggregatedClasses + " for computing frequencies");
            }
            sumOfAggregatedClasses = sumOfAggregatedClasses + (long)((Integer)aggregatedThroughputs.get(key)).intValue();
        }
        Double sumOfProbabilities = 0.0;
        sumOfProbabilities = 0.0;
        for (Double key : aggregatedThroughputs.keySet()) {
            Double probability = new Double(((Integer)aggregatedThroughputs.get(key)).intValue()) / new Double(sumOfAggregatedClasses.longValue());
            sumOfProbabilities = sumOfProbabilities + probability;
            hist.addEntity(new HistogramBucketInformation(probability.doubleValue(), key.doubleValue()));
        }
        if (Math.abs(sumOfProbabilities - 1.0) > 0.01) {
            throw new RuntimeException("Sum of histogram probabilities too far from 1.0D, histogram classes were lost");
        }
    }

    public static synchronized ArrayList<Integer> getMeasurementsInEachTimeWindow(Collection<Measurement> collection, double timeWindowLengthForThroughputCalculation, boolean firstBucketStartsWithSmallestRealValue, boolean considerTimespanEndInsteadOfStart) {
        if (collection == null) {
            return null;
        }
        if (collection.size() == 0) {
            return new ArrayList<Integer>();
        }
        Measurement[] measurements = collection.toArray(new Measurement[0]);
        Arrays.sort(measurements, new MeasurementsComparator());
        Measurement[] measurementArray = measurements;
        int n = measurements.length;
        int n2 = 0;
        while (n2 < n) {
            Measurement m = measurementArray[n2];
            if (m.getEventTime() < 0.0) {
                throw new RuntimeException("Timespan measurements cannot have negative event time");
            }
            ++n2;
        }
        ArrayList<Integer> count = new ArrayList<Integer>();
        int currentCount = 0;
        double currentTime = 0.0;
        double nextLimit = timeWindowLengthForThroughputCalculation;
        boolean first = true;
        Measurement[] measurementArray2 = measurements;
        int n3 = measurements.length;
        int n4 = 0;
        while (n4 < n3) {
            Measurement m = measurementArray2[n4];
            currentTime = m.getEventTime();
            if (considerTimespanEndInsteadOfStart) {
                try {
                    TimeSpanMeasurement tsm = (TimeSpanMeasurement)m;
                    currentTime += tsm.getTimeSpan();
                }
                catch (ClassCastException classCastException) {
                }
                catch (Exception exception) {}
            }
            if (first) {
                if (firstBucketStartsWithSmallestRealValue) {
                    nextLimit += currentTime;
                }
                first = false;
            }
            if (currentTime < nextLimit) {
                ++currentCount;
            } else {
                count.add(currentCount);
                nextLimit += timeWindowLengthForThroughputCalculation;
                while (currentTime >= nextLimit) {
                    count.add(0);
                    nextLimit += timeWindowLengthForThroughputCalculation;
                }
                currentCount = 1;
            }
            ++n4;
        }
        count.add(currentCount);
        return count;
    }

    public static synchronized SortedMap<Double, Integer> getThroughputFrequencies(Double timeWindowLengthForThroughputCalculation, List<Integer> measurementsInTimeWindows) {
        TreeMap<Double, Integer> throughputFrequenciesDouble = new TreeMap<Double, Integer>();
        for (Integer singleCount : measurementsInTimeWindows) {
            double histogramClassDouble = new Double(singleCount.intValue()) / timeWindowLengthForThroughputCalculation;
            Integer oldValue = (Integer)throughputFrequenciesDouble.get(histogramClassDouble);
            if (oldValue == null || oldValue == 0) {
                throughputFrequenciesDouble.put(histogramClassDouble, 1);
                continue;
            }
            throughputFrequenciesDouble.put(histogramClassDouble, oldValue + 1);
        }
        return throughputFrequenciesDouble;
    }

    private TimeSpanToThroughputHistogramAdapter() {
    }

    public TimeSpanToThroughputHistogramAdapter(SensorAndMeasurements samInformation) {
        log = Logger.getLogger((String)this.getClass().getCanonicalName());
        log.setLevel(Level.DEBUG);
        BasicConfigurator.configure();
        this.samInformation = samInformation;
        this.adapterProperties.put(HISTOGRAM_WIDTH_PROPERTY_NAME, (Object)1.0);
        this.adapterProperties.put(TIME_SPAN_WIDTH_PROPERTY_NAME, (Object)10.0);
    }

    @Override
    public Object getAdaptedObject() {
        Double timeWindowLengthForThroughputCalculation = 0.0;
        timeWindowLengthForThroughputCalculation = this.adapterProperties.get(TIME_SPAN_WIDTH_PROPERTY_NAME) == null ? Double.valueOf(10.0) : (Double)this.adapterProperties.get(TIME_SPAN_WIDTH_PROPERTY_NAME);
        Double widthOfHistogramClass = (Double)this.adapterProperties.get(HISTOGRAM_WIDTH_PROPERTY_NAME);
        if (widthOfHistogramClass < 0.0 || widthOfHistogramClass.equals(0) || widthOfHistogramClass.equals(Double.NaN)) {
            throw new RuntimeException("Histogram width must be > 0 and non-NaN");
        }
        if (widthOfHistogramClass == null) {
            throw new RuntimeException("Histogram width must a non-null Double");
        }
        Double recomputedBucketWidth = TimeSpanToHistogramAdapter.calculateHistogramBucketWidthFromMeasurements(this.samInformation, widthOfHistogramClass);
        if (recomputedBucketWidth.compareTo(widthOfHistogramClass) != 0) {
            log.error((Object)("recomputed bucket width " + recomputedBucketWidth + " is different from " + "property-read bucket width " + widthOfHistogramClass));
        } else {
            log.debug((Object)"recomputed bucket width is the same as the property-based bucket width");
        }
        if (this.samInformation.getMeasurements().size() == 0) {
            throw new RuntimeException("No measurements passed for throughput histogram calculation");
        }
        Histogram hist = new Histogram(this.samInformation.getSensor().getSensorName(), widthOfHistogramClass.doubleValue(), "Throughput");
        this.log_debug("1. Individual measurements: ");
        for (Measurement m : this.samInformation.getMeasurements()) {
            this.log_debug("" + m);
        }
        this.log_debug("2. Number of measurements in *each* window: ");
        ArrayList<Integer> measurementsInTimeWindows = TimeSpanToThroughputHistogramAdapter.getMeasurementsInEachTimeWindow(this.samInformation.getMeasurements(), timeWindowLengthForThroughputCalculation, true, false);
        for (Integer m : measurementsInTimeWindows) {
            this.log_debug(m + " ");
        }
        this.log_debug("-> " + measurementsInTimeWindows.size() + " windows");
        this.log_debug("3a. Map 'throughput per window'->'frequency of this throughput value': ");
        SortedMap<Double, Integer> throughputFrequenciesDouble = TimeSpanToThroughputHistogramAdapter.getThroughputFrequencies(timeWindowLengthForThroughputCalculation, measurementsInTimeWindows);
        for (Double m : throughputFrequenciesDouble.keySet()) {
            this.log_debug(m + "->" + throughputFrequenciesDouble.get(m));
        }
        if (this.supportAggregation) {
            SortedMap<Double, Integer> aggregatedThroughputs = TimeSpanToThroughputHistogramAdapter.aggregateToHistogramBucketWidth(widthOfHistogramClass, throughputFrequenciesDouble);
            this.log_debug("4. Aggregated into histogram buckets of width " + widthOfHistogramClass + ": " + "Map 'throughput per window'->'frequency of this throughput value': ");
            for (Double m : aggregatedThroughputs.keySet()) {
                this.log_debug(m + "->" + aggregatedThroughputs.get(m));
            }
            TimeSpanToThroughputHistogramAdapter.fillHistogramFromFrequencies(hist, aggregatedThroughputs, widthOfHistogramClass);
        } else {
            TimeSpanToThroughputHistogramAdapter.fillHistogramFromFrequencies(hist, throughputFrequenciesDouble, widthOfHistogramClass);
        }
        this.log_debug("5. Created histogram: buckets: ");
        for (Double m : hist.getBucketInformation()) {
            this.log_debug("" + m);
        }
        return hist;
    }

    private void log_debug(String str) {
        if (this.logUsingLogger) {
            log.debug((Object)str);
        } else {
            System.out.println(str);
        }
    }

    public void setTimespanWidth(double d) {
        if (!(d > 0.0)) {
            throw new RuntimeException("timespan width must be larger than 0");
        }
        this.adapterProperties.put(TIME_SPAN_WIDTH_PROPERTY_NAME, (Object)d);
    }
}

