/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.sensorframework.adapter;

import de.uka.ipd.sdq.codegen.simudatavisualisation.datatypes.Histogram;
import de.uka.ipd.sdq.codegen.simudatavisualisation.datatypes.HistogramBucketInformation;
import de.uka.ipd.sdq.sensorframework.adapter.DataAdapter;
import de.uka.ipd.sdq.sensorframework.entities.Measurement;
import de.uka.ipd.sdq.sensorframework.entities.SensorAndMeasurements;
import de.uka.ipd.sdq.sensorframework.entities.TimeSpanMeasurement;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class TimeSpanToHistogramAdapter
extends DataAdapter {
    private Logger logger;
    public static final String HISTOGRAM_WIDTH = "HISTOGRAM_WIDTH";
    private SensorAndMeasurements samInformation;

    private TimeSpanToHistogramAdapter() {
    }

    public TimeSpanToHistogramAdapter(SensorAndMeasurements sensorAndMeasurements) {
        this.logger = Logger.getLogger((String)this.getClass().getName());
        this.samInformation = sensorAndMeasurements;
        double newBucketWidth = TimeSpanToHistogramAdapter.calculateHistogramBucketWidthFromMeasurements(this.samInformation, 1.0);
        this.adapterProperties.put(HISTOGRAM_WIDTH, (Object)newBucketWidth);
        this.logger.debug((Object)("Histogram width: " + newBucketWidth));
    }

    public static final double calculateHistogramBucketWidthFromMeasurements(SensorAndMeasurements sam, Double presetBucketWidth) {
        double minValue = Double.MAX_VALUE;
        double maxValue = Double.MIN_VALUE;
        for (Measurement measurement : sam.getMeasurements()) {
            TimeSpanMeasurement timeSpanMeasurement = (TimeSpanMeasurement)measurement;
            minValue = minValue < timeSpanMeasurement.getTimeSpan() ? minValue : timeSpanMeasurement.getTimeSpan();
            double d = maxValue = maxValue > timeSpanMeasurement.getTimeSpan() ? maxValue : timeSpanMeasurement.getTimeSpan();
        }
        double newBucketWidth = TimeSpanToHistogramAdapter.calculateHistogramBucketWidth(minValue, maxValue, presetBucketWidth);
        return newBucketWidth;
    }

    public static final double calculateHistogramBucketWidth(double minValue, double maxValue, double presetBucketWidth) {
        double newBucketWidth = -1.0;
        if (minValue >= maxValue) {
            return Double.NaN;
        }
        if (maxValue - minValue < presetBucketWidth) {
            newBucketWidth = (maxValue - minValue) / 2.0;
        } else {
            double currentNumberOfBuckets = (maxValue - minValue) / presetBucketWidth;
            if (currentNumberOfBuckets <= 100.0) {
                newBucketWidth = presetBucketWidth;
            } else {
                double widthFactor = currentNumberOfBuckets / 100.0;
                newBucketWidth = Math.ceil(presetBucketWidth * widthFactor);
            }
        }
        return newBucketWidth;
    }

    private synchronized int assignMeasurementsToClasses(HashMap<Integer, Integer> histClasses, double histWidth, Collection<Measurement> collMeasurements) {
        int maxHistClass = 0;
        for (Measurement measurement : collMeasurements) {
            TimeSpanMeasurement tsm = (TimeSpanMeasurement)measurement;
            int histogramClassNumber = (int)(tsm.getTimeSpan() / histWidth);
            Integer classNumber = histClasses.get(histogramClassNumber);
            if (classNumber == null) {
                histClasses.put(histogramClassNumber, 1);
            } else {
                histClasses.put(histogramClassNumber, classNumber + 1);
            }
            if (maxHistClass >= histogramClassNumber) continue;
            maxHistClass = histogramClassNumber;
        }
        return maxHistClass;
    }

    @Override
    public synchronized Object getAdaptedObject() {
        double histBucketWidth = (Double)this.adapterProperties.get(HISTOGRAM_WIDTH);
        if (histBucketWidth <= 0.0) {
            throw new RuntimeException("Histogram width must be > 0");
        }
        this.logger.debug((Object)("TEST Hist: histWidth " + histBucketWidth));
        Histogram histogram = new Histogram(this.samInformation.getSensor().getSensorName(), histBucketWidth);
        HashMap<Integer, Integer> histClasses = new HashMap<Integer, Integer>();
        int maxHistClass = this.assignMeasurementsToClasses(histClasses, histBucketWidth, this.samInformation.getMeasurements());
        this.storeClassifiedMeasurementsInHistogram(histogram, histClasses, maxHistClass, histBucketWidth);
        return histogram;
    }

    private boolean checkClasses(HashMap<Integer, Integer> histClasses, int sum) {
        int mySum = 0;
        for (Integer key : histClasses.keySet()) {
            mySum += histClasses.get(key).intValue();
        }
        return mySum == sum;
    }

    private void storeClassifiedMeasurementsInHistogram(Histogram histogram, HashMap<Integer, Integer> histClasses, int maxHistClass, double histWidth) {
        Object[] keyset = histClasses.keySet().toArray(new Integer[0]);
        Arrays.sort(keyset);
        Object largestKeyValue = keyset[keyset.length - 1];
        if ((Integer)largestKeyValue > maxHistClass) {
            this.logger.error((Object)("largers classes key " + largestKeyValue + ">" + maxHistClass + " maxHistClass"));
        }
        boolean firstValueFound = false;
        double totalCount = this.samInformation.getMeasurements().size();
        this.logger.debug((Object)("Total elements count: " + totalCount));
        int histogramClassesIndex = 0;
        while (histogramClassesIndex <= maxHistClass) {
            Integer histClassFrequency = histClasses.get(histogramClassesIndex);
            if (histClassFrequency == null || histClassFrequency == 0) {
                if (firstValueFound) {
                    histogram.addEntity(new HistogramBucketInformation(0.0, (double)histogramClassesIndex * histWidth));
                }
            } else {
                firstValueFound = true;
                double currFrequency = histClassFrequency.doubleValue();
                double currProbability = currFrequency / totalCount;
                double currBucketStartValue = (double)histogramClassesIndex * histWidth;
                this.logger.debug((Object)("Index " + histogramClassesIndex + ", freq " + histClassFrequency + ", probability " + currProbability + ", value " + currBucketStartValue));
                histogram.addEntity(new HistogramBucketInformation(currProbability, currBucketStartValue));
            }
            ++histogramClassesIndex;
        }
    }
}

