/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.sensorframework.dao.memory;

import de.uka.ipd.sdq.sensorframework.entities.ExperimentRun;
import de.uka.ipd.sdq.sensorframework.entities.Measurement;
import de.uka.ipd.sdq.sensorframework.entities.dao.IDAOFactory;
import de.uka.ipd.sdq.sensorframework.entities.dao.IExperimentRunDAO;
import de.uka.ipd.sdq.sensorframework.entities.impl.ExperimentRunImpl;
import de.uka.ipd.sdq.sensorframework.entities.impl.ScalabilityExperimentRunImpl;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;

public class MemoryExperimentRunDAO
implements IExperimentRunDAO {
    private long nextID = 0L;
    private IDAOFactory myFactory;
    private HashMap<Long, ExperimentRun> index = new HashMap();

    public MemoryExperimentRunDAO(IDAOFactory memoryDAOFactory) {
        this.myFactory = memoryDAOFactory;
    }

    @Override
    public synchronized ExperimentRun addExperimentRun(String p_experimentdatetime) {
        ExperimentRunImpl result = new ExperimentRunImpl(this.myFactory);
        result.setExperimentRunID(this.nextID++);
        result.setExperimentDateTime(p_experimentdatetime);
        this.index.put(result.getExperimentRunID(), result);
        return result;
    }

    @Override
    public synchronized ExperimentRun addScalabilityExperimentRun(String p_experimentdatetime) {
        ScalabilityExperimentRunImpl result = new ScalabilityExperimentRunImpl(this.myFactory);
        result.setExperimentRunID(this.nextID++);
        result.setExperimentDateTime(p_experimentdatetime);
        this.index.put(result.getExperimentRunID(), result);
        return result;
    }

    @Override
    public synchronized ExperimentRun get(long id) {
        return this.index.get(id);
    }

    @Override
    public synchronized Collection<ExperimentRun> getExperimentRuns() {
        return Collections.unmodifiableCollection(this.index.values());
    }

    public void store(ExperimentRun er) {
    }

    @Override
    public synchronized void removeExperimentRun(ExperimentRun experimentRun, boolean doCascade) {
        if (experimentRun == null) {
            return;
        }
        if (doCascade) {
            for (Measurement measurement : experimentRun.getMeasurements()) {
                this.myFactory.createMeasurementDAO().removeMeasurement(measurement, true);
            }
        }
        this.index.remove(experimentRun.getExperimentRunID());
    }

    @Override
    public void storeAll() {
    }
}

