/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.sensorframework.dao.file.entities;

import de.uka.ipd.sdq.sensorframework.dao.file.FileManager;
import de.uka.ipd.sdq.sensorframework.dao.file.entities.AbstractSensorAndMeasurements;
import de.uka.ipd.sdq.sensorframework.dao.file.entities.TimeSpanMeasurementImpl;
import de.uka.ipd.sdq.sensorframework.entities.ExperimentRun;
import de.uka.ipd.sdq.sensorframework.entities.Measurement;
import de.uka.ipd.sdq.sensorframework.entities.Sensor;
import de.uka.ipd.sdq.sensorframework.storage.lists.BackgroundMemoryList;
import de.uka.ipd.sdq.sensorframework.storage.lists.DoubleSerialiser;
import de.uka.ipd.sdq.sensorframework.storage.lists.ISerialiser;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class TimeSpanSensorAndMeasurement
extends AbstractSensorAndMeasurements {
    private static final long serialVersionUID = 3516448762554779531L;
    private BackgroundMemoryList<Double> timeSpans = new BackgroundMemoryList(this.getMeasurementsFileName(), (ISerialiser)new DoubleSerialiser());

    public TimeSpanSensorAndMeasurement(FileManager fm, ExperimentRun er, Sensor sensor) throws IOException {
        super(fm, er, sensor);
        fm.addOpenList(this.timeSpans);
    }

    public synchronized void addTimeSpan(double et, double ts) {
        this.eventTimes.add((Object)et);
        this.timeSpans.add((Object)ts);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof TimeSpanSensorAndMeasurement)) {
            return false;
        }
        TimeSpanSensorAndMeasurement sam = (TimeSpanSensorAndMeasurement)obj;
        return super.equals(obj) && this.equalTimeSpans(this, sam);
    }

    private boolean equalTimeSpans(TimeSpanSensorAndMeasurement sam1, TimeSpanSensorAndMeasurement sam2) {
        if (sam1.timeSpans.size() == sam2.timeSpans.size()) {
            int i = 0;
            while (i < sam1.timeSpans.size()) {
                if (sam1.timeSpans.get(i) != sam2.timeSpans.get(i)) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    @Override
    public synchronized List<Measurement> getMeasurements() {
        ArrayList<Measurement> m = new ArrayList<Measurement>();
        int i = 0;
        while (i < this.timeSpans.size()) {
            m.add(new TimeSpanMeasurementImpl(i, (Double)this.eventTimes.get(i), (Double)this.timeSpans.get(i)));
            ++i;
        }
        return m;
    }

    @Override
    public void store() {
        super.store();
        try {
            this.timeSpans.flush();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

