/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.sensorframework.dao.file.entities;

import de.uka.ipd.sdq.sensorframework.dao.file.FileDAOFactory;
import de.uka.ipd.sdq.sensorframework.dao.file.entities.AbstractFileEntity;
import de.uka.ipd.sdq.sensorframework.dao.file.entities.AbstractSensorAndMeasurements;
import de.uka.ipd.sdq.sensorframework.dao.file.entities.ScalabilitySensorAndMeasurement;
import de.uka.ipd.sdq.sensorframework.dao.file.entities.StateSensorAndMeasurement;
import de.uka.ipd.sdq.sensorframework.dao.file.entities.TimeSpanSensorAndMeasurement;
import de.uka.ipd.sdq.sensorframework.entities.Experiment;
import de.uka.ipd.sdq.sensorframework.entities.ExperimentRun;
import de.uka.ipd.sdq.sensorframework.entities.Measurement;
import de.uka.ipd.sdq.sensorframework.entities.ScalabilityMeasurement;
import de.uka.ipd.sdq.sensorframework.entities.ScalabilitySensor;
import de.uka.ipd.sdq.sensorframework.entities.Sensor;
import de.uka.ipd.sdq.sensorframework.entities.SensorAndMeasurements;
import de.uka.ipd.sdq.sensorframework.entities.State;
import de.uka.ipd.sdq.sensorframework.entities.StateMeasurement;
import de.uka.ipd.sdq.sensorframework.entities.StateSensor;
import de.uka.ipd.sdq.sensorframework.entities.TimeSpanMeasurement;
import de.uka.ipd.sdq.sensorframework.entities.TimeSpanSensor;
import de.uka.ipd.sdq.sensorframework.entities.dao.IDAOFactory;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;

public class ExperimentRunImpl
extends AbstractFileEntity
implements ExperimentRun,
Serializable {
    private static final long serialVersionUID = 6496657460961660218L;
    private long experimentRunID;
    private String experimentDateTime;
    private transient HashMap<Long, AbstractSensorAndMeasurements> measurementsForSensor = new HashMap();
    public long idOfParentExperiment;

    public ExperimentRunImpl(IDAOFactory factory) {
        super(factory);
    }

    @Override
    public void addMeasurement(Measurement value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ScalabilityMeasurement addScalabilityMeasurement(ScalabilitySensor p_sensor, Double[] p_parameters, double p_result) {
        AbstractSensorAndMeasurements sam = this.saveGetSensorAndMeasurements(p_sensor);
        ((ScalabilitySensorAndMeasurement)sam).addResult(p_parameters, p_result);
        return null;
    }

    @Override
    public StateMeasurement addStateMeasurement(StateSensor p_sensor, State p_sensorstate, double p_eventtime) {
        if (p_sensor == null || p_sensorstate == null) {
            throw new IllegalArgumentException("p_sensor or p_sensorstate is null, eventtime is " + p_eventtime);
        }
        AbstractSensorAndMeasurements sam = this.saveGetSensorAndMeasurements(p_sensor);
        ((StateSensorAndMeasurement)sam).addState(p_eventtime, p_sensorstate);
        return null;
    }

    @Override
    public TimeSpanMeasurement addTimeSpanMeasurement(TimeSpanSensor p_sensor, double p_eventtime, double p_timespan) {
        AbstractSensorAndMeasurements sam = this.saveGetSensorAndMeasurements(p_sensor);
        ((TimeSpanSensorAndMeasurement)sam).addTimeSpan(p_eventtime, p_timespan);
        return null;
    }

    private AbstractSensorAndMeasurements createMeasurementStorage(Sensor sensor) {
        AbstractSensorAndMeasurements sam;
        block5: {
            sam = null;
            try {
                if (sensor instanceof TimeSpanSensor) {
                    sam = new TimeSpanSensorAndMeasurement(((FileDAOFactory)this.factory).getFileManager(), this, sensor);
                    break block5;
                }
                if (sensor instanceof StateSensor) {
                    sam = new StateSensorAndMeasurement(((FileDAOFactory)this.factory).getFileManager(), this, sensor);
                    break block5;
                }
                if (sensor instanceof ScalabilitySensor) {
                    sam = new ScalabilitySensorAndMeasurement(((FileDAOFactory)this.factory).getFileManager(), this, sensor);
                    break block5;
                }
                throw new RuntimeException("Invalid sensor type found: " + sensor.getClass() + " is not a TimeSpanSensor, a StateSensor, " + "or a Scalability sensor - fix your implementation, please!");
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        this.measurementsForSensor.put(sensor.getSensorID(), sam);
        return sam;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ExperimentRunImpl)) {
            return false;
        }
        ExperimentRunImpl er = (ExperimentRunImpl)obj;
        return this.experimentRunID == er.getExperimentRunID() && this.experimentDateTime.equals(er.getExperimentDateTime());
    }

    @Override
    public String getExperimentDateTime() {
        return this.experimentDateTime;
    }

    @Override
    public long getExperimentRunID() {
        return this.experimentRunID;
    }

    @Override
    public long getID() {
        return this.getExperimentRunID();
    }

    @Override
    public Collection<Measurement> getMeasurements() {
        ArrayList<Measurement> m = new ArrayList<Measurement>();
        for (Sensor s : this.getParentExperiment().getSensors()) {
            m.addAll(this.getMeasurementsOfSensor(s).getMeasurements());
        }
        return m;
    }

    @Override
    public SensorAndMeasurements getMeasurementsOfSensor(Sensor sensor) {
        if (!this.getParentExperiment().getSensors().contains(sensor)) {
            throw new IllegalArgumentException("Error: Sensor given is not part of this experiment " + sensor.getSensorName());
        }
        AbstractSensorAndMeasurements sam = this.saveGetSensorAndMeasurements(sensor);
        return new SensorAndMeasurements(sensor, sam.getMeasurements());
    }

    private Experiment getParentExperiment() {
        return this.factory.createExperimentDAO().get(this.idOfParentExperiment);
    }

    private AbstractSensorAndMeasurements saveGetSensorAndMeasurements(Sensor sensor) {
        AbstractSensorAndMeasurements sam = this.measurementsForSensor.get(sensor.getSensorID());
        if (sam == null) {
            sam = this.createMeasurementStorage(sensor);
        }
        return sam;
    }

    @Override
    public void setExperimentDateTime(String experimetDateTime) {
        this.experimentDateTime = experimetDateTime;
    }

    @Override
    public void setExperimentRunID(long experimentRunID) {
        this.experimentRunID = experimentRunID;
    }

    @Override
    public void setFactory(FileDAOFactory factory) {
        super.setFactory(factory);
        if (this.measurementsForSensor == null) {
            this.measurementsForSensor = new HashMap();
        }
    }

    public void setParentExperimentID(long id) {
        this.idOfParentExperiment = id;
    }
}

