/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.sensorframework.dao.file;

import de.uka.ipd.sdq.sensorframework.SensorFrameworkPluginActivator;
import de.uka.ipd.sdq.sensorframework.dao.file.FileExperimentDAO;
import de.uka.ipd.sdq.sensorframework.dao.file.FileExperimentRunDAO;
import de.uka.ipd.sdq.sensorframework.dao.file.FileManager;
import de.uka.ipd.sdq.sensorframework.dao.file.FileSensorDAO;
import de.uka.ipd.sdq.sensorframework.dao.file.FileStateDAO;
import de.uka.ipd.sdq.sensorframework.dao.file.IDGenerator;
import de.uka.ipd.sdq.sensorframework.entities.dao.IDAOFactory;
import de.uka.ipd.sdq.sensorframework.entities.dao.IExperimentDAO;
import de.uka.ipd.sdq.sensorframework.entities.dao.IExperimentRunDAO;
import de.uka.ipd.sdq.sensorframework.entities.dao.IMeasurementDAO;
import de.uka.ipd.sdq.sensorframework.entities.dao.ISensorDAO;
import de.uka.ipd.sdq.sensorframework.entities.dao.IStateDAO;

public class FileDAOFactory
implements IDAOFactory {
    public static final String EXP_FILE_NAME_PREFIX = "experiment";
    public static final String EXPRUN_FILE_NAME_PREFIX = "exprun";
    public static final String SENSOR_FILE_NAME_PREFIX = "sensor";
    public static final String STATE_FILE_NAME_PREFIX = "state";
    public static final String IDGEN_FILE_NAME_PREFIX = "id_generator";
    public static final String SUFFIX = ".ser";
    private IExperimentDAO experimentDAO;
    private IExperimentRunDAO experimentRunDAO;
    private ISensorDAO sensorDAO;
    private IStateDAO stateDAO;
    private IDGenerator idGen;
    private FileManager fileManager;
    private long factoryID;

    public FileDAOFactory(String rootDirectory) {
        this(-1L, rootDirectory);
    }

    public FileDAOFactory(long id, String rootDirectory) {
        this.factoryID = id;
        this.fileManager = new FileManager(rootDirectory, this);
        this.idGen = this.createIdGenerator();
    }

    private IDGenerator createIdGenerator() {
        IDGenerator result = (IDGenerator)this.fileManager.deserializeFromFile(IDGEN_FILE_NAME_PREFIX);
        if (result == null) {
            result = new IDGenerator();
        }
        return result;
    }

    public String getRootDirectory() {
        return this.fileManager.getRootDirectory();
    }

    @Override
    public IExperimentDAO createExperimentDAO() {
        if (this.experimentDAO == null) {
            this.experimentDAO = new FileExperimentDAO(this, this.idGen);
        }
        return this.experimentDAO;
    }

    @Override
    public IExperimentRunDAO createExperimentRunDAO() {
        if (this.experimentRunDAO == null) {
            this.experimentRunDAO = new FileExperimentRunDAO(this, this.idGen);
        }
        return this.experimentRunDAO;
    }

    @Override
    public IMeasurementDAO createMeasurementDAO() {
        throw new UnsupportedOperationException();
    }

    @Override
    public ISensorDAO createSensorDAO() {
        if (this.sensorDAO == null) {
            this.sensorDAO = new FileSensorDAO(this, this.idGen);
        }
        return this.sensorDAO;
    }

    @Override
    public IStateDAO createStateDAO() {
        if (this.stateDAO == null) {
            this.stateDAO = new FileStateDAO(this, this.idGen);
        }
        return this.stateDAO;
    }

    @Override
    public void finalizeAndClose() {
        this.fileManager.closeAllLists();
        this.fileManager.serializeToFile(IDGEN_FILE_NAME_PREFIX, this.idGen);
        if (this.experimentDAO != null) {
            ((FileExperimentDAO)this.experimentDAO).dispose();
        }
        if (this.sensorDAO != null) {
            ((FileSensorDAO)this.sensorDAO).dispose();
        }
        if (this.stateDAO != null) {
            ((FileStateDAO)this.stateDAO).dispose();
        }
        if (this.experimentRunDAO != null) {
            ((FileExperimentRunDAO)this.experimentRunDAO).dispose();
        }
    }

    public FileManager getFileManager() {
        return this.fileManager;
    }

    @Override
    public String getDescription() {
        return this.fileManager.getRootDirectory();
    }

    @Override
    public long getID() {
        return this.factoryID;
    }

    @Override
    public String getName() {
        return "File Datasource";
    }

    @Override
    public String getPersistendInfo() {
        return this.fileManager.getRootDirectory();
    }

    @Override
    public void setID(long i) {
        this.factoryID = i;
    }

    @Override
    public void reload() {
        String oldFilename = "";
        boolean failed = false;
        try {
            oldFilename = this.fileManager.getRootDirectory();
            this.fileManager.closeAllLists();
        }
        catch (Exception ex) {
            SensorFrameworkPluginActivator.log(4, "Closing the open File Provider failed", ex);
            failed = true;
        }
        this.experimentDAO = null;
        this.experimentRunDAO = null;
        this.sensorDAO = null;
        this.stateDAO = null;
        try {
            this.fileManager = new FileManager(oldFilename, this);
            this.idGen = this.createIdGenerator();
        }
        catch (Exception ex) {
            SensorFrameworkPluginActivator.log(4, "Closing the open File Provider failed", ex);
            failed = true;
        }
        if (failed) {
            throw new RuntimeException("Reloading the file provider with ID " + this.getID() + " failed. Consult the Error Log for Details.");
        }
    }

    @Override
    public void store() {
        this.fileManager.serializeToFile(IDGEN_FILE_NAME_PREFIX, this.idGen);
        if (this.experimentDAO != null) {
            ((FileExperimentDAO)this.experimentDAO).storeAll();
        }
        if (this.sensorDAO != null) {
            ((FileSensorDAO)this.sensorDAO).storeAll();
        }
        if (this.stateDAO != null) {
            ((FileStateDAO)this.stateDAO).storeAll();
        }
        if (this.experimentRunDAO != null) {
            ((FileExperimentRunDAO)this.experimentRunDAO).storeAll();
        }
    }
}

