/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.sensorframework.dao.file;

import de.uka.ipd.sdq.sensorframework.dao.file.FileDAOFactory;
import de.uka.ipd.sdq.sensorframework.dao.file.IDGenerator;
import de.uka.ipd.sdq.sensorframework.dao.file.entities.SerializableEntity;
import de.uka.ipd.sdq.sensorframework.entities.dao.IDAOFactory;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;

public abstract class AbstractFileDAO<T> {
    protected FileDAOFactory factory = null;
    private String myPrefix;
    protected IDGenerator idGen;
    private HashMap<Long, T> entitiesCache = null;

    public AbstractFileDAO(IDAOFactory factory, IDGenerator idGen, String prefix) {
        this.factory = (FileDAOFactory)factory;
        this.idGen = idGen;
        this.myPrefix = prefix;
        this.loadDataFromStorage();
    }

    private void loadDataFromStorage() {
        this.entitiesCache = (HashMap)this.factory.getFileManager().deserializeFromFile(this.myPrefix);
        if (this.entitiesCache == null) {
            this.entitiesCache = new HashMap();
        } else {
            for (T value : this.entitiesCache.values()) {
                SerializableEntity serializable = (SerializableEntity)value;
                serializable.setFactory(this.factory);
            }
        }
    }

    public void storeAll() {
        this.factory.getFileManager().serializeToFile(this.myPrefix, this.entitiesCache);
    }

    public T get(long id) {
        if (!this.entitiesCache.containsKey(id)) {
            throw new IllegalArgumentException("Entity with ID " + id + " not found in DAO");
        }
        return this.entitiesCache.get(id);
    }

    protected void putEntity(T entity) {
        SerializableEntity serialisable = (SerializableEntity)entity;
        if (this.entitiesCache.containsKey(serialisable.getID())) {
            throw new IllegalArgumentException("Entity with ID " + serialisable.getID() + " already exists in this DAO");
        }
        this.entitiesCache.put(serialisable.getID(), entity);
    }

    protected Collection<T> getAllEntities() {
        return Collections.unmodifiableCollection(this.entitiesCache.values());
    }

    public void removeEntity(T entity, boolean doCascade) {
        if (entity == null) {
            throw new IllegalArgumentException("Entity can not be null");
        }
        if (!this.entitiesCache.containsValue(entity)) {
            throw new IllegalArgumentException("Entity not controlled by this DAO");
        }
        if (doCascade) {
            throw new UnsupportedOperationException();
        }
        this.entitiesCache.remove(((SerializableEntity)entity).getID());
    }

    public void dispose() {
        this.storeAll();
        this.entitiesCache.clear();
    }
}

