/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.sensorframework;

import de.uka.ipd.sdq.sensorframework.entities.dao.IDAOFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;

public class SensorFrameworkDataset {
    private static SensorFrameworkDataset singleton = new SensorFrameworkDataset();
    private ArrayList<IDAOFactory> datasources = new ArrayList();
    private long nextID = 1L;

    private SensorFrameworkDataset() {
    }

    public static SensorFrameworkDataset singleton() {
        return singleton;
    }

    public synchronized Collection<IDAOFactory> getDataSources() {
        return Collections.unmodifiableCollection(this.datasources);
    }

    public synchronized IDAOFactory getDataSourceByID(long id) {
        for (IDAOFactory f : this.datasources) {
            if (f.getID() != id) continue;
            return f;
        }
        return null;
    }

    public synchronized void addDataSource(IDAOFactory dataSource) {
        for (IDAOFactory f : this.datasources) {
            if (f.getID() == dataSource.getID()) {
                throw new RuntimeException("Attemped to add Datasource (of a type inherting from IDAOFactory) with an ID already existing in the Sensorframework Dataset.");
            }
            if (f.getID() != this.nextID || dataSource.getID() != -1L) continue;
            throw new RuntimeException("Conflict of IDs occurred when attemping to add a new datasource to the Sensorframework Dataset.");
        }
        this.datasources.add(dataSource);
        if (dataSource.getID() == -1L) {
            dataSource.setID(this.nextID);
            ++this.nextID;
        } else if (dataSource.getID() >= this.nextID) {
            this.nextID = Long.MIN_VALUE;
            for (IDAOFactory f : this.datasources) {
                if (f.getID() < this.nextID) continue;
                this.nextID = f.getID() + 1L;
            }
        }
    }

    public synchronized void removeDataSource(IDAOFactory factory) {
        factory.finalizeAndClose();
        this.datasources.remove(factory);
    }

    public synchronized void removeAllDataSources() {
        while (this.datasources.size() > 0) {
            this.removeDataSource(this.datasources.get(0));
        }
    }

    public synchronized void reload() {
        String errorMessage = "";
        boolean failed = false;
        for (IDAOFactory f : this.datasources) {
            try {
                f.reload();
            }
            catch (Exception e) {
                failed = true;
                errorMessage = String.valueOf(errorMessage) + ">" + e.getMessage() + "< ";
                this.removeDataSource(f);
            }
        }
        if (failed) {
            throw new RuntimeException("Some Datasources failed to reload. Please see Error Log for details. Details: " + errorMessage);
        }
    }
}

