/*
 * Decompiled with CFR 0.152.
 */
package eu.qimpress.ide.tradeoff.ahp;

import Jama.Matrix;
import eu.qimpress.ide.tradeoff.ahp.AHPWizard;
import eu.qimpress.resultmodel.AlternativeEvaluation;
import eu.qimpress.resultmodel.CpuResourceUtilization;
import eu.qimpress.resultmodel.MaintainabilityPredictionResult;
import eu.qimpress.resultmodel.PerformancePredictionResult;
import eu.qimpress.resultmodel.Reliability;
import eu.qimpress.resultmodel.ReliabilityPredictionResult;
import eu.qimpress.resultmodel.ResponseTime;
import eu.qimpress.resultmodel.ResultDistribution;
import eu.qimpress.samm.deployment.targetenvironment.ExecutionResource;
import eu.qimpress.samm.deployment.targetenvironment.StorageResource;
import eu.qimpress.samm.usagemodel.SystemCall;
import eu.qimpress.samm.usagemodel.UsageScenario;
import java.util.ArrayList;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class ValueRatingPage
extends WizardPage {
    public static final String PAGE_NAME = "Value Rating";
    private static double[] translate = new double[]{0.1111111111111111, 0.14285714285714285, 0.2, 0.3333333333333333, 1.0, 3.0, 5.0, 7.0, 9.0};
    private Matrix[] valueMatrix;
    private int[][] settings;
    private ArrayList<AlternativeEvaluation> evaluations;
    private int numEvals;
    private boolean[] QualityInUse;
    private ScrolledComposite sc;
    private Composite globalParent;
    private static String newline = "\n";

    public ValueRatingPage(Matrix[] m, ArrayList<AlternativeEvaluation> evaluations, int[][] is, boolean[] qualityInUse) {
        super(PAGE_NAME, "Assess alternatives", null);
        this.setDescription("Please rate actual values to be compared using AHP analysis");
        this.valueMatrix = m;
        this.settings = is;
        this.evaluations = evaluations;
        this.numEvals = evaluations.size();
        this.QualityInUse = qualityInUse;
    }

    public void createControl(Composite parent) {
        this.globalParent = parent;
        this.drawControl(this.QualityInUse);
    }

    public void drawControl(boolean[] qualityInUse) {
        this.QualityInUse = qualityInUse;
        Composite parent = this.globalParent;
        if (this.sc != null) {
            this.sc.dispose();
        }
        this.sc = new ScrolledComposite(parent, 768);
        Composite topLevel = new Composite((Composite)this.sc, 0);
        this.sc.setContent((Control)topLevel);
        topLevel.setLayout((Layout)new GridLayout(3, false));
        GridData radioWidth = new GridData();
        radioWidth.widthHint = 30;
        radioWidth.horizontalAlignment = 0x1000000;
        radioWidth.verticalAlignment = 0x1000000;
        Label q1 = new Label(topLevel, 0);
        q1.setText("Value");
        q1.setLayoutData((Object)new GridData(0x1000008));
        Composite titlesComposite = new Composite(topLevel, 0);
        titlesComposite.setLayout((Layout)new GridLayout(9, false));
        String[] titles = new String[]{"EX", "VS", "ST", "MO", "EQ", "MO", "ST", "VS", "EX"};
        int i = 0;
        while (i < 9) {
            Label l = new Label(titlesComposite, 0x1000000);
            l.setText(titles[i]);
            l.setLayoutData((Object)radioWidth);
            ++i;
        }
        titlesComposite.pack();
        Label q2 = new Label(topLevel, 0);
        q2.setText("Value");
        q2.setLayoutData((Object)new GridData(1));
        if (this.QualityInUse[AHPWizard.Qualities.UTILIZATION.ordinal()]) {
            this.createComparisonBatch(topLevel, radioWidth, AHPWizard.Qualities.UTILIZATION);
        }
        if (this.QualityInUse[AHPWizard.Qualities.COST.ordinal()]) {
            this.createComparisonBatch(topLevel, radioWidth, AHPWizard.Qualities.COST);
        }
        if (this.QualityInUse[AHPWizard.Qualities.RELIABILITY.ordinal()]) {
            this.createComparisonBatch(topLevel, radioWidth, AHPWizard.Qualities.RELIABILITY);
        }
        if (this.QualityInUse[AHPWizard.Qualities.RESPONSETIME.ordinal()]) {
            this.createComparisonBatch(topLevel, radioWidth, AHPWizard.Qualities.RESPONSETIME);
        }
        if (this.QualityInUse[AHPWizard.Qualities.HDDUTILIZATION.ordinal()]) {
            this.createComparisonBatch(topLevel, radioWidth, AHPWizard.Qualities.HDDUTILIZATION);
        }
        if (this.QualityInUse[AHPWizard.Qualities.THROUGHPUT.ordinal()]) {
            this.createComparisonBatch(topLevel, radioWidth, AHPWizard.Qualities.THROUGHPUT);
        }
        Label description = new Label(topLevel, 0);
        description.setText("Legend of quality ratings:\nEX Extreme\nVS Very Strong\nST Strong\nMO Moderate\nEQ Equal");
        GridData descgrid = new GridData();
        descgrid.verticalSpan = 3;
        description.setLayoutData((Object)descgrid);
        topLevel.pack(true);
        parent.layout(true, true);
        parent.pack();
        parent.redraw();
        this.setControl((Control)this.sc);
        this.setPageComplete(true);
    }

    private void createComparisonBatch(Composite parent, GridData radioButtonWidth, AHPWizard.Qualities quality) {
        int I = 0;
        while (I < this.numEvals) {
            int J = I + 1;
            while (J < this.numEvals) {
                Label a = new Label(parent, 16384);
                a.setText(String.valueOf(this.evaluations.get(I).getName()) + ValueRatingPage.getValueForQuality(this.evaluations.get(I), quality));
                a.setToolTipText(ValueRatingPage.getToolTipForQuality(this.evaluations.get(I), quality));
                GridData agd = new GridData();
                agd.horizontalAlignment = 0x1000008;
                agd.verticalAlignment = 0x1000000;
                a.setLayoutData((Object)agd);
                Composite radioGroup = new Composite(parent, 0);
                radioGroup.setLayout((Layout)new GridLayout(9, false));
                int i = 0;
                while (i < 9) {
                    Button b = new Button(radioGroup, 16);
                    b.setLayoutData((Object)radioButtonWidth);
                    b.addSelectionListener((SelectionListener)new RadioListener(this.valueMatrix, quality.ordinal(), I, J, i));
                    b.setSelection(i == this.settings[quality.ordinal()][I * this.numEvals + J]);
                    ++i;
                }
                radioGroup.pack();
                Label b = new Label(parent, 16384);
                b.setText(String.valueOf(this.evaluations.get(J).getName()) + ValueRatingPage.getValueForQuality(this.evaluations.get(J), quality));
                b.setToolTipText(ValueRatingPage.getToolTipForQuality(this.evaluations.get(J), quality));
                GridData bgd = new GridData();
                bgd.horizontalAlignment = 1;
                bgd.verticalAlignment = 0x1000000;
                b.setLayoutData((Object)bgd);
                ++J;
            }
            ++I;
        }
    }

    public static String getToolTipForQuality(AlternativeEvaluation e, AHPWizard.Qualities q) {
        PerformancePredictionResult p;
        int i;
        String retval = "Alternative evaluation: " + e.getName() + newline;
        if (q == AHPWizard.Qualities.UTILIZATION) {
            i = 0;
            while (i < e.getAnalysisResults().size()) {
                if (e.getAnalysisResults().get(i) instanceof PerformancePredictionResult) {
                    p = (PerformancePredictionResult)e.getAnalysisResults().get(i);
                    for (CpuResourceUtilization cru : p.getResourceUtilizations()) {
                        retval = String.valueOf(retval) + "Utilization: " + ValueRatingPage.myToString(cru.getResultDistribution()) + " on " + ValueRatingPage.myToString(cru.getExecutionResource()) + newline;
                    }
                }
                ++i;
            }
        }
        if (q == AHPWizard.Qualities.RESPONSETIME) {
            i = 0;
            while (i < e.getAnalysisResults().size()) {
                if (e.getAnalysisResults().get(i) instanceof PerformancePredictionResult) {
                    p = (PerformancePredictionResult)e.getAnalysisResults().get(i);
                    for (ResponseTime r : p.getResponseTimes()) {
                        retval = String.valueOf(retval) + "Response time: " + ValueRatingPage.myToString(r.getResultDistribution()) + " on " + ValueRatingPage.myToString(r.getUsageScenario()) + newline;
                    }
                }
                ++i;
            }
        }
        if (q == AHPWizard.Qualities.HDDUTILIZATION) {
            i = 0;
            while (i < e.getAnalysisResults().size()) {
                if (e.getAnalysisResults().get(i) instanceof PerformancePredictionResult) {
                    p = (PerformancePredictionResult)e.getAnalysisResults().get(i);
                    for (ResponseTime r : p.getHddResourceUtilizations()) {
                        retval = String.valueOf(retval) + "HDD Utilization: " + ValueRatingPage.myToString(r.getResultDistribution()) + " on " + ValueRatingPage.myToString(r.getStorageResource()) + newline;
                    }
                }
                ++i;
            }
        }
        if (q == AHPWizard.Qualities.THROUGHPUT) {
            i = 0;
            while (i < e.getAnalysisResults().size()) {
                if (e.getAnalysisResults().get(i) instanceof PerformancePredictionResult) {
                    p = (PerformancePredictionResult)e.getAnalysisResults().get(i);
                    for (ResponseTime r : p.getThroughputs()) {
                        retval = String.valueOf(retval) + "Throughput: " + ValueRatingPage.myToString(r.getResultDistribution()) + " on " + ValueRatingPage.myToString(r.getUsageScenario()) + newline;
                    }
                }
                ++i;
            }
        }
        if (q == AHPWizard.Qualities.COST) {
            i = 0;
            while (i < e.getAnalysisResults().size()) {
                if (e.getAnalysisResults().get(i) instanceof MaintainabilityPredictionResult) {
                    MaintainabilityPredictionResult m = (MaintainabilityPredictionResult)e.getAnalysisResults().get(i);
                    retval = String.valueOf(retval) + "Cost: " + m.getAggregatedCosts() + newline;
                    retval = String.valueOf(retval) + "Time effort: " + m.getAggregatedTimeEffort() + newline;
                }
                ++i;
            }
        }
        if (q == AHPWizard.Qualities.RELIABILITY) {
            i = 0;
            while (i < e.getAnalysisResults().size()) {
                if (e.getAnalysisResults().get(i) instanceof ReliabilityPredictionResult) {
                    ReliabilityPredictionResult r = (ReliabilityPredictionResult)e.getAnalysisResults().get(i);
                    for (Reliability rel : r.getReliabilities()) {
                        retval = String.valueOf(retval) + "Reliability: " + ValueRatingPage.myToString(rel.getResultDistribution()) + " on " + ValueRatingPage.myToString(rel.getSystemCall()) + "\n";
                    }
                }
                ++i;
            }
        }
        return retval;
    }

    private static String myToString(StorageResource storageResource) {
        return storageResource.getName();
    }

    public static String myToString(ExecutionResource executionResource) {
        String str = executionResource.toString();
        return str.substring(str.indexOf(32) + 1);
    }

    public static String myToString(ResultDistribution rd) {
        String str = rd.toString();
        return str.substring(str.indexOf(32) + 1);
    }

    public static String myToString(SystemCall systemCall) {
        return systemCall.getName();
    }

    public static String myToString(UsageScenario usageScenario) {
        return usageScenario.getName();
    }

    public static String getValueForQuality(AlternativeEvaluation e, AHPWizard.Qualities q) {
        int count;
        double total;
        PerformancePredictionResult p;
        int i;
        String retval = "";
        if (q == AHPWizard.Qualities.UTILIZATION) {
            i = 0;
            while (i < e.getAnalysisResults().size()) {
                if (e.getAnalysisResults().get(i) instanceof PerformancePredictionResult) {
                    p = (PerformancePredictionResult)e.getAnalysisResults().get(i);
                    total = 0.0;
                    count = 0;
                    for (CpuResourceUtilization cru : p.getResourceUtilizations()) {
                        total += cru.getResultDistribution().getArithmeticMean();
                        ++count;
                    }
                    retval = String.valueOf(retval) + String.format("; Utilization: %.2f", total / (double)count);
                }
                ++i;
            }
        }
        if (q == AHPWizard.Qualities.RESPONSETIME) {
            i = 0;
            while (i < e.getAnalysisResults().size()) {
                if (e.getAnalysisResults().get(i) instanceof PerformancePredictionResult) {
                    p = (PerformancePredictionResult)e.getAnalysisResults().get(i);
                    total = 0.0;
                    count = 0;
                    for (ResponseTime r : p.getResponseTimes()) {
                        total += r.getResultDistribution().getArithmeticMean();
                        ++count;
                    }
                    retval = String.valueOf(retval) + String.format("; Response time: %.2f", total / (double)count);
                }
                ++i;
            }
        }
        if (q == AHPWizard.Qualities.HDDUTILIZATION) {
            i = 0;
            while (i < e.getAnalysisResults().size()) {
                if (e.getAnalysisResults().get(i) instanceof PerformancePredictionResult) {
                    p = (PerformancePredictionResult)e.getAnalysisResults().get(i);
                    total = 0.0;
                    count = 0;
                    for (ResponseTime r : p.getHddResourceUtilizations()) {
                        total += r.getResultDistribution().getArithmeticMean();
                        ++count;
                    }
                    retval = String.valueOf(retval) + String.format("; HDD Utilization: %.2f", total / (double)count);
                }
                ++i;
            }
        }
        if (q == AHPWizard.Qualities.THROUGHPUT) {
            i = 0;
            while (i < e.getAnalysisResults().size()) {
                if (e.getAnalysisResults().get(i) instanceof PerformancePredictionResult) {
                    p = (PerformancePredictionResult)e.getAnalysisResults().get(i);
                    total = 0.0;
                    count = 0;
                    for (ResponseTime r : p.getThroughputs()) {
                        total += r.getResultDistribution().getArithmeticMean();
                        ++count;
                    }
                    retval = String.valueOf(retval) + String.format("; Throughput: %.2f", total / (double)count);
                }
                ++i;
            }
        }
        if (q == AHPWizard.Qualities.COST) {
            i = 0;
            while (i < e.getAnalysisResults().size()) {
                if (e.getAnalysisResults().get(i) instanceof MaintainabilityPredictionResult) {
                    MaintainabilityPredictionResult m = (MaintainabilityPredictionResult)e.getAnalysisResults().get(i);
                    retval = String.valueOf(retval) + "; Cost: " + m.getAggregatedCosts() + ";Time effort: " + m.getAggregatedTimeEffort();
                }
                ++i;
            }
        }
        if (q == AHPWizard.Qualities.RELIABILITY) {
            i = 0;
            while (i < e.getAnalysisResults().size()) {
                if (e.getAnalysisResults().get(i) instanceof ReliabilityPredictionResult) {
                    ReliabilityPredictionResult r = (ReliabilityPredictionResult)e.getAnalysisResults().get(i);
                    total = 0.0;
                    count = 0;
                    for (Reliability rel : r.getReliabilities()) {
                        total += rel.getResultDistribution().getArithmeticMean();
                        ++count;
                    }
                    retval = String.valueOf(retval) + String.format("; Reliability: %g", total / (double)count);
                }
                ++i;
            }
        }
        return retval;
    }

    class RadioListener
    implements SelectionListener {
        private int quality;
        private int value;
        private int alt1;
        private int alt2;
        private Matrix[] valueMatrix;

        public RadioListener(Matrix[] m, int quality, int alt1, int alt2, int value) {
            this.alt1 = alt1;
            this.alt2 = alt2;
            this.value = value;
            this.valueMatrix = m;
            this.quality = quality;
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            this.widgetSelected(e);
        }

        public void widgetSelected(SelectionEvent e) {
            this.valueMatrix[this.quality].set(this.alt2, this.alt1, translate[this.value]);
            this.valueMatrix[this.quality].set(this.alt1, this.alt2, 1.0 / translate[this.value]);
            ((ValueRatingPage)ValueRatingPage.this).settings[this.quality][this.alt1 * ((ValueRatingPage)ValueRatingPage.this).numEvals + this.alt2] = this.value;
        }
    }
}

