/*
 * Decompiled with CFR 0.152.
 */
package eu.qimpress.ide.tradeoff.ahp;

import Jama.Matrix;
import eu.qimpress.ide.tradeoff.ahp.AHPDataPoint;
import eu.qimpress.ide.tradeoff.ahp.AHPWizard;
import eu.qimpress.resultmodel.AlternativeEvaluation;
import java.awt.Color;
import java.awt.Paint;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Vector;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;
import org.jfree.experimental.chart.swt.ChartComposite;

public class ResultsPage
extends WizardPage {
    public static final String PAGE_NAME = "AHP Analysis Results";
    private Matrix qualityMatrix;
    private Matrix[] valueMatrix;
    private boolean[] QualityInUse;
    private TableColumn[] dataTableColumns;
    private TableColumn totalTableColumn;
    private ArrayList<AlternativeEvaluation> evaluations;
    private int numRes;
    private Composite topLevel;
    private double[] results;
    DefaultCategoryDataset dataset;
    Button normalizeCheck;
    public boolean NORMALIZE = false;
    public Vector<String> stringCriteria;
    public Text txtfilename;
    private TableColumn alternativeTableColumn;
    private Table resultBreakDownTable;
    private Composite globalParent;
    public JFreeChart chart;
    public Vector<Vector<String>> stringResults;
    private int currentNumberOfQualities;

    public ResultsPage(AHPDataPoint ahpDataPoint, ArrayList<AlternativeEvaluation> evaluations, boolean[] qualityInUse) {
        super(PAGE_NAME, "Interpet results", null);
        this.qualityMatrix = ahpDataPoint.getQualityMatrix();
        this.valueMatrix = ahpDataPoint.getValueMatrix();
        this.evaluations = evaluations;
        this.numRes = evaluations.size();
        this.results = new double[this.numRes];
        this.QualityInUse = qualityInUse;
    }

    public void setVisible(boolean b) {
        super.setVisible(b);
        this.updateAhpResults();
        this.globalParent.getParent().layout(true, true);
        this.globalParent.getParent().redraw();
    }

    public void createControl(Composite parent) {
        this.globalParent = parent;
        this.drawControl(this.QualityInUse);
    }

    public void drawControl(boolean[] qualityInUse2) {
        this.QualityInUse = qualityInUse2;
        Composite parent = this.globalParent;
        this.currentNumberOfQualities = 0;
        int i = 0;
        while (i < this.QualityInUse.length) {
            if (this.QualityInUse[i]) {
                ++this.currentNumberOfQualities;
            }
            ++i;
        }
        if (this.topLevel != null) {
            this.topLevel.dispose();
        }
        this.topLevel = new Composite(parent, 0);
        this.topLevel.setLayout((Layout)new GridLayout(1, false));
        this.dataset = new DefaultCategoryDataset();
        this.chart = ChartFactory.createStackedBarChart((String)PAGE_NAME, (String)"Alternative Evaluations", (String)"Values", (CategoryDataset)this.dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
        CategoryPlot plot = (CategoryPlot)this.chart.getPlot();
        plot.setBackgroundPaint((Paint)Color.lightGray);
        plot.setDomainGridlinePaint((Paint)Color.white);
        plot.setDomainGridlinesVisible(true);
        plot.setRangeGridlinePaint((Paint)Color.white);
        ChartComposite frame = new ChartComposite(this.topLevel, 0, this.chart, true);
        GridData graphLayout = new GridData();
        graphLayout.grabExcessHorizontalSpace = true;
        graphLayout.grabExcessVerticalSpace = true;
        graphLayout.horizontalAlignment = 4;
        graphLayout.verticalAlignment = 4;
        frame.setLayoutData((Object)graphLayout);
        Composite textAndGridResultsComposite = new Composite(this.topLevel, 0);
        GridData gd1 = new GridData();
        gd1.grabExcessHorizontalSpace = true;
        gd1.horizontalAlignment = 4;
        textAndGridResultsComposite.setLayoutData((Object)gd1);
        textAndGridResultsComposite.setLayout((Layout)new GridLayout(2, false));
        Composite rbtComp = new Composite(this.topLevel, 0);
        GridData resultBreakDownTableCompositeLData = new GridData();
        resultBreakDownTableCompositeLData.grabExcessHorizontalSpace = true;
        resultBreakDownTableCompositeLData.horizontalAlignment = 4;
        resultBreakDownTableCompositeLData.verticalAlignment = 4;
        rbtComp.setLayoutData((Object)resultBreakDownTableCompositeLData);
        TableColumnLayout tcl = new TableColumnLayout();
        rbtComp.setLayout((Layout)tcl);
        this.resultBreakDownTable = new Table(rbtComp, 0);
        this.alternativeTableColumn = new TableColumn(this.resultBreakDownTable, 0);
        this.alternativeTableColumn.setText("Alternative");
        TableItem tableItem = new TableItem(this.resultBreakDownTable, 0);
        tableItem.setText("Bla");
        this.totalTableColumn = new TableColumn(this.resultBreakDownTable, 0);
        this.totalTableColumn.setText("Total");
        this.dataTableColumns = new TableColumn[this.currentNumberOfQualities];
        int i2 = 0;
        while (i2 < this.currentNumberOfQualities) {
            this.dataTableColumns[i2] = new TableColumn(this.resultBreakDownTable, 0);
            this.dataTableColumns[i2].setText("Utilization");
            ++i2;
        }
        this.resultBreakDownTable.setHeaderVisible(true);
        this.resultBreakDownTable.setLinesVisible(true);
        tcl.setColumnData((Widget)this.alternativeTableColumn, (ColumnLayoutData)new ColumnWeightData(20));
        tcl.setColumnData((Widget)this.totalTableColumn, (ColumnLayoutData)new ColumnWeightData(10));
        i2 = 0;
        while (i2 < this.currentNumberOfQualities) {
            tcl.setColumnData((Widget)this.dataTableColumns[i2], (ColumnLayoutData)new ColumnWeightData(16));
            ++i2;
        }
        this.normalizeCheck = new Button(this.topLevel, 32);
        this.normalizeCheck.setText("Normalize values");
        this.normalizeCheck.addSelectionListener((SelectionListener)new NormalizeBtnListener());
        this.updateAhpResults();
        Composite fileBrowser = new Composite(this.topLevel, 0);
        GridData fileBrowserGridData = new GridData();
        fileBrowserGridData.grabExcessHorizontalSpace = true;
        fileBrowserGridData.horizontalAlignment = 4;
        fileBrowser.setLayoutData((Object)fileBrowserGridData);
        fileBrowser.setLayout((Layout)new GridLayout(3, false));
        Label lblExport = new Label(fileBrowser, 0);
        lblExport.setText("Export results as:");
        this.txtfilename = new Text(fileBrowser, 2052);
        GridData txtfilenameGridData = new GridData();
        txtfilenameGridData.grabExcessHorizontalSpace = true;
        txtfilenameGridData.horizontalAlignment = 4;
        this.txtfilename.setLayoutData((Object)txtfilenameGridData);
        Button btnBrowse = new Button(fileBrowser, 8);
        btnBrowse.setText("Browse");
        btnBrowse.addSelectionListener((SelectionListener)new BrowseBtnListener());
        parent.layout(true, true);
        parent.pack();
        parent.redraw();
        this.setControl((Control)this.topLevel);
        this.setPageComplete(true);
    }

    private Matrix normalize(Matrix m) {
        Matrix ret = m.copy();
        int j = 0;
        while (j < ret.getColumnDimension()) {
            double sum = 0.0;
            int i = 0;
            while (i < ret.getRowDimension()) {
                sum += ret.get(i, j);
                ++i;
            }
            i = 0;
            while (i < ret.getRowDimension()) {
                ret.set(i, j, ret.get(i, j) / sum);
                ++i;
            }
            ++j;
        }
        return ret;
    }

    private Matrix normalizeQM(Matrix m) {
        Matrix ret = m.copy();
        int j = 0;
        while (j < ret.getColumnDimension()) {
            double sum = 0.0;
            int i = 0;
            while (i < ret.getRowDimension()) {
                if (this.QualityInUse[i] && this.QualityInUse[j]) {
                    sum += ret.get(i, j);
                }
                ++i;
            }
            i = 0;
            while (i < ret.getRowDimension()) {
                if (this.QualityInUse[i] && this.QualityInUse[j]) {
                    ret.set(i, j, ret.get(i, j) / sum);
                }
                ++i;
            }
            ++j;
        }
        return ret;
    }

    private double[] normalize(double[] arr) {
        double total = 0.0;
        double[] dArray = arr;
        int n = arr.length;
        int n2 = 0;
        while (n2 < n) {
            double d = dArray[n2];
            total += d;
            ++n2;
        }
        int i = 0;
        while (i < arr.length) {
            int n3 = i++;
            arr[n3] = arr[n3] / total;
        }
        return arr;
    }

    private double[] normalizeAndFilter(double[] arr) {
        double total = 0.0;
        int i = 0;
        while (i < arr.length) {
            if (this.QualityInUse[i]) {
                total += arr[i];
            }
            ++i;
        }
        i = 0;
        while (i < arr.length) {
            if (this.QualityInUse[i]) {
                int n = i;
                arr[n] = arr[n] / total;
            }
            ++i;
        }
        return arr;
    }

    private double[] averageQM(Matrix m) {
        double[] ret = new double[m.getRowDimension()];
        int i = 0;
        while (i < m.getRowDimension()) {
            if (this.QualityInUse[i]) {
                ret[i] = 0.0;
                int j = 0;
                while (j < m.getColumnDimension()) {
                    if (this.QualityInUse[j]) {
                        int n = i;
                        ret[n] = ret[n] + m.get(i, j);
                    }
                    ++j;
                }
            }
            ++i;
        }
        return ret;
    }

    private double[] average(Matrix m) {
        double[] ret = new double[m.getRowDimension()];
        int i = 0;
        while (i < m.getRowDimension()) {
            ret[i] = 0.0;
            int j = 0;
            while (j < m.getColumnDimension()) {
                int n = i;
                ret[n] = ret[n] + m.get(i, j);
                ++j;
            }
            ++i;
        }
        return ret;
    }

    private void updateAhpResults() {
        double[] criteria = this.averageQM(this.normalizeQM(this.qualityMatrix));
        double[][] criteriaArrays = new double[AHPWizard.QualityNames.length][];
        int i = 0;
        while (i < AHPWizard.QualityNames.length) {
            criteriaArrays[i] = this.average(this.normalize(this.valueMatrix[i]));
            ++i;
        }
        double resultsum = 0.0;
        int i2 = 0;
        while (i2 < this.numRes) {
            this.results[i2] = 0.0;
            int j = 0;
            while (j < AHPWizard.QualityNames.length) {
                int n = i2;
                this.results[n] = this.results[n] + criteriaArrays[j][i2] * criteria[j] * (double)(this.QualityInUse[j] ? 1 : 0);
                ++j;
            }
            resultsum += this.results[i2];
            ++i2;
        }
        double[] normalizedCriteria = criteria;
        if (this.NORMALIZE) {
            normalizedCriteria = this.normalizeAndFilter(criteria);
        }
        int counter = 0;
        if (this.QualityInUse[AHPWizard.Qualities.UTILIZATION.ordinal()]) {
            this.dataTableColumns[counter++].setText(String.format("Utilization (%.4f)", normalizedCriteria[AHPWizard.Qualities.UTILIZATION.ordinal()]));
        }
        if (this.QualityInUse[AHPWizard.Qualities.COST.ordinal()]) {
            this.dataTableColumns[counter++].setText(String.format("Cost (%.4f)", normalizedCriteria[AHPWizard.Qualities.COST.ordinal()]));
        }
        if (this.QualityInUse[AHPWizard.Qualities.RELIABILITY.ordinal()]) {
            this.dataTableColumns[counter++].setText(String.format("Reliability (%.4f)", normalizedCriteria[AHPWizard.Qualities.RELIABILITY.ordinal()]));
        }
        if (this.QualityInUse[AHPWizard.Qualities.RESPONSETIME.ordinal()]) {
            this.dataTableColumns[counter++].setText(String.format("Response Time (%.4f)", normalizedCriteria[AHPWizard.Qualities.RESPONSETIME.ordinal()]));
        }
        if (this.QualityInUse[AHPWizard.Qualities.HDDUTILIZATION.ordinal()]) {
            this.dataTableColumns[counter++].setText(String.format("HDD Utilization (%.4f)", normalizedCriteria[AHPWizard.Qualities.HDDUTILIZATION.ordinal()]));
        }
        if (this.QualityInUse[AHPWizard.Qualities.THROUGHPUT.ordinal()]) {
            this.dataTableColumns[counter++].setText(String.format("Throughput (%.4f)", normalizedCriteria[AHPWizard.Qualities.THROUGHPUT.ordinal()]));
        }
        this.stringCriteria = new Vector();
        if (this.QualityInUse[AHPWizard.Qualities.UTILIZATION.ordinal()]) {
            this.stringCriteria.add(String.format("Utilization (%.4f)", normalizedCriteria[AHPWizard.Qualities.UTILIZATION.ordinal()]));
        }
        if (this.QualityInUse[AHPWizard.Qualities.COST.ordinal()]) {
            this.stringCriteria.add(String.format("Cost (%.4f)", normalizedCriteria[AHPWizard.Qualities.COST.ordinal()]));
        }
        if (this.QualityInUse[AHPWizard.Qualities.RELIABILITY.ordinal()]) {
            this.stringCriteria.add(String.format("Reliability (%.4f)", normalizedCriteria[AHPWizard.Qualities.RELIABILITY.ordinal()]));
        }
        if (this.QualityInUse[AHPWizard.Qualities.RESPONSETIME.ordinal()]) {
            this.stringCriteria.add(String.format("Response Time (%.4f)", normalizedCriteria[AHPWizard.Qualities.RESPONSETIME.ordinal()]));
        }
        if (this.QualityInUse[AHPWizard.Qualities.HDDUTILIZATION.ordinal()]) {
            this.stringCriteria.add(String.format("HDD Utilization (%.4f)", normalizedCriteria[AHPWizard.Qualities.HDDUTILIZATION.ordinal()]));
        }
        if (this.QualityInUse[AHPWizard.Qualities.THROUGHPUT.ordinal()]) {
            this.stringCriteria.add(String.format("Thrughput (%.4f)", normalizedCriteria[AHPWizard.Qualities.THROUGHPUT.ordinal()]));
        }
        if (this.NORMALIZE) {
            this.results = this.normalize(this.results);
        }
        this.dataset.clear();
        this.resultBreakDownTable.removeAll();
        this.stringResults = new Vector();
        int i3 = 0;
        while (i3 < this.numRes) {
            double[] row = new double[AHPWizard.QualityNames.length];
            int j = 0;
            while (j < AHPWizard.QualityNames.length) {
                row[j] = criteriaArrays[j][i3] * criteria[j];
                ++j;
            }
            if (this.NORMALIZE) {
                row = this.normalizeAndFilter(row);
                j = 0;
                while (j < row.length) {
                    int n = j++;
                    row[n] = row[n] * this.results[i3];
                }
            }
            if (this.QualityInUse[AHPWizard.Qualities.UTILIZATION.ordinal()]) {
                this.dataset.addValue(row[AHPWizard.Qualities.UTILIZATION.ordinal()], (Comparable)((Object)"Utilization"), (Comparable)((Object)this.evaluations.get(i3).getName()));
            }
            if (this.QualityInUse[AHPWizard.Qualities.COST.ordinal()]) {
                this.dataset.addValue(row[AHPWizard.Qualities.COST.ordinal()], (Comparable)((Object)"Cost"), (Comparable)((Object)this.evaluations.get(i3).getName()));
            }
            if (this.QualityInUse[AHPWizard.Qualities.RELIABILITY.ordinal()]) {
                this.dataset.addValue(row[AHPWizard.Qualities.RELIABILITY.ordinal()], (Comparable)((Object)"Reliability"), (Comparable)((Object)this.evaluations.get(i3).getName()));
            }
            if (this.QualityInUse[AHPWizard.Qualities.RESPONSETIME.ordinal()]) {
                this.dataset.addValue(row[AHPWizard.Qualities.RESPONSETIME.ordinal()], (Comparable)((Object)"Response Time"), (Comparable)((Object)this.evaluations.get(i3).getName()));
            }
            if (this.QualityInUse[AHPWizard.Qualities.HDDUTILIZATION.ordinal()]) {
                this.dataset.addValue(row[AHPWizard.Qualities.HDDUTILIZATION.ordinal()], (Comparable)((Object)"HDD Utilization"), (Comparable)((Object)this.evaluations.get(i3).getName()));
            }
            if (this.QualityInUse[AHPWizard.Qualities.THROUGHPUT.ordinal()]) {
                this.dataset.addValue(row[AHPWizard.Qualities.THROUGHPUT.ordinal()], (Comparable)((Object)"Throughput"), (Comparable)((Object)this.evaluations.get(i3).getName()));
            }
            TableItem nameTI = new TableItem(this.resultBreakDownTable, 0);
            String[] nameTableItems = new String[this.currentNumberOfQualities + 2];
            nameTableItems[0] = this.evaluations.get(i3).getName();
            nameTableItems[1] = String.format("%.4f", this.results[i3]);
            int cellNumber = 2;
            int m = 0;
            while (m < AHPWizard.QualityNames.length) {
                if (this.QualityInUse[m]) {
                    nameTableItems[cellNumber++] = String.format("%.4f", row[m]);
                }
                ++m;
            }
            nameTI.setText(nameTableItems);
            this.stringResults.add(new Vector<String>(Arrays.asList(nameTableItems)));
            ++i3;
        }
    }

    public Table getResultBreakDownTable() {
        return this.resultBreakDownTable;
    }

    public TableColumn getAlternativeTableColumn() {
        return this.alternativeTableColumn;
    }

    class BrowseBtnListener
    implements SelectionListener {
        BrowseBtnListener() {
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            this.widgetSelected(e);
        }

        public void widgetSelected(SelectionEvent e) {
            FileDialog dlg = new FileDialog(ResultsPage.this.topLevel.getShell(), 8192);
            String[] filterExt = new String[]{"*.html"};
            String[] filterNam = new String[]{"HTML Files"};
            dlg.setFilterExtensions(filterExt);
            dlg.setFilterNames(filterNam);
            dlg.setText("Export Results As:");
            String selected = dlg.open();
            if (selected != null) {
                ResultsPage.this.txtfilename.setText(selected);
            }
        }
    }

    class NormalizeBtnListener
    implements SelectionListener {
        NormalizeBtnListener() {
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            this.widgetSelected(e);
        }

        public void widgetSelected(SelectionEvent e) {
            ResultsPage.this.NORMALIZE = ResultsPage.this.normalizeCheck.getSelection();
            ResultsPage.this.updateAhpResults();
        }
    }
}

