/*
 * Decompiled with CFR 0.152.
 */
package eu.qimpress.ide.tradeoff.ahp;

import eu.qimpress.ide.tradeoff.ahp.AHPDataPoint;
import eu.qimpress.ide.tradeoff.ahp.QualityRatingPage;
import eu.qimpress.ide.tradeoff.ahp.QualitySelectionPage;
import eu.qimpress.ide.tradeoff.ahp.ResultsPage;
import eu.qimpress.ide.tradeoff.ahp.ValueRatingPage;
import eu.qimpress.resultmodel.AlternativeEvaluation;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.Vector;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.Velocity;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.MessageBox;
import org.jfree.chart.encoders.KeypointPNGEncoderAdapter;

public class AHPWizard
extends Wizard {
    private ArrayList<AlternativeEvaluation> evaluations;
    private QualitySelectionPage qsPage;
    private QualityRatingPage qrPage;
    private ValueRatingPage vrPage;
    private ResultsPage resPage;
    private LinkedHashMap<String, AHPDataPoint> ahpData;
    private AHPDataPoint ahpDataPoint;
    private final String ahpDataFileName = "AHPData.bin";
    public static String[] QualityNames = new String[]{"Utilization", "Cost", "Reliability", "Response Time", "HDD Utilization", "Throughput"};

    public AHPWizard(ArrayList<AlternativeEvaluation> selectedEvaluations) {
        try {
            Collections.sort(selectedEvaluations, new AlternativeEvaluationComparator());
        }
        catch (Exception exception) {}
        this.evaluations = selectedEvaluations;
        try {
            try {
                URIConverter uriConverter = URIConverter.INSTANCE;
                URI uriAHP = this.getAHPDataLocation(selectedEvaluations.get(0));
                System.out.println("Reading data from :" + uriAHP);
                if (uriConverter.exists(uriAHP, null)) {
                    System.out.println("File exists ...");
                    InputStream is = uriConverter.createInputStream(uriAHP);
                    ObjectInputStream in = new ObjectInputStream(is);
                    this.ahpData = (LinkedHashMap)in.readObject();
                    System.out.println("Read " + this.ahpData.size() + " elements");
                    in.close();
                } else {
                    System.out.println("Using empty ahpData structure...");
                    this.ahpData = new LinkedHashMap();
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
                if (this.ahpData == null) {
                    System.out.println("Using new empty ahpData structure...");
                    this.ahpData = new LinkedHashMap();
                }
            }
            catch (ClassNotFoundException ex) {
                ex.printStackTrace();
                if (this.ahpData == null) {
                    System.out.println("Using new empty ahpData structure...");
                    this.ahpData = new LinkedHashMap();
                }
            }
        }
        finally {
            if (this.ahpData == null) {
                System.out.println("Using new empty ahpData structure...");
                this.ahpData = new LinkedHashMap();
            }
        }
    }

    public boolean performFinish() {
        try {
            URIConverter uriConverter = URIConverter.INSTANCE;
            URI AHPDataURI = this.getAHPDataLocation(this.evaluations.get(0));
            OutputStream os = uriConverter.createOutputStream(AHPDataURI);
            ObjectOutputStream out = new ObjectOutputStream(os);
            out.writeObject(this.ahpData);
            out.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        String fileName = this.resPage.txtfilename.getText();
        if (fileName == null || fileName.length() == 0) {
            MessageBox messageBox = new MessageBox(this.getShell(), 196);
            messageBox.setMessage("Filename is empty. Are you sure that you want to quit without saving results?");
            messageBox.setText("Exiting Application");
            int response = messageBox.open();
            return response == 64;
        }
        String imageFileName = String.valueOf(fileName.substring(0, fileName.lastIndexOf(".html"))) + ".png";
        try {
            Velocity.init();
            VelocityContext context = new VelocityContext();
            context.put("imageFilename", (Object)imageFileName.substring(imageFileName.lastIndexOf(92) + 1));
            context.put("queryComparisons", this.getQualityComparison());
            context.put("valueComparisons", this.getValueComparisons());
            context.put("normalized", (Object)this.resPage.NORMALIZE);
            context.put("criteria", this.resPage.stringCriteria);
            context.put("results", this.resPage.stringResults);
            System.out.println(context.toString());
            FileWriter fw = new FileWriter(fileName);
            VelocityEngine engine = new VelocityEngine();
            engine.evaluate((Context)context, (Writer)fw, "", ((Object)((Object)this)).getClass().getResourceAsStream("/exporttemplate.vm"));
            fw.close();
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        try {
            KeypointPNGEncoderAdapter encoder = new KeypointPNGEncoderAdapter();
            encoder.setEncodingAlpha(true);
            byte[] imageData = encoder.encode(this.resPage.chart.createBufferedImage(600, 400, 2, null));
            FileOutputStream fos = new FileOutputStream(imageFileName);
            fos.write(imageData);
            fos.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return true;
    }

    private Vector<AHPComparison> getQualityComparison() {
        Vector<AHPComparison> comparisons = new Vector<AHPComparison>();
        String[] qualities = QualityNames;
        int i = 0;
        while (i < qualities.length) {
            int j = i + 1;
            while (j < qualities.length) {
                if (this.ahpDataPoint.QualityInUse[i] && this.ahpDataPoint.QualityInUse[j]) {
                    comparisons.add(new AHPComparison(qualities[i], qualities[j], this.ahpDataPoint.qualitySettings[i * qualities.length + j]));
                }
                ++j;
            }
            ++i;
        }
        return comparisons;
    }

    private Vector<AHPComparison> getValueComparisons() {
        Vector<AHPComparison> comparisons = new Vector<AHPComparison>();
        Qualities[] qualitiesArray = Qualities.values();
        int n = qualitiesArray.length;
        int n2 = 0;
        while (n2 < n) {
            Qualities q = qualitiesArray[n2];
            if (this.ahpDataPoint.QualityInUse[q.ordinal()]) {
                int i = 0;
                while (i < this.evaluations.size()) {
                    int j = i + 1;
                    while (j < this.evaluations.size()) {
                        comparisons.add(new AHPComparison(String.valueOf(this.evaluations.get(i).getName()) + ValueRatingPage.getValueForQuality(this.evaluations.get(i), q), String.valueOf(this.evaluations.get(j).getName()) + ValueRatingPage.getValueForQuality(this.evaluations.get(j), q), this.ahpDataPoint.valueSettings[q.ordinal()][i * this.evaluations.size() + j]));
                        ++j;
                    }
                    ++i;
                }
            }
            ++n2;
        }
        return comparisons;
    }

    public void addPages() {
        this.ahpDataPoint = new AHPDataPoint(this.evaluations.size());
        System.out.println(this.ahpDataPoint.toString());
        String hashKey = "";
        for (AlternativeEvaluation alternativeEval : this.evaluations) {
            hashKey = String.valueOf(hashKey) + alternativeEval.getId();
        }
        System.out.println("Builded hash key: " + hashKey);
        if (this.ahpData.containsKey(hashKey)) {
            this.ahpDataPoint = this.ahpData.get(hashKey);
        }
        this.qrPage = new QualityRatingPage(this.ahpDataPoint.getQualityMatrix(), this.ahpDataPoint.getQualitySettings(), this.ahpDataPoint.getQualityInUse());
        this.vrPage = new ValueRatingPage(this.ahpDataPoint.getValueMatrix(), this.evaluations, this.ahpDataPoint.getValueSettings(), this.ahpDataPoint.getQualityInUse());
        this.resPage = new ResultsPage(this.ahpDataPoint, this.evaluations, this.ahpDataPoint.getQualityInUse());
        this.qsPage = new QualitySelectionPage(this.qrPage, this.vrPage, this.resPage, this.ahpDataPoint.getQualityInUse());
        this.ahpData.put(hashKey, this.ahpDataPoint);
        this.addPage((IWizardPage)this.qsPage);
        this.addPage((IWizardPage)this.qrPage);
        this.addPage((IWizardPage)this.vrPage);
        this.addPage((IWizardPage)this.resPage);
    }

    private URI getAHPDataLocation(AlternativeEvaluation ae) {
        URI uri = ae.eResource().getURI();
        System.out.println("uri of evaluation:" + uri);
        String platformLocation = uri.toString().substring(0, uri.toString().lastIndexOf(47));
        platformLocation = String.valueOf(platformLocation) + "/../AHPData.bin";
        System.out.println("Platform uri: " + platformLocation);
        return URI.createURI((String)platformLocation);
    }

    public class AHPComparison {
        private String Left;
        private String Right;
        private String[] RadioList;

        public AHPComparison(String left, String right, int value) {
            this.Left = left;
            this.Right = right;
            this.RadioList = new String[9];
            int i = 0;
            while (i < 9) {
                this.RadioList[i] = value == i ? "X" : "";
                ++i;
            }
        }

        public void setLeft(String left) {
            this.Left = left;
        }

        public String getLeft() {
            return this.Left;
        }

        public void setRight(String right) {
            this.Right = right;
        }

        public String getRight() {
            return this.Right;
        }

        public void setRadioList(String[] radioList) {
            this.RadioList = radioList;
        }

        public String[] getRadioList() {
            return this.RadioList;
        }
    }

    private class AlternativeEvaluationComparator
    implements Comparator<AlternativeEvaluation> {
        private AlternativeEvaluationComparator() {
        }

        @Override
        public int compare(AlternativeEvaluation arg0, AlternativeEvaluation arg1) {
            return arg0.getId().compareTo(arg1.getId());
        }
    }

    public static enum Qualities {
        UTILIZATION,
        COST,
        RELIABILITY,
        RESPONSETIME,
        HDDUTILIZATION,
        THROUGHPUT;

    }
}

