/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.sensorframework.dialogs.dataset;

import de.uka.ipd.sdq.sensorframework.dao.memory.MemoryDAOFactory;
import de.uka.ipd.sdq.sensorframework.dialogs.dataset.DatasourceListContentProvider;
import de.uka.ipd.sdq.sensorframework.dialogs.dataset.DatasourceListLabelProvider;
import de.uka.ipd.sdq.sensorframework.entities.dao.IDAOFactory;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;

public class DatasourceDialog
extends TitleAreaDialog {
    private static String DIALOG_TITLE = "Create/Load the data source.";
    private Button addButton;
    private Button removeButton;
    private Button okButton;
    private Button openButton;
    private Object input;
    private IDAOFactory selectedDataSet;
    private TableViewer viewer;
    private boolean buttonValidation;
    private String dialogTitle;

    public DatasourceDialog(Shell parentShell, String dialogTitle, Object input, boolean makeButtonValidation) {
        super(parentShell);
        this.dialogTitle = dialogTitle;
        this.input = input;
        this.buttonValidation = makeButtonValidation;
        this.setShellStyle(1104);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(this.dialogTitle);
        newShell.addShellListener((ShellListener)new ShellAdapter(){

            public void shellClosed(ShellEvent e) {
                DatasourceDialog.this.selectedDataSet = null;
            }
        });
    }

    protected Control createDialogArea(Composite parent) {
        Composite area = (Composite)super.createDialogArea(parent);
        Composite container = new Composite(area, 0);
        container.setLayout((Layout)new FormLayout());
        container.setLayoutData((Object)new GridData(1808));
        this.addButton = new Button(container, 0);
        FormData fd_addButton = new FormData();
        fd_addButton.right = new FormAttachment(100, -5);
        fd_addButton.bottom = new FormAttachment(0, 31);
        fd_addButton.top = new FormAttachment(0, 5);
        this.addButton.setLayoutData((Object)fd_addButton);
        this.addButton.setText("Add..");
        this.removeButton = new Button(container, 0);
        FormData fd_removeButton = new FormData();
        fd_removeButton.right = new FormAttachment(100, -5);
        fd_removeButton.bottom = new FormAttachment(0, 61);
        fd_removeButton.top = new FormAttachment(0, 35);
        this.removeButton.setLayoutData((Object)fd_removeButton);
        this.removeButton.setText("Remove");
        this.openButton = new Button(container, 0);
        FormData fd_openButton = new FormData();
        fd_openButton.left = new FormAttachment(100, -84);
        fd_openButton.right = new FormAttachment(100, -5);
        fd_openButton.bottom = new FormAttachment(0, 91);
        fd_openButton.top = new FormAttachment(0, 65);
        this.openButton.setLayoutData((Object)fd_openButton);
        this.openButton.setText("Open..");
        Label separator = new Label(container, 258);
        FormData fd_label = new FormData();
        fd_label.bottom = new FormAttachment(100, 2);
        fd_label.right = new FormAttachment(100, 2);
        fd_label.left = new FormAttachment(0, -6);
        separator.setLayoutData((Object)fd_label);
        separator.setText("Label");
        Table list = new Table(container, 2048);
        fd_label.top = new FormAttachment((Control)list, 28, -1);
        fd_removeButton.left = new FormAttachment((Control)list, 6, -1);
        fd_addButton.left = new FormAttachment((Control)list, 6, -1);
        FormData fd_list = new FormData();
        fd_list.bottom = new FormAttachment(100, -32);
        fd_list.right = new FormAttachment(100, -89);
        fd_list.top = new FormAttachment(0, 4);
        fd_list.left = new FormAttachment(0, 5);
        list.setLayoutData((Object)fd_list);
        this.viewer = new TableViewer(list);
        this.viewer.setContentProvider((IContentProvider)new DatasourceListContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new DatasourceListLabelProvider());
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ISelection selection = event.getSelection();
                if (selection instanceof IStructuredSelection) {
                    IStructuredSelection sel = (IStructuredSelection)selection;
                    Object object = sel.getFirstElement();
                    DatasourceDialog.this.selectedDataSet = (IDAOFactory)object;
                    DatasourceDialog.this.validationOKButton(DatasourceDialog.this.selectedDataSet);
                }
            }
        });
        this.viewer.setInput(this.input);
        this.setTitle(DIALOG_TITLE);
        return container;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
        this.okButton = this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.validationOKButton(this.selectedDataSet);
    }

    private void validationOKButton(Object selection) {
        this.setErrorMessage(null);
        this.okButton.setEnabled(true);
        if (this.buttonValidation && selection == null) {
            this.okButton.setEnabled(false);
            this.setErrorMessage("No Datasource selected!");
        }
        if (selection instanceof MemoryDAOFactory) {
            MemoryDAOFactory memoryDAO = (MemoryDAOFactory)selection;
            this.setTitle("Description:");
            this.setMessage(memoryDAO.getDescription());
        }
    }

    protected void setAddButtonAction(SelectionListener listener) {
        this.addButton.addSelectionListener(listener);
    }

    protected void setRemoveButtonAction(SelectionListener listener) {
        this.removeButton.addSelectionListener(listener);
    }

    protected void setOpenButtonAction(SelectionListener listener) {
        this.openButton.addSelectionListener(listener);
    }

    protected Point getInitialSize() {
        return new Point(400, 350);
    }

    public Object getResult() {
        return this.selectedDataSet;
    }

    protected void refresh() {
        this.viewer.refresh();
    }
}

