/*
 * Decompiled with CFR 0.152.
 */
package de.fzi.cloneanalyzer.wizards;

import de.fzi.cloneanalyzer.config.GenericConfig;
import de.fzi.cloneanalyzer.core.CloneAnalyzerPlugin;
import de.fzi.cloneanalyzer.exceptions.CloneCommentException;
import de.fzi.cloneanalyzer.exceptions.CloneConfigException;
import de.fzi.cloneanalyzer.exceptions.CloneException;
import de.fzi.cloneanalyzer.util.EclipseUtil;
import de.fzi.cloneanalyzer.wizards.ConfigWizardPage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;

public class ConfigWizard
extends Wizard
implements INewWizard {
    private ConfigWizardPage page;
    private ISelection selection;

    public ConfigWizard() {
        this.setNeedsProgressMonitor(true);
    }

    public void addPages() {
        this.page = new ConfigWizardPage(this.selection, CloneAnalyzerPlugin.getDefault().getConfig());
        this.addPage((IWizardPage)this.page);
    }

    public boolean performFinish() {
        try {
            GenericConfig config = this.page.getConfig();
            if (config != null) {
                CloneAnalyzerPlugin.getDefault().setConfig(config);
                CloneAnalyzerPlugin.getDefault().runAnalyzer();
                return true;
            }
        }
        catch (CloneConfigException e) {
            EclipseUtil.warning("There is an Error in your Parameters : " + e.getMessage());
        }
        catch (CloneCommentException e) {
            EclipseUtil.warning("There is an Error in the CommentDescriptionFile: " + e.getMessage());
        }
        catch (CloneException e) {
            EclipseUtil.warning(e.getMessage());
        }
        return false;
    }

    private void throwCoreException(String message) throws CoreException {
        Status status = new Status(4, "CloneAnalyzer", 0, message, null);
        throw new CoreException((IStatus)status);
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.selection = selection;
    }
}

