/*
 * Decompiled with CFR 0.152.
 */
package de.fzi.cloneanalyzer.viewer;

import de.fzi.cloneanalyzer.core.CloneInstance;
import de.fzi.cloneanalyzer.core.MaxCloneSet;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;

public class CloneViewSorter
extends ViewerSorter {
    private int sortSelector = 2;

    public int compare(Viewer viewer, Object e1, Object e2) {
        if (e1 instanceof MaxCloneSet && e2 instanceof MaxCloneSet) {
            MaxCloneSet cs1 = (MaxCloneSet)e1;
            MaxCloneSet cs2 = (MaxCloneSet)e2;
            if (this.sortSelector == 1) {
                return cs2.getInstanceNumber() - cs1.getInstanceNumber();
            }
            if (this.sortSelector == 2) {
                return cs2.getLength() - cs1.getLength();
            }
            if (this.sortSelector == 3) {
                return (int)Math.round((cs2.getMaxCoverage() - cs1.getMaxCoverage()) * 100.0);
            }
            if (this.sortSelector == 4) {
                return (int)Math.round((cs2.getAvgCoverage() - cs1.getAvgCoverage()) * 100.0);
            }
        }
        if (e1 instanceof CloneInstance && e2 instanceof CloneInstance) {
            CloneInstance ci1 = (CloneInstance)e1;
            CloneInstance ci2 = (CloneInstance)e2;
            return ci1.getFile().getAbsoluteFile().toString().compareTo(ci2.getFile().getAbsoluteFile().toString());
        }
        return super.compare(viewer, e1, e2);
    }

    public void sortFor(int sortSelector) {
        this.sortSelector = sortSelector;
    }
}

