/*
 * Decompiled with CFR 0.152.
 */
package de.fzi.cloneanalyzer.viewer;

import de.fzi.cloneanalyzer.annotation.CloneAnnotationAccessExt;
import de.fzi.cloneanalyzer.core.CloneAnalyzerPlugin;
import de.fzi.cloneanalyzer.core.CloneInstanceEclipse;
import de.fzi.cloneanalyzer.reader.CloneFile;
import de.fzi.cloneanalyzer.reader.CloneFileEclipse;
import de.fzi.cloneanalyzer.viewer.CloneComparisonDialogAction;
import de.fzi.cloneanalyzer.viewer.SelectInTreeAction;
import java.util.LinkedList;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.text.source.AnnotationRulerColumn;
import org.eclipse.jface.text.source.IAnnotationAccess;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.IVerticalRulerColumn;
import org.eclipse.jface.text.source.LineNumberRulerColumn;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.VerticalRuler;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.editors.text.TextEditor;

public class CloneEditor
extends TextEditor {
    protected IVerticalRuler vr;
    protected SourceViewer sv;
    protected CloneFileEclipse cf = (CloneFileEclipse)CloneFile.openingInstance;
    protected AnnotationRulerColumn arc;
    static final int MIN_RULERBAR_WIDTH = 20;
    static final int MAX_RULERBAR_WIDTH = 100;

    public CloneEditor() {
        int width = this.cf == null ? 100 : Math.min(Math.max(this.cf.getMaxRulerWidth(), 20), 100);
        CloneAnnotationAccessExt caae = new CloneAnnotationAccessExt();
        this.vr = new VerticalRuler(width, (IAnnotationAccess)caae);
    }

    public void setCloneFile(CloneFile cf) {
    }

    protected IVerticalRulerColumn createLineNumberRulerColumn() {
        return new LineNumberRulerColumn();
    }

    protected ISourceViewer createSourceViewer(Composite parent, IVerticalRuler ruler, int styles) {
        this.sv = new SourceViewer(parent, ruler, styles);
        return this.sv;
    }

    protected void rulerContextMenuAboutToShow(IMenuManager menu) {
        int line = this.getVerticalRuler().getLineOfLastMouseButtonActivity();
        this.showCloneContextMenu(menu, line);
    }

    protected void showCloneContextMenu(IMenuManager menu, int line) {
        LinkedList ll = this.cf.getCloneInstanceList(line);
        menu.removeAll();
        if (ll != null) {
            MenuManager mm = null;
            for (CloneInstanceEclipse ci : ll) {
                String selected = "";
                if (ci == CloneAnalyzerPlugin.getDefault().getSelectedCloneInstance()) {
                    selected = ">> ";
                }
                mm = new MenuManager(String.valueOf(selected) + ci.toShortString(), ci.toShortString());
                mm.add((IAction)new SelectInTreeAction(ci));
                mm.add((IAction)new CloneComparisonDialogAction(ci));
                menu.add((IContributionItem)mm);
            }
        }
    }

    protected IVerticalRuler createVerticalRuler() {
        return this.vr;
    }

    public void setAnnotationModel(IAnnotationModel model) {
        ISourceViewer sv = this.getSourceViewer();
        sv.setDocument(sv.getDocument(), model);
    }

    public boolean isSaveAsAllowed() {
        return true;
    }

    public boolean isSaveOnCloseNeeded() {
        return true;
    }
}

