/*
 * Decompiled with CFR 0.152.
 */
package de.fzi.cloneanalyzer.util;

import java.util.Iterator;

public class IntMap {
    public static final int DEFAULT_INITIAL_SIZE = 10;
    private int n_size;
    Entry[] entries;
    Entry freeList;

    public IntMap() {
        this(10);
    }

    public IntMap(int initSize) {
        this.n_size = initSize | 1;
        while (!IntMap.isPrime(this.n_size)) {
            this.n_size += 2;
        }
        this.entries = new Entry[this.n_size];
    }

    public int size() {
        return this.n_size;
    }

    public Object get(int key) {
        int h = this.hash(key);
        Entry entry = this.entries[h];
        while (entry != null) {
            if (entry.key == key) {
                return entry.val;
            }
            entry = entry.next;
        }
        return null;
    }

    public void put(int key, Object val) {
        int h = this.hash(key);
        Entry entry = this.getEntry(key, val);
        entry.next = this.entries[h];
        this.entries[h] = entry;
    }

    public void remove(int key) {
        int h = this.hash(key);
        Entry prev = null;
        Entry entry = this.entries[h];
        while (entry != null) {
            if (entry.key == key) {
                if (prev == null) {
                    this.entries[h] = entry.next;
                } else {
                    prev.next = entry.next;
                }
                this.freeEntry(entry);
            }
            prev = entry;
            entry = entry.next;
        }
    }

    public Entry getEntry(int key, Object val) {
        Entry entry = this.freeList;
        if (entry == null) {
            entry = new Entry();
        } else {
            this.freeList = entry.next;
        }
        entry.key = key;
        entry.val = val;
        return entry;
    }

    public void freeEntry(Entry entry) {
        entry.next = this.freeList;
        this.freeList = entry;
    }

    public static boolean isPrime(int x) {
        if ((x & 1) == 0) {
            return false;
        }
        int i = 3;
        while (i * i <= x) {
            if (x % i == 0) {
                return false;
            }
            i += 2;
        }
        return true;
    }

    public Iterator keys() {
        return new IntMapIterator(this);
    }

    public int hash(int key) {
        int h = key % this.n_size;
        if (h < 0) {
            h = 0 - h;
        }
        return h;
    }

    public Iterator iterator() {
        return new IntMapIterator(this);
    }

    class Entry {
        int key;
        Object val;
        Entry next;

        Entry() {
        }
    }

    class IntMapIterator
    implements Iterator {
        IntMap map;
        int epos = 0;
        Entry entry = null;

        public IntMapIterator(IntMap map) {
            this.map = map;
        }

        public boolean hasNext() {
            while (this.epos < this.map.n_size && this.entry == null) {
                this.entry = this.map.entries[this.epos++];
            }
            return this.entry != null;
        }

        public Object next() {
            Object ret = null;
            if (this.hasNext()) {
                ret = this.entry.val;
                this.entry = this.entry.next;
            }
            return ret;
        }

        public void remove() {
        }
    }
}

