/*
 * Decompiled with CFR 0.152.
 */
package de.fzi.cloneanalyzer.reader;

import de.fzi.cloneanalyzer.config.IConfig;
import de.fzi.cloneanalyzer.core.ICancelDispatcher;
import de.fzi.cloneanalyzer.core.LineElement;
import de.fzi.cloneanalyzer.exceptions.CloneException;
import de.fzi.cloneanalyzer.exceptions.CloneReaderException;
import de.fzi.cloneanalyzer.reader.GenericLineElementReader;
import de.fzi.cloneanalyzer.util.EclipseUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;

public class ProjectLineElementReader
extends GenericLineElementReader {
    private LineElement lastLineElement;
    private ICancelDispatcher cancel;

    public ProjectLineElementReader() {
        this.init();
    }

    public LineElement read(IConfig config_param, ICancelDispatcher cancel) throws CloneException {
        this.cancel = cancel;
        this.setConfig(config_param);
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        this.lastLineElement = null;
        this.recursiveRead((IResource)workspace.getRoot());
        if (this.lastLineElement == null) {
            throw new CloneReaderException("There is nothing to analyze in any open projects.\nCheck the FileFilter and open Eclipse projects");
        }
        return this.lastLineElement;
    }

    protected void recursiveRead(IResource res) throws CloneException {
        if (this.cancel.isCanceled()) {
            return;
        }
        try {
            switch (res.getType()) {
                case 8: {
                    IWorkspaceRoot root = (IWorkspaceRoot)res;
                    IProject[] projects = root.getProjects();
                    if (projects.length < 1) {
                        EclipseUtil.warning("No Project is opened in the current workspace \n => nothing to analyze");
                    }
                    int i = 0;
                    while (i < projects.length) {
                        this.recursiveRead((IResource)projects[i]);
                        if (this.cancel.isCanceled()) {
                            return;
                        }
                        ++i;
                    }
                    break;
                }
                case 4: {
                    IProject project = (IProject)res;
                    IResource[] projectMembers = project.members();
                    int j = 0;
                    while (j < projectMembers.length) {
                        this.recursiveRead(projectMembers[j]);
                        if (this.cancel.isCanceled()) {
                            return;
                        }
                        ++j;
                    }
                    break;
                }
                case 2: {
                    IFolder folder = (IFolder)res;
                    IResource[] folderMembers = folder.members();
                    int j = 0;
                    while (j < folderMembers.length) {
                        this.recursiveRead(folderMembers[j]);
                        if (this.cancel.isCanceled()) {
                            return;
                        }
                        ++j;
                    }
                    break;
                }
                case 1: {
                    this.lastLineElement = this.readFile(((IFile)res).getLocation().toFile(), (IFile)res, this.lastLineElement);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

