/*
 * Decompiled with CFR 0.152.
 */
package de.fzi.cloneanalyzer.reader;

import de.fzi.cloneanalyzer.config.GenericConfig;
import de.fzi.cloneanalyzer.config.IConfig;
import de.fzi.cloneanalyzer.core.ICancelDispatcher;
import de.fzi.cloneanalyzer.core.LineElement;
import de.fzi.cloneanalyzer.exceptions.CloneException;
import de.fzi.cloneanalyzer.reader.CloneFile;
import de.fzi.cloneanalyzer.reader.CloneFileEclipse;
import de.fzi.cloneanalyzer.reader.Comment;
import de.fzi.cloneanalyzer.reader.ILineElementReader;
import de.fzi.cloneanalyzer.reader.LiteralSection;
import de.fzi.cloneanalyzer.util.LineReader;
import java.io.File;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Vector;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IFile;

public abstract class GenericLineElementReader
implements ILineElementReader {
    protected GenericConfig config;
    private ArrayList unwantedLines;
    protected Hashtable ht = new Hashtable();
    protected ArrayList cloneFileList;
    protected Pattern fileFilterPattern;
    protected Comment lastComment;
    protected ArrayList commentList;
    protected int globalLineCount = 0;
    protected int globalTotalLineCount = 0;
    protected Logger logger;

    public int getGlobalLineCount() {
        return this.globalLineCount;
    }

    public int getGlobalTotalLineCount() {
        return this.globalTotalLineCount;
    }

    protected void setConfig(IConfig config_param) {
        if (config_param instanceof GenericConfig) {
            this.config = (GenericConfig)config_param;
            this.compileRegExp();
        } else {
            this.logger.info("config does not have expected type");
        }
    }

    protected void compileRegExp() {
        this.fileFilterPattern = Pattern.compile(this.config.getFileFilter());
    }

    protected void init() {
        this.cloneFileList = new ArrayList();
        this.logger = Logger.getLogger("CloneAnalyzerLogger");
    }

    public Hashtable getHashtable() {
        return this.ht;
    }

    protected String deleteComments(String line) throws CloneException {
        boolean commentStartInSameLine = false;
        int commentStartPosition = 0;
        Matcher m = null;
        String result = line;
        int smallestStart = line.length();
        if (this.lastComment == null) {
            Vector<LiteralSection> literal_sections = new Vector<LiteralSection>();
            boolean outsideStringLiteral = true;
            boolean outsideCharLiteral = true;
            int startColumn = 0;
            int endColumn = 0;
            int i = 0;
            while (i < result.length()) {
                char c = result.charAt(i);
                if (outsideCharLiteral && c == '\"') {
                    if (outsideStringLiteral) {
                        startColumn = i;
                    } else {
                        endColumn = i;
                        literal_sections.add(new LiteralSection(startColumn, endColumn));
                    }
                    boolean bl = outsideStringLiteral = !outsideStringLiteral;
                }
                if (outsideStringLiteral && c == '\'') {
                    if (outsideCharLiteral) {
                        startColumn = i;
                    } else {
                        endColumn = i;
                        literal_sections.add(new LiteralSection(startColumn, endColumn));
                    }
                    outsideCharLiteral = !outsideCharLiteral;
                }
                ++i;
            }
            for (Comment c : this.config.getComments()) {
                m = c.getStart().matcher(result);
                while (m.find()) {
                    int startPos = m.start();
                    int length = m.group().length();
                    boolean insideStringLiteral = false;
                    for (LiteralSection sls : literal_sections) {
                        if (!sls.contains(startPos, length)) continue;
                        insideStringLiteral = true;
                        break;
                    }
                    if (insideStringLiteral || startPos >= smallestStart) continue;
                    smallestStart = startPos;
                    this.lastComment = c;
                    commentStartInSameLine = true;
                    commentStartPosition = startPos;
                }
            }
        } else {
            smallestStart = 0;
        }
        if (this.lastComment != null) {
            int startIndex = 0;
            if (commentStartInSameLine) {
                startIndex = commentStartPosition;
                commentStartPosition = 0;
                commentStartInSameLine = false;
            }
            boolean i = false;
            m = this.lastComment.getEnd().matcher(line);
            if (m.find(startIndex)) {
                result = String.valueOf(result.substring(0, smallestStart)) + line.substring(m.end(), line.length());
                this.lastComment = null;
                return this.deleteComments(result);
            }
            result = result.substring(0, smallestStart);
        }
        return result;
    }

    protected String deleteWhitespace(String line) {
        boolean whitespace = false;
        StringBuffer buff = new StringBuffer();
        int i = 0;
        while (i < line.length()) {
            char c = line.charAt(i);
            if (c != ' ' && c != '\t') {
                buff.append(c);
                whitespace = false;
            } else if (!whitespace) {
                whitespace = true;
                buff.append(' ');
            }
            ++i;
        }
        String result = buff.toString();
        return result;
    }

    private boolean accept(File f) {
        Matcher m = this.fileFilterPattern.matcher(f.getAbsolutePath());
        return m.matches();
    }

    protected LineElement readFile(File file, IFile ifile, LineElement lastLineElement) throws CloneException {
        if (this.accept(file)) {
            CloneFile cloneFile = null;
            cloneFile = ifile == null ? new CloneFile(file) : new CloneFileEclipse(file, ifile);
            this.cloneFileList.add(cloneFile);
            FileReader filereader = null;
            try {
                filereader = new FileReader(file);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            int line = -1;
            int position = 0;
            int endPosition = 0;
            int lineCount = 0;
            try {
                String originalLine;
                LineReader r = new LineReader(filereader);
                ArrayList al = null;
                while ((originalLine = r.readLine()) != null) {
                    String modifiedLine = originalLine;
                    ++line;
                    ++this.globalTotalLineCount;
                    endPosition = position + originalLine.length();
                    if (this.config.isDeleteComments()) {
                        modifiedLine = this.deleteComments(modifiedLine);
                    }
                    if (this.config.isDeleteWhitespace()) {
                        modifiedLine = this.deleteWhitespace(modifiedLine).trim();
                    }
                    if (modifiedLine.length() != 0) {
                        ++this.globalLineCount;
                        ++lineCount;
                        LineElement le = new LineElement(cloneFile, line, position, endPosition, modifiedLine.hashCode(), lastLineElement);
                        if (lastLineElement != null) {
                            lastLineElement.setNextLine(le);
                        }
                        lastLineElement = le;
                        Integer hc = new Integer(modifiedLine.hashCode());
                        if (this.ht.containsKey(hc)) {
                            al = (ArrayList)this.ht.get(hc);
                            al.add(le);
                            this.ht.remove(hc);
                            this.ht.put(hc, al);
                        } else {
                            al = new ArrayList();
                            al.add(le);
                            this.ht.put(hc, al);
                        }
                    }
                    position = endPosition + r.getLastLineDelimiter().length();
                }
                cloneFile.setCharacterLength(position);
                cloneFile.setLineNumber(line);
                cloneFile.finishInit();
                filereader.close();
                r.close();
            }
            catch (CloneException e) {
                throw e;
            }
            catch (Exception e) {
                this.logger.info("Error while reading File: " + file.getAbsolutePath() + ", Line: " + line + ", Position: " + position);
            }
        }
        return lastLineElement;
    }

    public ArrayList getCloneFileList() {
        return this.cloneFileList;
    }

    public abstract LineElement read(IConfig var1, ICancelDispatcher var2) throws CloneException;
}

