/*
 * Decompiled with CFR 0.152.
 */
package de.fzi.cloneanalyzer.reader;

import de.fzi.cloneanalyzer.config.IConfig;
import de.fzi.cloneanalyzer.core.ICancelDispatcher;
import de.fzi.cloneanalyzer.core.LineElement;
import de.fzi.cloneanalyzer.exceptions.CloneException;
import de.fzi.cloneanalyzer.exceptions.CloneReaderException;
import de.fzi.cloneanalyzer.reader.GenericLineElementReader;
import java.io.File;

public class DirectoryLineElementReader
extends GenericLineElementReader {
    private LineElement lastLineElement;
    private ICancelDispatcher cancel;

    public DirectoryLineElementReader() {
        this.init();
    }

    public LineElement read(IConfig config_param, ICancelDispatcher cancel) throws CloneException {
        this.cancel = cancel;
        this.setConfig(config_param);
        this.lastLineElement = null;
        for (String path : this.config.getAnalysisPathList()) {
            File pathFile = new File(path);
            this.recursiveRead(pathFile);
        }
        if (this.lastLineElement == null) {
            throw new CloneReaderException("There is nothing to analyze in given path. Check the Parameters FileFilter (-f), and Directory (-d)");
        }
        return this.lastLineElement;
    }

    protected void recursiveRead(File path) throws CloneException {
        File[] items = path.listFiles();
        if (items != null) {
            int i = 0;
            while (i < items.length) {
                File item = items[i];
                if (path.isDirectory()) {
                    this.recursiveRead(item);
                } else {
                    this.lastLineElement = this.readFile(item, null, this.lastLineElement);
                }
                ++i;
            }
        } else {
            this.lastLineElement = this.readFile(path, null, this.lastLineElement);
        }
    }
}

