/*
 * Decompiled with CFR 0.152.
 */
package de.fzi.cloneanalyzer.core;

import de.fzi.cloneanalyzer.core.ClonePattern;
import de.fzi.cloneanalyzer.core.MaxCloneSet;
import de.fzi.cloneanalyzer.core.TrieElement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Stack;

public class Trie {
    TrieElement eps = new TrieElement();
    protected ArrayList uniqueList;

    public boolean testCloneSet(MaxCloneSet cloneSet) {
        ClonePattern muster = cloneSet.getClonePattern();
        TrieElement te = this.eps;
        int i = 0;
        while (i < muster.length()) {
            TrieElement kind = te.contains(muster.get(i));
            if (kind == null) {
                return false;
            }
            if (cloneSet.getInstanceNumber() > kind.anz) {
                return false;
            }
            te = kind;
            ++i;
        }
        return true;
    }

    public void addCloneSet(MaxCloneSet cloneSet) {
        TrieElement te = this.eps;
        ClonePattern muster = cloneSet.getClonePattern();
        int i = 0;
        while (i < muster.length()) {
            TrieElement kind = te.contains(muster.get(i));
            if (kind == null) {
                TrieElement teNeu = new TrieElement();
                teNeu.anz = muster.anz;
                teNeu.hashValue = muster.get(i);
                teNeu.maxCloneSet = cloneSet;
                te.kinder.add(teNeu);
                te = teNeu;
            } else {
                if (te.maxCloneSet == null) {
                    te.maxCloneSet = cloneSet;
                } else if (te.maxCloneSet.getClonePattern().length() > muster.length()) {
                    te.maxCloneSet = cloneSet;
                }
                te = kind;
            }
            ++i;
        }
    }

    public void printTree() {
        System.out.println();
        this.eps.printTree(0);
    }

    public ArrayList buildUniqueCloneList() {
        this.uniqueList = new ArrayList();
        this.dfs_iter(this.eps);
        this.setInstancesVisible();
        return this.uniqueList;
    }

    protected int dfs(TrieElement te) {
        if (te.kinder.size() > 0) {
            int i = 0;
            while (i < te.kinder.size()) {
                TrieElement kind = (TrieElement)te.kinder.get(i);
                if (kind != null && te.maxCloneSet != null && this.dfs(kind) < te.maxCloneSet.getInstanceNumber()) {
                    this.add(te.maxCloneSet);
                } else if (te.maxCloneSet == null) {
                    this.dfs(kind);
                }
                ++i;
            }
        } else if (te.maxCloneSet != null) {
            this.add(te.maxCloneSet);
        }
        if (te.maxCloneSet != null) {
            return te.maxCloneSet.getInstanceNumber();
        }
        return 0;
    }

    protected int dfs_iter(TrieElement te) {
        boolean allChildrenSmaller = true;
        Stack<TrieElement> stack = new Stack<TrieElement>();
        stack.push(te);
        while (!stack.isEmpty()) {
            te = (TrieElement)stack.pop();
            if (te.kinder.size() > 0) {
                allChildrenSmaller = true;
                int i = 0;
                while (i < te.kinder.size()) {
                    TrieElement kind = (TrieElement)te.kinder.get(i);
                    if (kind != null) {
                        stack.push(kind);
                    }
                    if (te.maxCloneSet != null && kind.maxCloneSet.getInstanceNumber() >= te.maxCloneSet.getInstanceNumber()) {
                        allChildrenSmaller = false;
                    }
                    ++i;
                }
                if (!allChildrenSmaller || te.maxCloneSet == null) continue;
                this.add(te.maxCloneSet);
                continue;
            }
            if (te.maxCloneSet == null) continue;
            this.add(te.maxCloneSet);
        }
        return 0;
    }

    protected void add(MaxCloneSet maxCloneSet) {
        this.uniqueList.add(maxCloneSet);
    }

    protected void setInstancesVisible() {
        Iterator iter = this.uniqueList.iterator();
        while (iter.hasNext()) {
            ((MaxCloneSet)iter.next()).setInstancesVisible();
        }
    }
}

