/*
 * Decompiled with CFR 0.152.
 */
package de.fzi.cloneanalyzer.core;

import de.fzi.cloneanalyzer.core.CloneInstance;
import de.fzi.cloneanalyzer.core.MaxCloneSet;
import de.fzi.cloneanalyzer.core.Trie;
import de.fzi.cloneanalyzer.util.EclipseUtil;
import java.io.FileWriter;
import java.util.ArrayList;

public class CloneSetStructure {
    private Trie trie = new Trie();
    private ArrayList clones;
    private ArrayList allClones = new ArrayList();
    protected boolean needUpdate = true;
    protected boolean showAllClones = false;

    public int getSize() {
        return this.getClones().size();
    }

    public void addCloneSet(MaxCloneSet cloneSet) {
        this.needUpdate = true;
        this.trie.addCloneSet(cloneSet);
        this.allClones.add(cloneSet);
    }

    public void readFile() {
    }

    public void writeFile(String fileName) {
        try {
            FileWriter fw = new FileWriter(fileName);
            fw.write(this.getOutput().toString());
            fw.close();
            EclipseUtil.message("Successfully saved to " + fileName + ".");
        }
        catch (Exception e) {
            EclipseUtil.warning("Error writing to " + fileName + ".");
        }
    }

    public void writeScreen() {
        try {
            System.out.println(this.getOutput().toString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public StringBuffer getOutput() {
        StringBuffer buf = new StringBuffer();
        String template = "Template:\nCloneSet No,No of Lines,No of Instances\nCloneInstance starts in Line,CloneInstance ends in Line,CloneInstance occurs in File\n\n";
        buf.append(template);
        Object[] cobjs = this.getArray();
        int i = 0;
        while (i < cobjs.length) {
            MaxCloneSet mcs = (MaxCloneSet)cobjs[i];
            buf.append(mcs.toTupel());
            Object[] ciobjs = mcs.getArray();
            int j = 0;
            while (j < ciobjs.length) {
                CloneInstance ci = (CloneInstance)ciobjs[j];
                buf.append(ci.toTupel());
                ++j;
            }
            ++i;
        }
        return buf;
    }

    public Object[] getArray() {
        return this.getClones().toArray();
    }

    protected ArrayList getClones() {
        if (this.showAllClones) {
            return this.allClones;
        }
        if (this.needUpdate) {
            this.clones = this.trie.buildUniqueCloneList();
            this.needUpdate = false;
        }
        return this.clones;
    }

    public Object[] prepareOutput() {
        ArrayList<Object> temp = new ArrayList<Object>();
        Object[] a = this.getArray();
        int i = 0;
        while (i < a.length) {
            Object[] b = ((MaxCloneSet)a[i]).getArray();
            int j = 0;
            while (j < b.length) {
                temp.add(b[j]);
                ++j;
            }
            ++i;
        }
        return temp.toArray();
    }
}

