/*
 * Decompiled with CFR 0.152.
 */
package de.fzi.cloneanalyzer.core;

import de.fzi.cloneanalyzer.annotation.CloneAnnotation;
import de.fzi.cloneanalyzer.core.CloneAnalyzerPlugin;
import de.fzi.cloneanalyzer.core.CloneInstance;
import de.fzi.cloneanalyzer.core.LineElement;
import de.fzi.cloneanalyzer.reader.CloneFileEclipse;
import de.fzi.cloneanalyzer.viewer.CloneDocumentRangeNode;
import de.fzi.cloneanalyzer.viewer.CloneEditor;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;

public class CloneInstanceEclipse
extends CloneInstance {
    protected CloneDocumentRangeNode node;
    protected boolean nodeConstructed = false;

    public void setVisible() {
        super.setVisible();
        this.getCloneFileEclipse().registerCloneInstanceAPM(this);
    }

    public CloneInstanceEclipse(LineElement startLine, LineElement endLine) {
        super(startLine, endLine);
        if (CloneAnalyzerPlugin.getDefault() != null) {
            CloneAnalyzerPlugin.getDefault().setCloneInstance(this.key, this);
            this.addAnnotation();
        }
    }

    public void addAnnotation() {
        Position pos = new Position(this.getStartCharacterPosition(), this.getCharacterLength());
        CloneAnnotation ann = new CloneAnnotation(this);
        IAnnotationModel model = this.getCloneFileEclipse().getAnnotationModel();
        model.addAnnotation((Annotation)ann, pos);
    }

    public void openInEditor() {
        CloneEditor ce = this.getCloneFileEclipse().openEditor();
        ce.selectAndReveal(this.getStartCharacterPosition(), this.getCharacterLength());
    }

    protected CloneDocumentRangeNode constructNode(CloneDocumentRangeNode parent) {
        if (!this.nodeConstructed) {
            this.node = new CloneDocumentRangeNode(0, this.getCloneSet().getIdentifierString(), ((CloneFileEclipse)this.getCloneFile()).getDocument(), this.getStartCharacterPosition(), this.getCharacterLength(), parent, this.cloneFile, this);
            this.nodeConstructed = true;
        }
        return this.node;
    }

    public CloneDocumentRangeNode getNode(CloneDocumentRangeNode parent) {
        return this.constructNode(parent);
    }

    public CloneFileEclipse getCloneFileEclipse() {
        return (CloneFileEclipse)this.cloneFile;
    }
}

