/*
 * Decompiled with CFR 0.152.
 */
package de.fzi.cloneanalyzer.annotation;

import de.fzi.cloneanalyzer.core.CloneInstance;
import de.fzi.cloneanalyzer.reader.CloneFile;
import de.fzi.cloneanalyzer.util.IntTreeMap;
import de.fzi.cloneanalyzer.util.IntTreeMap2D;
import de.fzi.cloneanalyzer.util.LineSlotTable;
import java.util.Iterator;
import java.util.LinkedList;

public class CloneFileAnnotationPositionManager {
    protected IntTreeMap2D cloneStartList;
    protected LineSlotTable posl;
    protected CloneFile cloneFile = null;
    protected int maxSlotNumber = 0;
    protected static int MAXSLOTS = 300;

    public static int getMaxSlots() {
        return MAXSLOTS;
    }

    public CloneFileAnnotationPositionManager(CloneFile cloneFile) {
        this.cloneFile = cloneFile;
        this.init();
    }

    public CloneFileAnnotationPositionManager() {
        this.init();
    }

    public void init() {
        this.cloneStartList = new IntTreeMap2D();
        this.posl = new LineSlotTable(this.cloneFile.getLineNumber());
    }

    public void registerCloneInstance(CloneInstance ci) {
        int lineNumber = ci.getStartLine().getLineNumber();
        this.cloneStartList.enqueue(lineNumber, ci);
    }

    public void calc() {
        this.maxSlotNumber = 0;
        IntTreeMap cloneStartSameLineList = null;
        CloneInstance ci = null;
        Iterator cloneStartIterator = this.cloneStartList.iterator();
        while (cloneStartIterator.hasNext()) {
            Object obj = cloneStartIterator.next();
            if (!(obj instanceof IntTreeMap) || (cloneStartSameLineList = (IntTreeMap)obj) == null) continue;
            Iterator cloneStartSameLineIterator = cloneStartSameLineList.iterator();
            int slotNumber = 0;
            while (cloneStartSameLineIterator.hasNext() && MAXSLOTS > slotNumber) {
                ci = (CloneInstance)cloneStartSameLineIterator.next();
                int currentLineNumber = ci.getStartLine().getLineNumber();
                slotNumber = this.posl.getFirstFreeSlot(currentLineNumber);
                ci.setAnnotationPosition(slotNumber);
                ci.setDisplayable(true);
                int length = ci.getLength();
                this.posl.set(currentLineNumber, length - 1, slotNumber, ci);
                if (this.maxSlotNumber >= slotNumber) continue;
                this.maxSlotNumber = slotNumber;
            }
        }
    }

    public LinkedList getCloneInstances(int lineNumber) {
        LinkedList ll = this.posl.getLL(lineNumber);
        return ll;
    }

    public IntTreeMap2D getCloneStartList() {
        return this.cloneStartList;
    }

    public int getMaxSlotNumber() {
        return this.maxSlotNumber;
    }
}

