/*
 * Decompiled with CFR 0.152.
 */
package de.fzi.cloneanalyzer.annotation;

import de.fzi.cloneanalyzer.core.CloneAnalyzerPlugin;
import de.fzi.cloneanalyzer.core.CloneInstance;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationPresentation;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;

public class CloneAnnotation
extends Annotation
implements IAnnotationPresentation {
    CloneInstance ci;
    protected static final int LINE_WIDTH = 2;
    protected static final int BORDER_SPACER = 2;
    protected static final int LINE_SPACER_V = 1;
    protected static final int LINE_SPACER_H = 1;
    public static final String CLONE_ANNOTATION_TYPE = "CloneAnnotation";

    public CloneAnnotation(CloneInstance ci) {
        super(CLONE_ANNOTATION_TYPE, false, null);
        this.ci = ci;
    }

    public static int calculateX(int x, int annotationPosition) {
        int offset = 2 + 3 * annotationPosition;
        int absoluteX = x + offset;
        return absoluteX;
    }

    public void paint(GC gc, Canvas canvas, Rectangle bounds) {
        try {
            Color yellowColor = new Color((Device)canvas.getDisplay(), 255, 255, 0);
            Color redColor = new Color((Device)canvas.getDisplay(), 255, 0, 0);
            Color blueColor = new Color((Device)canvas.getDisplay(), 0, 0, 255);
            if (this.ci == CloneAnalyzerPlugin.getDefault().getSelectedCloneInstance()) {
                gc.setForeground(redColor);
            } else if (this.ci == CloneAnalyzerPlugin.getDefault().getCompareCloneInstance()) {
                gc.setForeground(blueColor);
            } else {
                gc.setForeground(yellowColor);
            }
            if (this.ci.isVisible()) {
                int x = CloneAnnotation.calculateX(bounds.x, this.ci.getAnnotationPosition());
                gc.setLineWidth(2);
                gc.drawLine(x, bounds.y + 1, x, bounds.y + bounds.height - 1);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public int getLayer() {
        return 0;
    }
}

