/*
 * Decompiled with CFR 0.152.
 */
package de.fzi.cloneanalyzer.analyzer;

import de.fzi.cloneanalyzer.analyzer.IAnalyzer;
import de.fzi.cloneanalyzer.config.IConfig;
import de.fzi.cloneanalyzer.core.CloneInstance;
import de.fzi.cloneanalyzer.core.CloneSetStructure;
import de.fzi.cloneanalyzer.core.ICancelDispatcher;
import de.fzi.cloneanalyzer.core.LineElement;
import de.fzi.cloneanalyzer.core.MaxCloneSet;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;

public class RecursiveAnalyzer
implements IAnalyzer {
    protected Hashtable ht = new Hashtable();
    protected CloneSetStructure css = new CloneSetStructure();
    protected IConfig config;
    protected ICancelDispatcher cancel;
    protected int countr = 0;
    protected boolean isEclipse;

    public RecursiveAnalyzer(IConfig config_param, boolean isEclipse) {
        this.config = config_param;
        this.isEclipse = isEclipse;
    }

    public CloneSetStructure buildCloneSetStructure(LineElement rootLineElement, Hashtable ht_param, ICancelDispatcher cancel) {
        this.cancel = cancel;
        this.ht = ht_param;
        this.css = new CloneSetStructure();
        this.findClonesRecursiveStart(rootLineElement);
        return this.css;
    }

    public boolean findClonesRecursive(Hashtable currentTable, Hashtable currentStartLineTable, int depth) {
        Enumeration currentTableKeys = currentTable.keys();
        boolean doOutputBit = false;
        while (currentTableKeys.hasMoreElements()) {
            int i;
            Integer currentKey = (Integer)currentTableKeys.nextElement();
            ArrayList currentList = (ArrayList)currentTable.get(currentKey);
            ArrayList currentStartLineList = (ArrayList)currentStartLineTable.get(currentKey);
            if (currentList.size() <= 1) {
                doOutputBit = true;
                continue;
            }
            Hashtable<Integer, ArrayList<LineElement>> newTable = new Hashtable<Integer, ArrayList<LineElement>>();
            Hashtable newStartLineTable = new Hashtable();
            int i2 = 0;
            while (i2 < currentList.size()) {
                LineElement le = (LineElement)currentList.get(i2);
                LineElement prevLine = le.getPrevLine();
                if (prevLine == null) {
                    boolean bl = false;
                }
                if (prevLine == null || prevLine.getFile() != le.getFile()) {
                    boolean fg = false;
                } else {
                    Integer prevLineValue = prevLine.getHashValue();
                    ArrayList<LineElement> list = (ArrayList<LineElement>)newTable.get(prevLineValue);
                    ArrayList startLineList = (ArrayList)newStartLineTable.get(prevLineValue);
                    if (list == null) {
                        list = new ArrayList<LineElement>();
                        newTable.put(prevLineValue, list);
                        startLineList = new ArrayList();
                        newStartLineTable.put(prevLineValue, startLineList);
                    }
                    list.add(prevLine);
                    startLineList.add(currentStartLineList.get(i2));
                }
                ++i2;
            }
            boolean doOutput = this.findClonesRecursive(newTable, newStartLineTable, depth + 1);
            if (!doOutput && newTable.size() < 2 || currentList.size() < 2) continue;
            boolean testResult = false;
            int i3 = 0;
            while (i3 < currentList.size()) {
                if (((LineElement)currentStartLineList.get(i3)).getNextLine() == null) {
                    testResult = true;
                }
                ++i3;
            }
            if (!testResult) {
                Integer testValue = ((LineElement)currentStartLineList.get(0)).getNextLine().getHashValue();
                i = 1;
                while (i < currentList.size()) {
                    if (!testValue.equals(((LineElement)currentStartLineList.get(i)).getNextLine().getHashValue())) {
                        testResult = true;
                    }
                    ++i;
                }
            }
            if (!testResult) {
                i = 0;
                while (i < currentList.size()) {
                    if (((LineElement)currentStartLineList.get(i)).getNextLine().getFile() != ((LineElement)currentStartLineList.get(i)).getFile()) {
                        testResult = true;
                    }
                    ++i;
                }
            }
            if (!testResult || depth < this.config.getMinCloneLength()) continue;
            MaxCloneSet maxCloneSet = new MaxCloneSet();
            i = 0;
            while (i < currentList.size()) {
                LineElement startLine = (LineElement)currentList.get(i);
                LineElement endLine = (LineElement)currentStartLineList.get(i);
                CloneInstance ci = new CloneInstance(startLine, endLine);
                maxCloneSet.addCloneInstance(ci);
                ++i;
            }
            maxCloneSet.setSigLines(depth);
            this.css.addCloneSet(maxCloneSet);
        }
        return doOutputBit;
    }

    protected void findClonesRecursiveStart(LineElement lastLine) {
        do {
            if (!lastLine.bit) {
                ArrayList currentList = (ArrayList)this.ht.get(lastLine.getHashValue());
                int i = 0;
                while (i < currentList.size()) {
                    ((LineElement)currentList.get((int)i)).bit = true;
                    ++i;
                }
                Hashtable<Integer, ArrayList> startTable = new Hashtable<Integer, ArrayList>();
                startTable.put(lastLine.getHashValue(), currentList);
                this.findClonesRecursive(startTable, startTable, 1);
            }
            if (!this.cancel.isCanceled()) continue;
            return;
        } while ((lastLine = lastLine.getPrevLine()) != null);
    }
}

