/*
 * Decompiled with CFR 0.152.
 */
package de.fzi.cloneanalyzer.analyzer;

import de.fzi.cloneanalyzer.analyzer.CloneInstanceFactory;
import de.fzi.cloneanalyzer.analyzer.IAnalyzer;
import de.fzi.cloneanalyzer.analyzer.IterationState;
import de.fzi.cloneanalyzer.config.IConfig;
import de.fzi.cloneanalyzer.core.CloneInstance;
import de.fzi.cloneanalyzer.core.CloneSetStructure;
import de.fzi.cloneanalyzer.core.ICancelDispatcher;
import de.fzi.cloneanalyzer.core.LineElement;
import de.fzi.cloneanalyzer.core.MaxCloneSet;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Stack;

public class IterativeAnalyzer
implements IAnalyzer {
    protected Hashtable ht = new Hashtable();
    protected CloneSetStructure css = new CloneSetStructure();
    protected IConfig config;
    protected ICancelDispatcher cancel;
    protected int countr = 0;
    protected CloneInstanceFactory cif;

    public IterativeAnalyzer(IConfig config_param, CloneInstanceFactory cif) {
        this.config = config_param;
        this.cif = cif;
    }

    public CloneSetStructure buildCloneSetStructure(LineElement rootLineElement, Hashtable ht_param, ICancelDispatcher cancel) {
        this.ht = ht_param;
        this.cancel = cancel;
        this.css = new CloneSetStructure();
        this.findClones(rootLineElement);
        return this.css;
    }

    public boolean findClonesIterative(Hashtable paramTable, Hashtable paramStartLineTable) {
        IterationState top = null;
        Stack<IterationState> iterationStack = new Stack<IterationState>();
        iterationStack.push(new IterationState(null, null, null, paramTable, paramStartLineTable, 1, null, null));
        while (!iterationStack.empty()) {
            top = (IterationState)iterationStack.pop();
            if (top.currentKey == null) {
                Enumeration currentTableKeys = top.currentTable.keys();
                while (currentTableKeys.hasMoreElements()) {
                    Integer currentKey = (Integer)currentTableKeys.nextElement();
                    ArrayList currentList = (ArrayList)top.currentTable.get(currentKey);
                    ArrayList currentStartLineList = (ArrayList)top.currentStartLineTable.get(currentKey);
                    iterationStack.push(new IterationState(currentKey, currentList, currentStartLineList, top.currentTable, top.currentStartLineTable, top.depth, top.oldList, top.oldStartLineList));
                }
                top = !iterationStack.empty() ? (IterationState)iterationStack.pop() : null;
            }
            if (top == null) continue;
            if (!(top.currentList.size() > 1 && top.currentTable.size() < 2 || top.didOutput || top.oldList == null || top.oldStartLineList == null)) {
                this.output(top.oldList, top.oldStartLineList, top.depth - 1);
                this.markOutputDone(iterationStack, top.depth);
            }
            if (top.currentList.size() <= 1) continue;
            Hashtable<Integer, ArrayList<LineElement>> newTable = new Hashtable<Integer, ArrayList<LineElement>>();
            Hashtable newStartLineTable = new Hashtable();
            int i = 0;
            while (i < top.currentList.size()) {
                LineElement le = (LineElement)top.currentList.get(i);
                LineElement prevLine = le.getPrevLine();
                if (prevLine == null) {
                    boolean gf = false;
                } else if (prevLine.getFile() != le.getFile()) {
                    boolean fg = false;
                } else {
                    Integer prevLineValue = prevLine.getHashValue();
                    ArrayList<LineElement> list = (ArrayList<LineElement>)newTable.get(prevLineValue);
                    ArrayList startLineList = (ArrayList)newStartLineTable.get(prevLineValue);
                    if (list == null) {
                        list = new ArrayList<LineElement>();
                        newTable.put(prevLineValue, list);
                        startLineList = new ArrayList();
                        newStartLineTable.put(prevLineValue, startLineList);
                    }
                    list.add(prevLine);
                    startLineList.add(top.currentStartLineList.get(i));
                }
                ++i;
            }
            iterationStack.push(new IterationState(null, null, null, newTable, newStartLineTable, top.depth + 1, top.currentList, top.currentStartLineList));
        }
        return true;
    }

    protected void markOutputDone(Stack iterationStack, int depth) {
        if (!iterationStack.empty()) {
            IterationState toRemove = null;
            Stack<IterationState> tempStack = new Stack<IterationState>();
            do {
                toRemove = (IterationState)iterationStack.pop();
                if (toRemove.depth == depth) {
                    toRemove.didOutput = true;
                    tempStack.add(toRemove);
                    continue;
                }
                iterationStack.push(toRemove);
            } while (!iterationStack.empty() && toRemove.depth == depth);
            while (!tempStack.empty()) {
                Object temp = tempStack.pop();
                if (temp == null) continue;
                iterationStack.push(temp);
            }
        }
    }

    protected void output(ArrayList currentList, ArrayList currentStartLineList, int depth) {
        if (currentList.size() >= 2) {
            int i;
            boolean testResult = false;
            int i2 = 0;
            while (i2 < currentList.size()) {
                if (((LineElement)currentStartLineList.get(i2)).getNextLine() == null) {
                    testResult = true;
                }
                ++i2;
            }
            if (!testResult) {
                Integer testValue = ((LineElement)currentStartLineList.get(0)).getNextLine().getHashValue();
                i = 1;
                while (i < currentList.size()) {
                    if (!testValue.equals(((LineElement)currentStartLineList.get(i)).getNextLine().getHashValue())) {
                        testResult = true;
                    }
                    ++i;
                }
            }
            if (!testResult) {
                i = 0;
                while (i < currentList.size()) {
                    if (((LineElement)currentStartLineList.get(i)).getNextLine().getFile() != ((LineElement)currentStartLineList.get(i)).getFile()) {
                        testResult = true;
                    }
                    ++i;
                }
            }
            if (testResult && depth >= this.config.getMinCloneLength()) {
                MaxCloneSet maxCloneSet = new MaxCloneSet();
                i = 0;
                while (i < currentList.size()) {
                    LineElement startLine = (LineElement)currentList.get(i);
                    LineElement endLine = (LineElement)currentStartLineList.get(i);
                    CloneInstance ci = this.cif.newInstance(startLine, endLine);
                    maxCloneSet.addCloneInstance(ci);
                    ++i;
                }
                maxCloneSet.setSigLines(depth);
                this.css.addCloneSet(maxCloneSet);
            }
        }
    }

    protected void findClones(LineElement lastLine) {
        boolean count = false;
        do {
            if (!lastLine.bit) {
                ArrayList currentList = (ArrayList)this.ht.get(lastLine.getHashValue());
                int i = 0;
                while (i < currentList.size()) {
                    ((LineElement)currentList.get((int)i)).bit = true;
                    ++i;
                }
                Hashtable<Integer, ArrayList> startTable = new Hashtable<Integer, ArrayList>();
                startTable.put(lastLine.getHashValue(), currentList);
                this.findClonesIterative(startTable, startTable);
            }
            if (this.cancel == null || !this.cancel.isCanceled()) continue;
            return;
        } while ((lastLine = lastLine.getPrevLine()) != null);
    }
}

