/*
 * Decompiled with CFR 0.152.
 */
package de.fzi.cloneanalyzer;

import de.fzi.cloneanalyzer.analyzer.CloneInstanceFactory;
import de.fzi.cloneanalyzer.analyzer.IterativeAnalyzer;
import de.fzi.cloneanalyzer.config.ConsoleConfig;
import de.fzi.cloneanalyzer.config.GenericConfig;
import de.fzi.cloneanalyzer.core.CloneInstance;
import de.fzi.cloneanalyzer.core.CloneSetStructure;
import de.fzi.cloneanalyzer.core.LineElement;
import de.fzi.cloneanalyzer.exceptions.CloneCommentException;
import de.fzi.cloneanalyzer.exceptions.CloneConfigException;
import de.fzi.cloneanalyzer.exceptions.CloneException;
import de.fzi.cloneanalyzer.exceptions.CloneReaderException;
import de.fzi.cloneanalyzer.reader.DirectoryLineElementReader;
import de.fzi.cloneanalyzer.util.TimeLogger;
import java.util.Hashtable;

public class CloneAnalyzerConsole {
    public static CloneSetStructure main(String[] args) {
        try {
            GenericConfig config = ConsoleConfig.readInstanceConsole(args);
            TimeLogger tl = new TimeLogger();
            IterativeAnalyzer a = new IterativeAnalyzer(config, new CloneInstanceFactory(){

                public CloneInstance newInstance(LineElement start, LineElement end) {
                    return new CloneInstance(start, end);
                }
            });
            LineElement lastLineElement = null;
            DirectoryLineElementReader reader = null;
            Hashtable ht = null;
            Object am = null;
            CloneSetStructure css = null;
            tl.log("Start");
            System.out.println(config.toString());
            reader = new DirectoryLineElementReader();
            lastLineElement = reader.read(config, null);
            ht = reader.getHashtable();
            System.gc();
            tl.log("Reading files");
            css = a.buildCloneSetStructure(lastLineElement, ht, null);
            StringBuffer buf = new StringBuffer();
            buf.append("\nOverview\n");
            buf.append("LOC (total) processed," + Integer.toString(reader.getGlobalTotalLineCount()) + "\n");
            buf.append("LOC (significant) processed," + Integer.toString(reader.getGlobalLineCount()) + "\n");
            buf.append("No of Files," + Integer.toString(reader.getCloneFileList().size()) + "\n");
            buf.append("CloneSets found," + Integer.toString(css.getSize()));
            buf.append("\n\n");
            System.out.println(buf.toString());
            css.writeScreen();
            return css;
        }
        catch (CloneCommentException e) {
            System.out.println("There is an Error with the CommentDescriptionFile: " + e.getMessage());
        }
        catch (CloneConfigException e) {
            System.out.println("There is an Error in your Parameters: " + e.getMessage());
            CloneAnalyzerConsole.printUsage();
        }
        catch (CloneReaderException e) {
            System.out.println("Error while reading: " + e.getMessage());
            CloneAnalyzerConsole.printUsage();
        }
        catch (CloneException e) {
            System.out.println("Error: Unexpected Parameters, Aborting...\n");
            CloneAnalyzerConsole.printUsage();
        }
        return null;
    }

    protected static void printUsage() {
        System.out.println("\nusage:   CloneAnalyzerConsole -m MinCloneLength\n-d InputDirectory -f FileFilter -c CommentFileName\n-iw [true|false] -ic [true|false]\n\ndefault: CloneAnalyzerConsole -m 15 -d . -f .*\\.(java|c|cpp|pas) -c comments.conf\n");
    }
}

