/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.pcm.usagemodel.util;

import de.uka.ipd.sdq.identifier.Identifier;
import de.uka.ipd.sdq.identifier.util.IdentifierValidator;
import de.uka.ipd.sdq.pcm.usagemodel.AbstractUserAction;
import de.uka.ipd.sdq.pcm.usagemodel.Branch;
import de.uka.ipd.sdq.pcm.usagemodel.BranchTransition;
import de.uka.ipd.sdq.pcm.usagemodel.ClosedWorkload;
import de.uka.ipd.sdq.pcm.usagemodel.Delay;
import de.uka.ipd.sdq.pcm.usagemodel.EntryLevelSystemCall;
import de.uka.ipd.sdq.pcm.usagemodel.Loop;
import de.uka.ipd.sdq.pcm.usagemodel.OpenWorkload;
import de.uka.ipd.sdq.pcm.usagemodel.ScenarioBehaviour;
import de.uka.ipd.sdq.pcm.usagemodel.Start;
import de.uka.ipd.sdq.pcm.usagemodel.Stop;
import de.uka.ipd.sdq.pcm.usagemodel.UsageModel;
import de.uka.ipd.sdq.pcm.usagemodel.UsageScenario;
import de.uka.ipd.sdq.pcm.usagemodel.UsagemodelPackage;
import de.uka.ipd.sdq.pcm.usagemodel.UserData;
import de.uka.ipd.sdq.pcm.usagemodel.Workload;
import java.util.Map;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.util.EObjectValidator;

public class UsagemodelValidator
extends EObjectValidator {
    public static final String copyright = "Copyright 2005-2009 by SDQ, IPD, University of Karlsruhe, Germany";
    public static final UsagemodelValidator INSTANCE = new UsagemodelValidator();
    public static final String DIAGNOSTIC_SOURCE = "de.uka.ipd.sdq.pcm.usagemodel";
    public static final int ENTRY_LEVEL_SYSTEM_CALL__ENTRY_LEVEL_SYSTEM_CALL_MUST_REFERENCE_PROVIDED_ROLE_OF_ASYSTEM = 1;
    public static final int SCENARIO_BEHAVIOUR__EXACTLYONESTART = 2;
    public static final int SCENARIO_BEHAVIOUR__EXACTLYONESTOP = 3;
    public static final int SCENARIO_BEHAVIOUR__EACHUSERACTIONEXCEPT_STARTAND_STOPMUSTHAVEAPREDECESSORANDSUCCESSOR = 4;
    public static final int BRANCH__ALL_BRANCH_PROBABILITIES_MUST_SUM_UP_TO1 = 5;
    public static final int STOP__STOP_HAS_NO_SUCCESSOR = 6;
    public static final int START__START_HAS_NO_PREDECESSOR = 7;
    public static final int OPEN_WORKLOAD__INTER_ARRIVAL_TIME_IN_OPEN_WORKLOAD_NEEDS_TO_BE_SPECIFIED = 8;
    public static final int CLOSED_WORKLOAD__POPULATION_IN_CLOSED_WORKLOAD_NEEDS_TO_BE_SPECIFIED = 9;
    public static final int CLOSED_WORKLOAD__THINK_TIME_IN_CLOSED_WORKLOAD_NEEDS_TO_BE_SPECIFIED = 10;
    private static final int GENERATED_DIAGNOSTIC_CODE_COUNT = 10;
    protected static final int DIAGNOSTIC_CODE_COUNT = 10;
    protected IdentifierValidator identifierValidator = IdentifierValidator.INSTANCE;

    protected EPackage getEPackage() {
        return UsagemodelPackage.eINSTANCE;
    }

    protected boolean validate(int classifierID, Object value, DiagnosticChain diagnostics, Map<Object, Object> context) {
        switch (classifierID) {
            case 0: {
                return this.validateWorkload((Workload)value, diagnostics, context);
            }
            case 1: {
                return this.validateUsageScenario((UsageScenario)value, diagnostics, context);
            }
            case 2: {
                return this.validateUserData((UserData)value, diagnostics, context);
            }
            case 3: {
                return this.validateUsageModel((UsageModel)value, diagnostics, context);
            }
            case 4: {
                return this.validateEntryLevelSystemCall((EntryLevelSystemCall)value, diagnostics, context);
            }
            case 5: {
                return this.validateAbstractUserAction((AbstractUserAction)value, diagnostics, context);
            }
            case 6: {
                return this.validateScenarioBehaviour((ScenarioBehaviour)value, diagnostics, context);
            }
            case 7: {
                return this.validateBranchTransition((BranchTransition)value, diagnostics, context);
            }
            case 8: {
                return this.validateBranch((Branch)value, diagnostics, context);
            }
            case 9: {
                return this.validateLoop((Loop)value, diagnostics, context);
            }
            case 10: {
                return this.validateStop((Stop)value, diagnostics, context);
            }
            case 11: {
                return this.validateStart((Start)value, diagnostics, context);
            }
            case 12: {
                return this.validateOpenWorkload((OpenWorkload)value, diagnostics, context);
            }
            case 13: {
                return this.validateDelay((Delay)value, diagnostics, context);
            }
            case 14: {
                return this.validateClosedWorkload((ClosedWorkload)value, diagnostics, context);
            }
        }
        return true;
    }

    public boolean validateWorkload(Workload workload, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(workload, diagnostics, context);
    }

    public boolean validateUsageScenario(UsageScenario usageScenario, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result = this.validate_EveryMultiplicityConforms(usageScenario, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(usageScenario, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(usageScenario, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(usageScenario, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(usageScenario, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(usageScenario, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(usageScenario, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.identifierValidator.validateIdentifier_idHasToBeUnique((Identifier)usageScenario, diagnostics, context);
        }
        return result;
    }

    public boolean validateScenarioBehaviour(ScenarioBehaviour scenarioBehaviour, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result = this.validate_EveryMultiplicityConforms(scenarioBehaviour, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(scenarioBehaviour, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(scenarioBehaviour, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(scenarioBehaviour, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(scenarioBehaviour, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(scenarioBehaviour, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(scenarioBehaviour, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.identifierValidator.validateIdentifier_idHasToBeUnique((Identifier)scenarioBehaviour, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateScenarioBehaviour_Exactlyonestart(scenarioBehaviour, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateScenarioBehaviour_Exactlyonestop(scenarioBehaviour, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateScenarioBehaviour_EachuseractionexceptStartandStopmusthaveapredecessorandsuccessor(scenarioBehaviour, diagnostics, context);
        }
        return result;
    }

    public boolean validateScenarioBehaviour_Exactlyonestart(ScenarioBehaviour scenarioBehaviour, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return scenarioBehaviour.Exactlyonestart(diagnostics, context);
    }

    public boolean validateScenarioBehaviour_Exactlyonestop(ScenarioBehaviour scenarioBehaviour, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return scenarioBehaviour.Exactlyonestop(diagnostics, context);
    }

    public boolean validateScenarioBehaviour_EachuseractionexceptStartandStopmusthaveapredecessorandsuccessor(ScenarioBehaviour scenarioBehaviour, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return scenarioBehaviour.EachuseractionexceptStartandStopmusthaveapredecessorandsuccessor(diagnostics, context);
    }

    public boolean validateAbstractUserAction(AbstractUserAction abstractUserAction, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result = this.validate_EveryMultiplicityConforms(abstractUserAction, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(abstractUserAction, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(abstractUserAction, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(abstractUserAction, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(abstractUserAction, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(abstractUserAction, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(abstractUserAction, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.identifierValidator.validateIdentifier_idHasToBeUnique((Identifier)abstractUserAction, diagnostics, context);
        }
        return result;
    }

    public boolean validateBranchTransition(BranchTransition branchTransition, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(branchTransition, diagnostics, context);
    }

    public boolean validateBranch(Branch branch, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result = this.validate_EveryMultiplicityConforms(branch, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(branch, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(branch, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(branch, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(branch, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(branch, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(branch, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.identifierValidator.validateIdentifier_idHasToBeUnique((Identifier)branch, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateBranch_AllBranchProbabilitiesMustSumUpTo1(branch, diagnostics, context);
        }
        return result;
    }

    public boolean validateBranch_AllBranchProbabilitiesMustSumUpTo1(Branch branch, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return branch.AllBranchProbabilitiesMustSumUpTo1(diagnostics, context);
    }

    public boolean validateLoop(Loop loop, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result = this.validate_EveryMultiplicityConforms(loop, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(loop, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(loop, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(loop, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(loop, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(loop, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(loop, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.identifierValidator.validateIdentifier_idHasToBeUnique((Identifier)loop, diagnostics, context);
        }
        return result;
    }

    public boolean validateUsageModel(UsageModel usageModel, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(usageModel, diagnostics, context);
    }

    public boolean validateStop(Stop stop, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result = this.validate_EveryMultiplicityConforms(stop, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(stop, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(stop, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(stop, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(stop, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(stop, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(stop, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.identifierValidator.validateIdentifier_idHasToBeUnique((Identifier)stop, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateStop_StopHasNoSuccessor(stop, diagnostics, context);
        }
        return result;
    }

    public boolean validateStop_StopHasNoSuccessor(Stop stop, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return stop.StopHasNoSuccessor(diagnostics, context);
    }

    public boolean validateStart(Start start, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result = this.validate_EveryMultiplicityConforms(start, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(start, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(start, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(start, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(start, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(start, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(start, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.identifierValidator.validateIdentifier_idHasToBeUnique((Identifier)start, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateStart_StartHasNoPredecessor(start, diagnostics, context);
        }
        return result;
    }

    public boolean validateStart_StartHasNoPredecessor(Start start, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return start.StartHasNoPredecessor(diagnostics, context);
    }

    public boolean validateOpenWorkload(OpenWorkload openWorkload, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result = this.validate_EveryMultiplicityConforms(openWorkload, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(openWorkload, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(openWorkload, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(openWorkload, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(openWorkload, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(openWorkload, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(openWorkload, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateOpenWorkload_InterArrivalTimeInOpenWorkloadNeedsToBeSpecified(openWorkload, diagnostics, context);
        }
        return result;
    }

    public boolean validateOpenWorkload_InterArrivalTimeInOpenWorkloadNeedsToBeSpecified(OpenWorkload openWorkload, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return openWorkload.InterArrivalTimeInOpenWorkloadNeedsToBeSpecified(diagnostics, context);
    }

    public boolean validateEntryLevelSystemCall(EntryLevelSystemCall entryLevelSystemCall, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result = this.validate_EveryMultiplicityConforms(entryLevelSystemCall, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(entryLevelSystemCall, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(entryLevelSystemCall, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(entryLevelSystemCall, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(entryLevelSystemCall, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(entryLevelSystemCall, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(entryLevelSystemCall, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.identifierValidator.validateIdentifier_idHasToBeUnique((Identifier)entryLevelSystemCall, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateEntryLevelSystemCall_EntryLevelSystemCallMustReferenceProvidedRoleOfASystem(entryLevelSystemCall, diagnostics, context);
        }
        return result;
    }

    public boolean validateEntryLevelSystemCall_EntryLevelSystemCallMustReferenceProvidedRoleOfASystem(EntryLevelSystemCall entryLevelSystemCall, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return entryLevelSystemCall.EntryLevelSystemCallMustReferenceProvidedRoleOfASystem(diagnostics, context);
    }

    public boolean validateClosedWorkload(ClosedWorkload closedWorkload, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result = this.validate_EveryMultiplicityConforms(closedWorkload, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(closedWorkload, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(closedWorkload, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(closedWorkload, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(closedWorkload, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(closedWorkload, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(closedWorkload, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateClosedWorkload_PopulationInClosedWorkloadNeedsToBeSpecified(closedWorkload, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateClosedWorkload_ThinkTimeInClosedWorkloadNeedsToBeSpecified(closedWorkload, diagnostics, context);
        }
        return result;
    }

    public boolean validateClosedWorkload_PopulationInClosedWorkloadNeedsToBeSpecified(ClosedWorkload closedWorkload, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return closedWorkload.PopulationInClosedWorkloadNeedsToBeSpecified(diagnostics, context);
    }

    public boolean validateClosedWorkload_ThinkTimeInClosedWorkloadNeedsToBeSpecified(ClosedWorkload closedWorkload, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return closedWorkload.ThinkTimeInClosedWorkloadNeedsToBeSpecified(diagnostics, context);
    }

    public boolean validateDelay(Delay delay, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result = this.validate_EveryMultiplicityConforms(delay, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(delay, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(delay, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(delay, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(delay, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(delay, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(delay, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.identifierValidator.validateIdentifier_idHasToBeUnique((Identifier)delay, diagnostics, context);
        }
        return result;
    }

    public boolean validateUserData(UserData userData, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(userData, diagnostics, context);
    }

    public ResourceLocator getResourceLocator() {
        return super.getResourceLocator();
    }
}

