/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.pcm.resourceenvironment;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum SchedulingPolicy implements Enumerator
{
    EXACT(0, "EXACT", "EXACT"),
    DELAY(1, "DELAY", "DELAY"),
    PROCESSOR_SHARING(2, "PROCESSOR_SHARING", "PROCESSOR_SHARING"),
    FCFS(3, "FCFS", "FCFS");

    public static final String copyright = "Copyright 2005-2009 by SDQ, IPD, University of Karlsruhe, Germany";
    public static final int EXACT_VALUE = 0;
    public static final int DELAY_VALUE = 1;
    public static final int PROCESSOR_SHARING_VALUE = 2;
    public static final int FCFS_VALUE = 3;
    private static final SchedulingPolicy[] VALUES_ARRAY;
    public static final List<SchedulingPolicy> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new SchedulingPolicy[]{EXACT, DELAY, PROCESSOR_SHARING, FCFS};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static SchedulingPolicy get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            SchedulingPolicy result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static SchedulingPolicy getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            SchedulingPolicy result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static SchedulingPolicy get(int value) {
        switch (value) {
            case 0: {
                return EXACT;
            }
            case 1: {
                return DELAY;
            }
            case 2: {
                return PROCESSOR_SHARING;
            }
            case 3: {
                return FCFS;
            }
        }
        return null;
    }

    private SchedulingPolicy(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

