/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.pcm.resourceenvironment;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum ContainerOperatingSystem implements Enumerator
{
    WINDOWS_VISTA(0, "WINDOWS_VISTA", "WINDOWS_VISTA"),
    LINUX26_CFS(1, "LINUX26_CFS", "LINUX26_CFS"),
    LINUX26_O1(2, "LINUX26_O1", "LINUX26_O1"),
    WINDOWS_XP(3, "WINDOWS_XP", "WINDOWS_XP"),
    WINDOWS_7(4, "WINDOWS_7", "WINDOWS_7"),
    WINDOWS_2003(5, "WINDOWS_2003", "WINDOWS_2003"),
    ABSTRACT(6, "ABSTRACT", "ABSTRACT");

    public static final String copyright = "Copyright 2005-2009 by SDQ, IPD, University of Karlsruhe, Germany";
    public static final int WINDOWS_VISTA_VALUE = 0;
    public static final int LINUX26_CFS_VALUE = 1;
    public static final int LINUX26_O1_VALUE = 2;
    public static final int WINDOWS_XP_VALUE = 3;
    public static final int WINDOWS_7_VALUE = 4;
    public static final int WINDOWS_2003_VALUE = 5;
    public static final int ABSTRACT_VALUE = 6;
    private static final ContainerOperatingSystem[] VALUES_ARRAY;
    public static final List<ContainerOperatingSystem> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new ContainerOperatingSystem[]{WINDOWS_VISTA, LINUX26_CFS, LINUX26_O1, WINDOWS_XP, WINDOWS_7, WINDOWS_2003, ABSTRACT};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static ContainerOperatingSystem get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ContainerOperatingSystem result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ContainerOperatingSystem getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ContainerOperatingSystem result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ContainerOperatingSystem get(int value) {
        switch (value) {
            case 0: {
                return WINDOWS_VISTA;
            }
            case 1: {
                return LINUX26_CFS;
            }
            case 2: {
                return LINUX26_O1;
            }
            case 3: {
                return WINDOWS_XP;
            }
            case 4: {
                return WINDOWS_7;
            }
            case 5: {
                return WINDOWS_2003;
            }
            case 6: {
                return ABSTRACT;
            }
        }
        return null;
    }

    private ContainerOperatingSystem(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

