/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.pcm.reliability.util;

import de.uka.ipd.sdq.identifier.Identifier;
import de.uka.ipd.sdq.identifier.util.IdentifierValidator;
import de.uka.ipd.sdq.pcm.reliability.ApplicationFailureType;
import de.uka.ipd.sdq.pcm.reliability.EnvironmentFailureType;
import de.uka.ipd.sdq.pcm.reliability.FailureOccurrenceDescription;
import de.uka.ipd.sdq.pcm.reliability.FailureType;
import de.uka.ipd.sdq.pcm.reliability.ReliabilityPackage;
import de.uka.ipd.sdq.pcm.reliability.StopFailureType;
import java.util.Map;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.util.EObjectValidator;

public class ReliabilityValidator
extends EObjectValidator {
    public static final String copyright = "Copyright 2005-2009 by SDQ, IPD, University of Karlsruhe, Germany";
    public static final ReliabilityValidator INSTANCE = new ReliabilityValidator();
    public static final String DIAGNOSTIC_SOURCE = "de.uka.ipd.sdq.pcm.reliability";
    public static final int FAILURE_OCCURRENCE_DESCRIPTION__ENSURE_VALID_FAILURE_PROBABILITY_RANGE = 1;
    public static final int ENVIRONMENT_FAILURE_TYPE__EXACTLY_ONE_RESOURCE = 2;
    private static final int GENERATED_DIAGNOSTIC_CODE_COUNT = 2;
    protected static final int DIAGNOSTIC_CODE_COUNT = 2;
    protected IdentifierValidator identifierValidator = IdentifierValidator.INSTANCE;

    protected EPackage getEPackage() {
        return ReliabilityPackage.eINSTANCE;
    }

    protected boolean validate(int classifierID, Object value, DiagnosticChain diagnostics, Map<Object, Object> context) {
        switch (classifierID) {
            case 0: {
                return this.validateFailureOccurrenceDescription((FailureOccurrenceDescription)value, diagnostics, context);
            }
            case 1: {
                return this.validateApplicationFailureType((ApplicationFailureType)value, diagnostics, context);
            }
            case 2: {
                return this.validateStopFailureType((StopFailureType)value, diagnostics, context);
            }
            case 3: {
                return this.validateEnvironmentFailureType((EnvironmentFailureType)value, diagnostics, context);
            }
            case 4: {
                return this.validateFailureType((FailureType)value, diagnostics, context);
            }
        }
        return true;
    }

    public boolean validateFailureOccurrenceDescription(FailureOccurrenceDescription failureOccurrenceDescription, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result = this.validate_EveryMultiplicityConforms(failureOccurrenceDescription, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(failureOccurrenceDescription, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(failureOccurrenceDescription, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(failureOccurrenceDescription, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(failureOccurrenceDescription, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(failureOccurrenceDescription, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(failureOccurrenceDescription, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateFailureOccurrenceDescription_EnsureValidFailureProbabilityRange(failureOccurrenceDescription, diagnostics, context);
        }
        return result;
    }

    public boolean validateFailureOccurrenceDescription_EnsureValidFailureProbabilityRange(FailureOccurrenceDescription failureOccurrenceDescription, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return failureOccurrenceDescription.EnsureValidFailureProbabilityRange(diagnostics, context);
    }

    public boolean validateApplicationFailureType(ApplicationFailureType applicationFailureType, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result = this.validate_EveryMultiplicityConforms(applicationFailureType, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(applicationFailureType, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(applicationFailureType, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(applicationFailureType, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(applicationFailureType, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(applicationFailureType, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(applicationFailureType, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.identifierValidator.validateIdentifier_idHasToBeUnique((Identifier)applicationFailureType, diagnostics, context);
        }
        return result;
    }

    public boolean validateStopFailureType(StopFailureType stopFailureType, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result = this.validate_EveryMultiplicityConforms(stopFailureType, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(stopFailureType, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(stopFailureType, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(stopFailureType, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(stopFailureType, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(stopFailureType, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(stopFailureType, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.identifierValidator.validateIdentifier_idHasToBeUnique((Identifier)stopFailureType, diagnostics, context);
        }
        return result;
    }

    public boolean validateEnvironmentFailureType(EnvironmentFailureType environmentFailureType, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result = this.validate_EveryMultiplicityConforms(environmentFailureType, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(environmentFailureType, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(environmentFailureType, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(environmentFailureType, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(environmentFailureType, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(environmentFailureType, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(environmentFailureType, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.identifierValidator.validateIdentifier_idHasToBeUnique((Identifier)environmentFailureType, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateEnvironmentFailureType_ExactlyOneResource(environmentFailureType, diagnostics, context);
        }
        return result;
    }

    public boolean validateEnvironmentFailureType_ExactlyOneResource(EnvironmentFailureType environmentFailureType, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return environmentFailureType.ExactlyOneResource(diagnostics, context);
    }

    public boolean validateFailureType(FailureType failureType, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result = this.validate_EveryMultiplicityConforms(failureType, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(failureType, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(failureType, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(failureType, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(failureType, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(failureType, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(failureType, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.identifierValidator.validateIdentifier_idHasToBeUnique((Identifier)failureType, diagnostics, context);
        }
        return result;
    }

    public ResourceLocator getResourceLocator() {
        return super.getResourceLocator();
    }
}

