/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.pcm.allocation.util;

import de.uka.ipd.sdq.identifier.Identifier;
import de.uka.ipd.sdq.identifier.util.IdentifierValidator;
import de.uka.ipd.sdq.pcm.allocation.Allocation;
import de.uka.ipd.sdq.pcm.allocation.AllocationContext;
import de.uka.ipd.sdq.pcm.allocation.AllocationPackage;
import java.util.Map;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.util.EObjectValidator;

public class AllocationValidator
extends EObjectValidator {
    public static final String copyright = "Copyright 2005-2009 by SDQ, IPD, University of Karlsruhe, Germany";
    public static final AllocationValidator INSTANCE = new AllocationValidator();
    public static final String DIAGNOSTIC_SOURCE = "de.uka.ipd.sdq.pcm.allocation";
    public static final int ALLOCATION__EACH_ASSEMBLY_CONTEXT_WITHIN_SYSTEM_HAS_TO_BE_ALLOCATED_EXACTLY_ONCE = 1;
    private static final int GENERATED_DIAGNOSTIC_CODE_COUNT = 1;
    protected static final int DIAGNOSTIC_CODE_COUNT = 1;
    protected IdentifierValidator identifierValidator = IdentifierValidator.INSTANCE;

    protected EPackage getEPackage() {
        return AllocationPackage.eINSTANCE;
    }

    protected boolean validate(int classifierID, Object value, DiagnosticChain diagnostics, Map<Object, Object> context) {
        switch (classifierID) {
            case 0: {
                return this.validateAllocationContext((AllocationContext)value, diagnostics, context);
            }
            case 1: {
                return this.validateAllocation((Allocation)value, diagnostics, context);
            }
        }
        return true;
    }

    public boolean validateAllocationContext(AllocationContext allocationContext, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result = this.validate_EveryMultiplicityConforms(allocationContext, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(allocationContext, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(allocationContext, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(allocationContext, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(allocationContext, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(allocationContext, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(allocationContext, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.identifierValidator.validateIdentifier_idHasToBeUnique((Identifier)allocationContext, diagnostics, context);
        }
        return result;
    }

    public boolean validateAllocation(Allocation allocation, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result = this.validate_EveryMultiplicityConforms(allocation, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(allocation, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(allocation, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(allocation, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(allocation, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(allocation, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(allocation, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.identifierValidator.validateIdentifier_idHasToBeUnique((Identifier)allocation, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateAllocation_EachAssemblyContextWithinSystemHasToBeAllocatedExactlyOnce(allocation, diagnostics, context);
        }
        return result;
    }

    public boolean validateAllocation_EachAssemblyContextWithinSystemHasToBeAllocatedExactlyOnce(Allocation allocation, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return allocation.EachAssemblyContextWithinSystemHasToBeAllocatedExactlyOnce(diagnostics, context);
    }

    public ResourceLocator getResourceLocator() {
        return super.getResourceLocator();
    }
}

