/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.workflow.launchconfig.tabs;

import de.uka.ipd.sdq.workflow.launchconfig.ConstantsContainer;
import de.uka.ipd.sdq.workflow.launchconfig.RunConfigImages;
import de.uka.ipd.sdq.workflow.launchconfig.RunConfigPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class ConfigurationTab
extends AbstractLaunchConfigurationTab {
    private Text outputPathField;
    private Label locationLabel;

    public Image getImage() {
        return RunConfigImages.getConfigurationTabImage();
    }

    public void createControl(Composite parent) {
        ModifyListener modifyListener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ConfigurationTab.this.setDirty(true);
                ConfigurationTab.this.updateLaunchConfigurationDialog();
            }
        };
        Composite container = new Composite(parent, 0);
        this.setControl((Control)container);
        container.setLayout((Layout)new GridLayout());
        Group outputPathGroup = new Group(container, 0);
        outputPathGroup.setText("Plugin ID");
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 4;
        outputPathGroup.setLayout((Layout)gridLayout);
        GridData gd_outputPathGroup = new GridData(4, 0x1000000, true, false);
        outputPathGroup.setLayoutData((Object)gd_outputPathGroup);
        final Button defaultLocationButton = new Button((Composite)outputPathGroup, 32);
        GridData gridData_dl = new GridData(16384, 0x1000000, false, false, 4, 1);
        defaultLocationButton.setLayoutData((Object)gridData_dl);
        defaultLocationButton.setText("Use default location");
        defaultLocationButton.setSelection(true);
        defaultLocationButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ConfigurationTab.this.setElementsEnabled(false);
                ConfigurationTab.this.outputPathField.setText(ConstantsContainer.SIMUCOM_DEFAULT_PROJECT_ID);
                if (!defaultLocationButton.getSelection()) {
                    ConfigurationTab.this.setElementsEnabled(true);
                    ConfigurationTab.this.outputPathField.setSelection(0);
                }
            }
        });
        this.locationLabel = new Label((Composite)outputPathGroup, 0);
        this.locationLabel.setLayoutData((Object)new GridData(48, -1));
        this.locationLabel.setText("Location:");
        this.outputPathField = new Text((Composite)outputPathGroup, 2048);
        GridData gridData = new GridData(4, 0x1000000, true, false);
        gridData.widthHint = 20;
        this.outputPathField.setLayoutData((Object)gridData);
        this.outputPathField.setText(ConstantsContainer.SIMUCOM_DEFAULT_PROJECT_ID);
        this.outputPathField.addModifyListener(modifyListener);
        this.setElementsEnabled(false);
    }

    private void setElementsEnabled(boolean enable) {
        this.locationLabel.setEnabled(enable);
        this.outputPathField.setEnabled(enable);
    }

    public String getName() {
        return "Configuration";
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        try {
            this.outputPathField.setText(configuration.getAttribute("outpath", ConstantsContainer.SIMUCOM_DEFAULT_PROJECT_ID));
        }
        catch (CoreException e) {
            RunConfigPlugin.errorLogger(this.getName(), "Location", e.getMessage());
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute("outpath", this.outputPathField.getText());
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
    }

    public boolean isValid(ILaunchConfiguration launchConfig) {
        this.setErrorMessage(null);
        if (this.outputPathField.getText().equals("")) {
            this.setErrorMessage("The output path location is not specified!");
            return false;
        }
        return true;
    }

    public void activated(ILaunchConfigurationWorkingCopy workingCopy) {
    }

    public void deactivated(ILaunchConfigurationWorkingCopy workingCopy) {
    }
}

