/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.workflow.launchconfig.logging;

import de.uka.ipd.sdq.workflow.launchconfig.logging.IAppenderListener;
import java.util.ArrayList;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.spi.Filter;
import org.apache.log4j.spi.LoggingEvent;
import org.apache.log4j.spi.ThrowableInformation;

public class StreamsProxyAppender
extends AppenderSkeleton {
    private ArrayList<IAppenderListener> appenderListener = new ArrayList();
    private ClassLoader myClassloader = Thread.currentThread().getContextClassLoader();

    public StreamsProxyAppender() {
        this.addFilter(new Filter(){

            public int decide(LoggingEvent logEvent) {
                if (StreamsProxyAppender.this.myClassloader == Thread.currentThread().getContextClassLoader()) {
                    return 1;
                }
                return -1;
            }
        });
    }

    protected void append(LoggingEvent event) {
        String logLine = this.getLayout().format(event);
        for (IAppenderListener l : this.appenderListener) {
            l.textAddedEvent(logLine, event.getLevel());
            ThrowableInformation throwableInfo = event.getThrowableInformation();
            if (throwableInfo == null) continue;
            String[] stringArray = throwableInfo.getThrowableStrRep();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String m = stringArray[n2];
                l.textAddedEvent(String.valueOf(m) + "\n", event.getLevel());
                ++n2;
            }
        }
    }

    public void close() {
    }

    public boolean requiresLayout() {
        return true;
    }

    public void addAppenderListener(IAppenderListener listener) {
        this.appenderListener.add(listener);
    }

    public void removeAppenderListener(IAppenderListener listener) {
        this.appenderListener.remove(listener);
    }
}

