/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.workflow.launchconfig;

import de.uka.ipd.sdq.workflow.launchconfig.AbstractWorkflowBasedRunConfiguration;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;

public abstract class AbstractWorkflowConfigurationBuilder {
    protected ILaunchConfiguration configuration;
    protected boolean isDebug;
    protected Map<String, Object> properties;

    public AbstractWorkflowConfigurationBuilder(ILaunchConfiguration configuration, String mode) throws CoreException {
        this.configuration = configuration;
        this.isDebug = mode.equals("debug");
        this.properties = configuration.getAttributes();
    }

    public abstract void fillConfiguration(AbstractWorkflowBasedRunConfiguration var1) throws CoreException;

    protected boolean hasAttribute(String attribute) throws CoreException {
        return this.configuration.hasAttribute(attribute);
    }

    protected boolean hasStringAttribute(String attribute) throws CoreException {
        if (!this.configuration.hasAttribute(attribute)) {
            return false;
        }
        String value = this.getStringAttribute(attribute);
        return value instanceof String && !value.equals("");
    }

    protected String getStringAttribute(String attribute) throws CoreException {
        this.ensureAttributeExists(attribute);
        String value = this.configuration.getAttribute(attribute, "");
        if (!(value instanceof String)) {
            throw new IllegalArgumentException("Tried to read non-string value as string value");
        }
        return value;
    }

    protected double getDoubleAttribute(String attribute) throws CoreException {
        this.ensureAttributeExists(attribute);
        String value = this.configuration.getAttribute(attribute, "");
        if (!(value instanceof String)) {
            throw new IllegalArgumentException("Tried to read non-double value as double value");
        }
        return Double.parseDouble(value);
    }

    protected int getIntegerAttribute(String attribute) throws CoreException {
        this.ensureAttributeExists(attribute);
        return this.configuration.getAttribute(attribute, 0);
    }

    protected long getLongAttribute(String attribute) throws CoreException {
        this.ensureAttributeExists(attribute);
        return this.configuration.getAttribute(attribute, 0);
    }

    protected Boolean getBooleanAttribute(String attribute) throws CoreException {
        if (!this.hasAttribute(attribute)) {
            return false;
        }
        Boolean value = this.configuration.getAttribute(attribute, false);
        if (!(value instanceof Boolean)) {
            throw new IllegalArgumentException("Tried to read non-boolean value as boolean value");
        }
        return value;
    }

    private void ensureAttributeExists(String attribute) throws CoreException {
        if (!this.configuration.hasAttribute(attribute)) {
            throw new IllegalStateException("Tried to read non-existing configuration attribute");
        }
    }
}

