/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.pcm.dialogs.stoex;

import de.uka.ipd.sdq.errorhandling.IIssue;
import de.uka.ipd.sdq.pcm.dialogs.SWTResourceManager;
import de.uka.ipd.sdq.pcm.dialogs.stoex.AbstractGrammarBasedViewerConfiguration;
import de.uka.ipd.sdq.pcm.dialogs.stoex.AnnotationMarkerAccess;
import de.uka.ipd.sdq.pcm.dialogs.stoex.ITokenMapper;
import de.uka.ipd.sdq.pcm.dialogs.stoex.ParserHelper;
import de.uka.ipd.sdq.pcm.dialogs.stoex.StoExParserException;
import de.uka.ipd.sdq.pcm.repository.Parameter;
import de.uka.ipd.sdq.pcm.stochasticexpressions.parser.ErrorEntry;
import org.antlr.runtime.Lexer;
import org.antlr.runtime.RecognitionException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IPainter;
import org.eclipse.jface.text.ITextListener;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.TextEvent;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.AnnotationModel;
import org.eclipse.jface.text.source.AnnotationPainter;
import org.eclipse.jface.text.source.AnnotationRulerColumn;
import org.eclipse.jface.text.source.CompositeRuler;
import org.eclipse.jface.text.source.IAnnotationAccess;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.IVerticalRulerColumn;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public abstract class AbstractGrammerBasedEditDialog
extends TitleAreaDialog {
    private String DIALOG_TITLE = "Edit a stochastic expression";
    public static final String ERROR_TYPE = "ERROR";
    public static final String WARNING_TYPE = "WARNING";
    private SourceViewer textViewer;
    protected String newText = this.getInitialText();
    private AnnotationModel fAnnotationModel;
    private Object result = null;
    private String resultText = null;
    protected Parameter[] context = null;

    public AbstractGrammerBasedEditDialog(Shell parent) {
        super(parent);
        this.context = new Parameter[0];
        this.setShellStyle(1040);
    }

    public AbstractGrammerBasedEditDialog(Shell parent, Parameter[] context) {
        super(parent);
        this.context = context;
        this.setShellStyle(1040);
        this.setHelpAvailable(true);
    }

    protected abstract String getInitialText();

    public void setDisplayTitle(String newTitle) {
        this.DIALOG_TITLE = newTitle;
    }

    protected void cancelPressed() {
        super.cancelPressed();
        this.result = null;
        this.resultText = "";
    }

    protected Control createDialogArea(Composite parent) {
        Composite area = (Composite)super.createDialogArea(parent);
        Composite container = new Composite(area, 0);
        container.setLayout((Layout)new FillLayout());
        container.setLayoutData((Object)new GridData(1808));
        this.setTitle(this.DIALOG_TITLE);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "de.uka.ipd.sdq.pcmbench.help.stoexdialog");
        AnnotationMarkerAccess fAnnotationAccess = new AnnotationMarkerAccess();
        Group editStochasticExpressionGroup = new Group(container, 0);
        editStochasticExpressionGroup.setText("");
        editStochasticExpressionGroup.setLayout((Layout)new FillLayout());
        this.fAnnotationModel = new AnnotationModel();
        CompositeRuler fCompositeRuler = new CompositeRuler();
        AnnotationRulerColumn annotationRuler = new AnnotationRulerColumn((IAnnotationModel)this.fAnnotationModel, 16, (IAnnotationAccess)fAnnotationAccess);
        fCompositeRuler.setModel((IAnnotationModel)this.fAnnotationModel);
        fCompositeRuler.addDecorator(0, (IVerticalRulerColumn)annotationRuler);
        annotationRuler.addAnnotationType((Object)ERROR_TYPE);
        annotationRuler.addAnnotationType((Object)WARNING_TYPE);
        this.textViewer = new SourceViewer((Composite)editStochasticExpressionGroup, (IVerticalRuler)fCompositeRuler, 786);
        StyledText styledText = this.textViewer.getTextWidget();
        styledText.setWordWrap(true);
        final AbstractGrammarBasedViewerConfiguration config = new AbstractGrammarBasedViewerConfiguration((IAnnotationModel)this.fAnnotationModel, this.context, this.getLexerClass(), this.getTokenMapper());
        styledText.setFont(SWTResourceManager.getFont("Courier New", 12, 0));
        styledText.addListener(1, new Listener(){

            public void handleEvent(Event event) {
                if (event.character == ' ' && (event.stateMask & 0x40000) == 262144) {
                    config.getContentAssistant((ISourceViewer)AbstractGrammerBasedEditDialog.this.textViewer).showPossibleCompletions();
                }
            }
        });
        AnnotationPainter ap = new AnnotationPainter((ISourceViewer)this.textViewer, (IAnnotationAccess)fAnnotationAccess);
        ap.addAnnotationType((Object)ERROR_TYPE);
        ap.setAnnotationTypeColor((Object)ERROR_TYPE, new Color((Device)Display.getDefault(), new RGB(255, 0, 0)));
        ap.addAnnotationType((Object)WARNING_TYPE);
        ap.setAnnotationTypeColor((Object)WARNING_TYPE, new Color((Device)Display.getDefault(), new RGB(255, 255, 0)));
        this.textViewer.addPainter((IPainter)ap);
        this.textViewer.configure((SourceViewerConfiguration)config);
        new GridData(1808);
        this.textViewer.setDocument((IDocument)new Document(this.newText), (IAnnotationModel)this.fAnnotationModel);
        this.textViewer.addTextListener(new ITextListener(){

            public void textChanged(TextEvent event) {
                if (event.getDocumentEvent() != null) {
                    AbstractGrammerBasedEditDialog.this.parseInputAndRefreshAnnotations();
                }
            }
        });
        return this.textViewer.getControl();
    }

    protected Control createContents(Composite parent) {
        Control result = super.createContents(parent);
        this.parseInputAndRefreshAnnotations();
        return result;
    }

    protected abstract ITokenMapper getTokenMapper();

    protected abstract Class<?> getLexerClass();

    protected abstract String getTitle();

    /*
     * Unable to fully structure code
     */
    protected void parseInputAndRefreshAnnotations() {
        block10: {
            value = null;
            this.fAnnotationModel.removeAllAnnotations();
            lexer = null;
            hasErrors = false;
            hasWarnings = false;
            try {
                text = this.textViewer.getDocument().get();
                lexer = this.getLexer(text);
                value = this.parse(lexer);
            }
            catch (RecognitionException e) {
                this.showInputInvalidInfo((Exception)e);
                return;
            }
            catch (StoExParserException e) {
                ** for (ex : e.getIssuesList())
            }
lbl-1000:
            // 1 sources

            {
                if (ex instanceof ErrorEntry) {
                    this.showInputInvalidInfo((ErrorEntry)ex);
                    hasErrors = true;
                    continue;
                }
                hasWarnings = true;
                this.showInputWarning(ex);
                continue;
            }
lbl23:
            // 1 sources

            if (hasErrors) {
                return;
            }
            if (hasWarnings) {
                this.setMessage(e.getIssuesList().get(0).getMessage(), 2);
            }
            break block10;
            catch (Exception e) {
                this.showInputInvalidInfo(e);
                return;
            }
        }
        this.getButton(0).setEnabled(true);
        if (!hasErrors) {
            this.setErrorMessage(null);
        }
        if (!hasWarnings) {
            this.setMessage(null);
        }
        this.result = value;
        this.resultText = this.textViewer.getDocument().get();
    }

    private void showInputWarning(IIssue ex) {
        this.fAnnotationModel.addAnnotation(new Annotation(WARNING_TYPE, false, ex.getMessage()), new Position(0, this.textViewer.getDocument().getLength()));
    }

    protected abstract Lexer getLexer(String var1);

    protected abstract EObject parse(Lexer var1) throws RecognitionException, StoExParserException;

    private void showInputInvalidInfo(Exception e) {
        this.result = null;
        this.fAnnotationModel.addAnnotation(new Annotation(ERROR_TYPE, false, e.getMessage() == null ? e.getClass().getName() : e.getMessage()), this.guessPosition(e));
        this.getButton(0).setEnabled(false);
        this.setErrorMessage("Entered stochastic expression is invalid. Cause given: " + e.getLocalizedMessage());
    }

    private void showInputInvalidInfo(ErrorEntry e) {
        this.result = null;
        this.fAnnotationModel.addAnnotation(new Annotation(ERROR_TYPE, false, e.getMessage()), this.guessPosition((Exception)((Object)e.getEx())));
        this.getButton(0).setEnabled(false);
        this.setErrorMessage("Entered stochastic expression is invalid. Cause given: " + e.getMessage());
    }

    private Position guessPosition(Exception e) {
        if (e instanceof RecognitionException) {
            RecognitionException recException = (RecognitionException)((Object)e);
            int col = recException.charPositionInLine;
            int line = recException.line;
            int offset = ParserHelper.positionToOffset(this.textViewer.getDocument(), line, col);
            offset = offset < 0 ? 0 : offset;
            return new Position(offset, this.textViewer.getDocument().getLength() - offset);
        }
        return new Position(0, this.textViewer.getDocument().getLength());
    }

    protected Object getResult() {
        return this.result;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(this.getTitle());
    }

    public String getResultText() {
        return this.resultText;
    }
}

