/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.pcm.dialogs.parameters;

import de.uka.ipd.sdq.pcm.dialogs.Messages;
import de.uka.ipd.sdq.pcm.dialogs.datatype.PalladioDataTypeDialog;
import de.uka.ipd.sdq.pcm.dialogs.parameters.CreateEditorContents;
import de.uka.ipd.sdq.pcm.repository.CompositeDataType;
import de.uka.ipd.sdq.pcm.repository.InnerDeclaration;
import de.uka.ipd.sdq.pcm.repository.OperationSignature;
import de.uka.ipd.sdq.pcm.repository.Parameter;
import org.eclipse.core.runtime.Assert;
import org.eclipse.emf.common.util.EList;

public class UpDownButtonsValidator {
    private static UpDownButtonsValidator singelton = null;
    private CreateEditorContents contents;

    private UpDownButtonsValidator() {
    }

    public void validate(int elementIndex, int maxIndex) {
        Assert.isNotNull((Object)this.contents);
        this.contents.setDownItemsEnabled(true);
        this.contents.setUpItemsEnabled(true);
        if (elementIndex == 0) {
            this.contents.setUpItemsEnabled(false);
        }
        if (elementIndex == maxIndex - 1) {
            this.contents.setDownItemsEnabled(false);
        }
    }

    public void validateSelection(Object selection) {
        if (selection == null) {
            this.contents.setDeleteItemsEnabled(false);
            this.contents.setDownItemsEnabled(false);
            this.contents.setUpItemsEnabled(false);
        } else if (selection instanceof Parameter) {
            Parameter parameter = (Parameter)selection;
            UpDownButtonsValidator.getSingelton().validateParameter(parameter);
            this.contents.setDeleteItemsEnabled(true);
        } else if (selection instanceof InnerDeclaration) {
            InnerDeclaration declaration = (InnerDeclaration)selection;
            UpDownButtonsValidator.getSingelton().validateInnerDeclaration(declaration);
            this.contents.setDeleteItemsEnabled(true);
        }
    }

    public void validateParameter(Parameter parameter) {
        OperationSignature signature = parameter.getOperationSignature__Parameter();
        EList parameters = signature.getParameters__OperationSignature();
        this.validate(parameters.indexOf((Object)parameter), parameters.size());
    }

    public void validateInnerDeclaration(InnerDeclaration declaration) {
        if (declaration.eContainer() instanceof CompositeDataType) {
            CompositeDataType dataType = (CompositeDataType)declaration.eContainer();
            EList declarations = dataType.getInnerDeclaration_CompositeDataType();
            this.validate(declarations.indexOf((Object)declaration), declarations.size());
        }
    }

    public boolean validdateDeclarationInnerDataType(InnerDeclaration declaration, PalladioDataTypeDialog dialog) {
        if (declaration.getDatatype_InnerDeclaration() == null) {
            dialog.setErrorMessage(Messages.DataTypeDialog_ErrorMsgInnerName);
            return false;
        }
        if (declaration.getEntityName().equals("")) {
            dialog.setErrorMessage(Messages.DataTypeDialog_ErrorMsgInnerName);
            return false;
        }
        return true;
    }

    public static UpDownButtonsValidator getSingelton() {
        if (singelton == null) {
            singelton = new UpDownButtonsValidator();
        }
        return singelton;
    }

    public void setContents(CreateEditorContents contents) {
        this.contents = contents;
    }
}

