/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.pcm.dialogs.parameters;

import de.uka.ipd.sdq.pcm.dialogs.parameters.CreateEditorContents;
import de.uka.ipd.sdq.pcm.dialogs.parameters.ParametersItemProvider;
import de.uka.ipd.sdq.pcm.repository.DataType;
import de.uka.ipd.sdq.pcm.repository.Parameter;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.widgets.TableItem;

public class ParametersCellModifier
implements ICellModifier {
    private TableViewer viewer;
    private List<String> columnNames;
    private Parameter parameter;
    private TransactionalEditingDomain editingDomain = null;

    public ParametersCellModifier(TableViewer viewer, TransactionalEditingDomain editingDomain) {
        this.viewer = viewer;
        this.columnNames = Arrays.asList(CreateEditorContents.getColumnNames());
        this.editingDomain = editingDomain;
    }

    public boolean canModify(Object element, String property) {
        return true;
    }

    public Object getValue(Object element, String property) {
        return new ParametersItemProvider(null).getColumnText(element, this.columnNames.indexOf(property));
    }

    public void modify(Object element, String property, Object value) {
        int columnIndex = this.columnNames.indexOf(property);
        Assert.isNotNull((Object)element);
        TableItem item = (TableItem)element;
        this.parameter = (Parameter)item.getData();
        switch (columnIndex) {
            case 0: {
                break;
            }
            case 1: {
                break;
            }
            case 3: {
                String valueString = ((String)value).trim();
                this.setParameterName(valueString);
                break;
            }
            case 2: {
                if (!(value instanceof DataType)) break;
                DataType valueDataType = (DataType)value;
                this.setDataType(valueDataType);
            }
        }
    }

    private void setDataType(final DataType dataType) {
        RecordingCommand recCommand = new RecordingCommand(this.editingDomain){

            protected void doExecute() {
                ParametersCellModifier.this.parameter.setDatatype__Parameter(dataType);
            }
        };
        if (!dataType.equals(this.parameter.getDatatype__Parameter())) {
            recCommand.setDescription("Edit Parameter Property");
            recCommand.setLabel("Set parameter DataType");
            this.editingDomain.getCommandStack().execute((Command)recCommand);
        }
        this.reloadParametersViewer();
    }

    private void setParameterName(String valueString) {
        final String value = valueString;
        RecordingCommand recCommand = new RecordingCommand(this.editingDomain){

            protected void doExecute() {
                ParametersCellModifier.this.parameter.setParameterName(value);
            }
        };
        if (!value.equals(this.parameter.getParameterName())) {
            recCommand.setLabel("Set ParameterName");
            this.editingDomain.getCommandStack().execute((Command)recCommand);
        }
        this.reloadParametersViewer();
    }

    private void reloadParametersViewer() {
        this.viewer.refresh();
    }
}

