/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.pcm.dialogs.datatype;

import de.uka.ipd.sdq.pcm.dialogs.Messages;
import de.uka.ipd.sdq.pcm.dialogs.datatype.AddInnerDeclarationAction;
import de.uka.ipd.sdq.pcm.dialogs.datatype.CallDataTypeDialog;
import de.uka.ipd.sdq.pcm.dialogs.datatype.DataTypeCommand;
import de.uka.ipd.sdq.pcm.dialogs.datatype.DataTypeDialog;
import de.uka.ipd.sdq.pcm.dialogs.datatype.DataTypeEnum;
import de.uka.ipd.sdq.pcm.dialogs.datatype.DeleteInnerDeclarationAction;
import de.uka.ipd.sdq.pcm.dialogs.datatype.DownInnerDeclarationAction;
import de.uka.ipd.sdq.pcm.dialogs.datatype.InnerDeclarationCellModifier;
import de.uka.ipd.sdq.pcm.dialogs.datatype.InnerDeclarationItemProviderAdapterFactory;
import de.uka.ipd.sdq.pcm.dialogs.datatype.ParameterRepresentation;
import de.uka.ipd.sdq.pcm.dialogs.datatype.UpInnerDeclarationAction;
import de.uka.ipd.sdq.pcm.dialogs.parameters.CreateEditorContents;
import de.uka.ipd.sdq.pcm.dialogs.parameters.UpDownButtonsValidator;
import de.uka.ipd.sdq.pcm.repository.CollectionDataType;
import de.uka.ipd.sdq.pcm.repository.CompositeDataType;
import de.uka.ipd.sdq.pcm.repository.DataType;
import de.uka.ipd.sdq.pcm.repository.InnerDeclaration;
import de.uka.ipd.sdq.pcm.repository.Repository;
import de.uka.ipd.sdq.pcm.repository.provider.RepositoryItemProviderAdapterFactory;
import de.uka.ipd.sdq.pcmbench.ui.provider.PalladioItemProviderAdapterFactory;
import java.util.ArrayList;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;

public class PalladioDataTypeDialog
extends DataTypeDialog {
    private final String UNNAMED_REPOSITORY = "<Unnamed Repository>";
    private ComposedAdapterFactory adapterFactory;
    private DataType innerDataType;
    private DataType editedDataType;
    private CreateEditorContents editorContents;
    private Repository editedRepository;
    private CompositeDataType compositeDataType;
    private TransactionalEditingDomain editingDomain = null;

    public PalladioDataTypeDialog(Shell parentShell, TransactionalEditingDomain editingDomain) {
        super(parentShell);
        this.editingDomain = editingDomain;
    }

    public PalladioDataTypeDialog(Shell parentShell, DataType editeDataType) {
        super(parentShell);
        this.editingDomain = TransactionUtil.getEditingDomain((EObject)editeDataType);
        this.editedDataType = editeDataType;
        this.initDialog(editeDataType);
    }

    private void initDialog(DataType editeDataType) {
        String repository;
        String entityName;
        if (editeDataType instanceof CollectionDataType) {
            CollectionDataType collectionDataType = (CollectionDataType)editeDataType;
            entityName = collectionDataType.getEntityName();
            repository = collectionDataType.getRepository_DataType().getEntityName();
            String entityInnerType = ParameterRepresentation.dataTypeToString(collectionDataType.getInnerType_CollectionDataType());
            this.create();
            super.init(DataTypeEnum.COLLECTION, repository, entityName, entityInnerType);
        }
        if (editeDataType instanceof CompositeDataType) {
            this.compositeDataType = (CompositeDataType)editeDataType;
            entityName = this.compositeDataType.getEntityName();
            repository = this.compositeDataType.getRepository_DataType().getEntityName();
            this.create();
            super.init(DataTypeEnum.COMPOSITE, repository, entityName, null);
        }
    }

    @Override
    public String[] getLoadedRepositories() {
        EList resources = this.editingDomain.getResourceSet().getResources();
        ArrayList<String> tList = new ArrayList<String>();
        for (Resource r : resources) {
            URI uri = r.getURI();
            if (!this.hasRepositoryExtension(uri) || this.isPrimitiveTypesRepository(uri) || r.getContents().isEmpty() || !(r.getContents().get(0) instanceof Repository)) continue;
            Repository repository = (Repository)r.getContents().get(0);
            String repositoryName = repository.getEntityName();
            tList.add(repositoryName == null ? "<Unnamed Repository>" : repositoryName);
        }
        return tList.toArray(new String[tList.size()]);
    }

    private boolean hasRepositoryExtension(URI uri) {
        return uri.fileExtension().equals("repository");
    }

    private boolean isPrimitiveTypesRepository(URI uri) {
        String exp = "/PrimitiveTypes.repository";
        return uri.path().endsWith(exp);
    }

    @Override
    public void setEditedResource(String repositoryName) {
        EList resources = this.editingDomain.getResourceSet().getResources();
        for (Resource r : resources) {
            String entityName;
            if (r.getContents().isEmpty() || !(r.getContents().get(0) instanceof Repository)) continue;
            Repository repository = (Repository)r.getContents().get(0);
            String string = entityName = repository.getEntityName() == null ? "<Unnamed Repository>" : repository.getEntityName();
            if (!entityName.contains(repositoryName)) continue;
            this.editedRepository = repository;
        }
    }

    @Override
    public void createInnerSectionCompositeGroup(Composite group) {
        this.adapterFactory = new ComposedAdapterFactory();
        this.adapterFactory.addAdapterFactory((AdapterFactory)new RepositoryItemProviderAdapterFactory());
        this.editorContents = CreateEditorContents.create(group);
        this.editorContents.setViewerContentProvider((IContentProvider)new AdapterFactoryContentProvider((AdapterFactory)this.adapterFactory));
        this.editorContents.setViewerLabelProvider((IBaseLabelProvider)new AdapterFactoryLabelProvider((AdapterFactory)new InnerDeclarationItemProviderAdapterFactory((AdapterFactory)new PalladioItemProviderAdapterFactory((AdapterFactory)this.adapterFactory))));
        this.editorContents.setViewerCellModifier(new InnerDeclarationCellModifier(this, this.editingDomain));
        this.editorContents.createNameColumnCellEditor();
        this.editorContents.createTypeColumnCellEditor(this.editingDomain);
        this.editorContents.setAddButtonActionListener((SelectionListener)new AddInnerDeclarationAction(this, this.editingDomain));
        DeleteInnerDeclarationAction deleteInnerDeclarationAction = new DeleteInnerDeclarationAction(this, this.editingDomain);
        UpInnerDeclarationAction upInnerDeclarationAction = new UpInnerDeclarationAction(this, this.editingDomain);
        DownInnerDeclarationAction downInnerDeclarationAction = new DownInnerDeclarationAction(this, this.editingDomain);
        this.editorContents.setDeleteButtonActionListener(deleteInnerDeclarationAction);
        this.editorContents.setUpButtonActionListener(upInnerDeclarationAction);
        this.editorContents.setDownButtonActionListener(downInnerDeclarationAction);
        this.editorContents.setViewerSelectionChangedListener(deleteInnerDeclarationAction);
        this.editorContents.setViewerSelectionChangedListener(upInnerDeclarationAction);
        this.editorContents.setViewerSelectionChangedListener(downInnerDeclarationAction);
        this.editorContents.setViewerInput(this.editedDataType);
    }

    @Override
    public String getSelectedInnerType(SelectionEvent e) {
        String selectedType = "null";
        ArrayList<Object> filterList = new ArrayList<Object>();
        filterList.add(DataType.class);
        filterList.add(Repository.class);
        CallDataTypeDialog dialog = new CallDataTypeDialog(e.display.getActiveShell(), filterList, new ArrayList<EReference>(), this.editingDomain.getResourceSet());
        dialog.setProvidedService(DataType.class);
        dialog.open();
        if (dialog.getResult() != null && dialog.getResult() instanceof DataType) {
            this.innerDataType = (DataType)dialog.getResult();
            selectedType = ParameterRepresentation.dataTypeToString(this.innerDataType);
        }
        return selectedType;
    }

    @Override
    public boolean validateCompositeDataType() {
        boolean state = true;
        if (this.compositeDataType == null || this.compositeDataType.getInnerDeclaration_CompositeDataType().isEmpty()) {
            this.setErrorMessage(Messages.DataTypeDialog_ErrorMsgInner);
            return false;
        }
        EList declarations = this.compositeDataType.getInnerDeclaration_CompositeDataType();
        for (InnerDeclaration declaration : declarations) {
            state &= UpDownButtonsValidator.getSingelton().validdateDeclarationInnerDataType(declaration, this);
        }
        return state;
    }

    @Override
    public void createCollectionDataType() {
        new DataTypeCommand(this.editingDomain).createCollectionDataType(this.editedRepository, this.editedDataType, this.innerDataType, this.getEntityName());
    }

    @Override
    public void createCompositeDataType() {
        new DataTypeCommand(this.editingDomain).createCompositeDataType(this.editedRepository, this.compositeDataType, this.getEntityName());
    }

    public DataType getEditedDataType() {
        return this.editedDataType;
    }

    public CompositeDataType getCompositeDataType() {
        return this.compositeDataType;
    }

    public void setCompositeDataType(CompositeDataType compositeDataType) {
        this.compositeDataType = compositeDataType;
    }

    public CreateEditorContents getEditorContents() {
        return this.editorContents;
    }

    public void refresh() {
        this.editorContents.getViewer().refresh();
        this.validateInput();
    }
}

