/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.dsrg.fm.tbpjava.utils;

import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;

public class Type2String {
    private static final boolean DEBUG = false;
    public static final boolean USE_GENERIC_TYPE = true;

    public static String getGenericsTypeNames(Type[] types) {
        if (types == null || types.length == 0) {
            return "";
        }
        StringBuffer result = new StringBuffer();
        result.append('<');
        boolean first = true;
        for (Type type : types) {
            if (first) {
                first = false;
            } else {
                result.append(", ");
            }
            result.append(Type2String.getTypeName(type));
        }
        result.append('>');
        return result.toString();
    }

    public static String getTypeName(Type type) {
        if (type == null) {
            return "";
        }
        if (type instanceof GenericArrayType) {
            GenericArrayType gatType = (GenericArrayType)type;
            return Type2String.getTypeName(gatType.getGenericComponentType()) + "[]";
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType ptType = (ParameterizedType)type;
            StringBuffer result = new StringBuffer(Type2String.getTypeName(ptType.getRawType()));
            result.append('<');
            boolean first = true;
            for (Type typeArgument : ptType.getActualTypeArguments()) {
                if (first) {
                    first = false;
                } else {
                    result.append(", ");
                }
                result.append(Type2String.getTypeName(typeArgument));
            }
            result.append('>');
            return result.toString();
        }
        if (type instanceof TypeVariable) {
            TypeVariable tvType = (TypeVariable)type;
            return tvType.getName();
        }
        if (type instanceof WildcardType) {
            WildcardType wtType = (WildcardType)type;
            StringBuffer result = new StringBuffer();
            Type[] lb = wtType.getLowerBounds();
            Type[] ub = wtType.getUpperBounds();
            result.append("?");
            if (lb != null && lb.length > 0) {
                if (lb.length > 1) {
                    throw new RuntimeException("Internal error - not supported by Java language - more lower bounds (super) in one declaration");
                }
                result.append(" super ");
                result.append(Type2String.getTypeName(lb[0]));
            } else if (ub != null && ub.length > 0) {
                if (ub.length > 1) {
                    throw new RuntimeException("Internal error - not supported by Java language - more upper bounds (extends) in one declaration");
                }
                result.append(" extends ");
                result.append(Type2String.getTypeName(ub[0]));
            }
            return result.toString();
        }
        if (type instanceof Class) {
            Class cls = (Class)type;
            if (cls.equals(Boolean.TYPE)) {
                return Boolean.TYPE.getName();
            }
            if (cls.equals(Byte.TYPE)) {
                return Byte.TYPE.getName();
            }
            if (cls.equals(Short.TYPE)) {
                return Short.TYPE.getName();
            }
            if (cls.equals(Integer.TYPE)) {
                return Integer.TYPE.getName();
            }
            if (cls.equals(Long.TYPE)) {
                return Long.TYPE.getName();
            }
            if (cls.equals(Character.TYPE)) {
                return Character.TYPE.getName();
            }
            if (cls.equals(Float.TYPE)) {
                return Float.TYPE.getName();
            }
            if (cls.equals(Double.TYPE)) {
                return Double.TYPE.getName();
            }
            if (cls.isArray()) {
                return Type2String.getTypeName(cls.getComponentType()) + "[]";
            }
            return cls.getName();
        }
        throw new RuntimeException("Given type parameter is not instance of Class and doesn't implement any of these interfaces . This should not occur GenericArrayType, ParameterizedType, TypeVariable<D>, WildcardType. Type is instance of " + type.getClass().getName());
    }

    public static String getGenericTypeDefinition(Type[] types) {
        if (types == null || types.length == 0) {
            return "";
        }
        StringBuffer result = new StringBuffer();
        result.append('<');
        boolean first = true;
        for (Type type : types) {
            if (first) {
                first = false;
            } else {
                result.append(", ");
            }
            result.append(Type2String.getGenericTypeDefinitionOneEntry(type));
        }
        result.append('>');
        return result.toString();
    }

    public static String getGenericTypeDefinitionOneEntry(Type type) {
        if (type == null) {
            return "";
        }
        if (type instanceof TypeVariable) {
            TypeVariable tvType = (TypeVariable)type;
            StringBuffer result = new StringBuffer();
            result.append(tvType.getName());
            Type[] bounds = tvType.getBounds();
            if (bounds != null && (bounds.length > 1 || bounds.length == 1 && !bounds[0].equals(Object.class))) {
                boolean first = true;
                for (Type bound : bounds) {
                    if (first) {
                        first = false;
                        result.append(" extends ");
                    } else {
                        result.append(" & ");
                    }
                    result.append(Type2String.getTypeName(bound));
                }
            }
            return result.toString();
        }
        throw new RuntimeException("The provided type parameter is not an instance of Class and doesn't implement any of these interfaces. This should not occur GenericArrayType, ParameterizedType, TypeVariable<D>, WildcardType. Type is instance of " + type.getClass().getName());
    }

    public static String removeGenerics(String typeName) {
        if (typeName == null) {
            return "";
        }
        int startGenDec = typeName.indexOf(60);
        int endGenDec = typeName.lastIndexOf(62);
        if (startGenDec == -1 || endGenDec == -1 || endGenDec <= startGenDec) {
            return typeName;
        }
        String result = typeName.substring(0, startGenDec);
        if (endGenDec < typeName.length()) {
            result = result + typeName.substring(endGenDec + 1);
        }
        return result;
    }

    public static String getGenerics(String typeName) {
        if (typeName == null) {
            return "";
        }
        int startGenDec = typeName.indexOf(60);
        int endGenDec = typeName.lastIndexOf(62);
        if (startGenDec == -1 || endGenDec == -1 || endGenDec <= startGenDec) {
            return "";
        }
        return typeName.substring(startGenDec, endGenDec + 1);
    }
}

