/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.dsrg.fm.tbpjava.utils;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;

public class LineCouningOutputStream
extends OutputStream {
    private static final boolean DEBUG = false;
    private static final boolean DEBUG_OUTPUT = false;
    private OutputStream os;
    private int line = 0;
    private PrintStream ps;
    private boolean closing = false;

    public LineCouningOutputStream(String fileName) throws FileNotFoundException {
        this(new FileOutputStream(fileName));
    }

    public LineCouningOutputStream(OutputStream os) {
        this.os = os;
        this.ps = new PrintStream(this);
    }

    public int getLine() {
        return this.line;
    }

    public PrintStream getPrintStream() {
        return this.ps;
    }

    @Override
    public void write(int b) throws IOException {
        if (b == 10) {
            ++this.line;
        }
        this.os.write(b);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || off > b.length || len < 0 || off + len > b.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return;
        }
        for (int i = 0; i < len; ++i) {
            if (b[i] != 10) continue;
            ++this.line;
        }
        this.os.write(b, off, len);
    }

    @Override
    public void close() {
        if (!this.closing) {
            this.closing = true;
            this.ps.close();
            this.closing = false;
        } else {
            try {
                this.os.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void println(String s) {
        this.ps.println(s);
    }

    public void println() {
        this.ps.println();
    }

    public void print(String s) {
        this.ps.print(s);
    }
}

