/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.dsrg.fm.tbpjava.envgen;

import java.util.List;
import org.ow2.dsrg.fm.tbplib.parsed.MethodCall;
import org.ow2.dsrg.fm.tbplib.parsed.TBPLimitedReentrancy;
import org.ow2.dsrg.fm.tbplib.parsed.TBPParsedAccept;
import org.ow2.dsrg.fm.tbplib.parsed.TBPParsedAlternative;
import org.ow2.dsrg.fm.tbplib.parsed.TBPParsedNode;
import org.ow2.dsrg.fm.tbplib.parsed.TBPParsedParallel;
import org.ow2.dsrg.fm.tbplib.parsed.TBPParsedParallelOr;
import org.ow2.dsrg.fm.tbplib.parsed.TBPParsedProvisionContainerNode;
import org.ow2.dsrg.fm.tbplib.parsed.TBPParsedProvisionLeafNode;
import org.ow2.dsrg.fm.tbplib.parsed.TBPParsedProvisionNull;
import org.ow2.dsrg.fm.tbplib.parsed.TBPParsedProvisionUnaryNode;
import org.ow2.dsrg.fm.tbplib.parsed.TBPParsedRepetition;
import org.ow2.dsrg.fm.tbplib.parsed.TBPParsedSequence;
import org.ow2.dsrg.fm.tbplib.parsed.TBPUnlimitedReentrancy;
import org.ow2.dsrg.fm.tbplib.parsed.visitor.TBPParsedCheckingVisitor;
import org.ow2.dsrg.fm.tbplib.parsed.visitor.TBPParsedVisitor;

public class ProvisionToString
extends TBPParsedCheckingVisitor<StringBuffer> {
    public static final String INVALID_INPUT = "???";
    public static final String NULL = "null";
    private Style spaceStyle;
    private boolean printAnnotations;

    public ProvisionToString(Style spaceStyle, boolean printAnnotations) {
        this.spaceStyle = spaceStyle;
        if (!printAnnotations) {
            // empty if block
        }
        this.printAnnotations = true;
    }

    private void addSpace(StringBuffer buffer) {
        if (this.spaceStyle == Style.STYLE_SPACY) {
            buffer.append(' ');
        }
    }

    private StringBuffer processLeafNode(TBPParsedProvisionLeafNode node, String nodeName) {
        StringBuffer result = new StringBuffer();
        if (node == null) {
            result.append(INVALID_INPUT);
        } else {
            if (this.printAnnotations && node.getAnnotation() != null) {
                result.append(node.getAnnotation().toString());
                result.append(' ');
            }
            result.append(nodeName);
        }
        return result;
    }

    private StringBuffer processUnaryOperator(TBPParsedProvisionUnaryNode node, String operatorName) {
        StringBuffer result = new StringBuffer();
        if (node == null) {
            result = new StringBuffer();
            result.append(INVALID_INPUT);
            return result;
        }
        TBPParsedNode childNode = (TBPParsedNode)node.getChild();
        if (childNode == null) {
            result.append(INVALID_INPUT);
            this.addSpace(result);
        } else if (childNode instanceof TBPParsedProvisionLeafNode) {
            result.append((StringBuffer)childNode.visit((TBPParsedVisitor)this));
            this.addSpace(result);
        } else {
            result.append('(');
            this.addSpace(result);
            result.append((StringBuffer)childNode.visit((TBPParsedVisitor)this));
            this.addSpace(result);
            result.append(')');
        }
        if (this.printAnnotations && node.getAnnotation() != null) {
            result.append(node.getAnnotation().toString());
            result.append(' ');
        }
        result.append(operatorName);
        return result;
    }

    private StringBuffer processUnaryPrefixSuffix(TBPParsedProvisionUnaryNode node, String prefixString, String suffixString) {
        StringBuffer result = new StringBuffer();
        if (node == null) {
            result = new StringBuffer();
            result.append(INVALID_INPUT);
            return result;
        }
        result.append(prefixString);
        this.addSpace(result);
        TBPParsedNode childNode = (TBPParsedNode)node.getChild();
        if (childNode == null) {
            result.append(INVALID_INPUT);
        } else {
            result.append((StringBuffer)childNode.visit((TBPParsedVisitor)this));
        }
        this.addSpace(result);
        result.append(suffixString);
        return result;
    }

    private StringBuffer processNAryOperator(TBPParsedNode node, String operatorName) {
        StringBuffer result = new StringBuffer();
        if (node == null) {
            result = new StringBuffer();
            result.append(INVALID_INPUT);
            return result;
        }
        if (this.printAnnotations && node.getAnnotation() != null) {
            result.append(node.getAnnotation().toString());
            this.addSpace(result);
            result.append('(');
        }
        int childCount = node.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            TBPParsedNode childNode = (TBPParsedNode)node.getChild(i);
            if (childNode == null) {
                result.append(INVALID_INPUT);
            } else if (childNode instanceof TBPParsedProvisionLeafNode || childNode.getClass().equals(node.getClass())) {
                result.append((StringBuffer)childNode.visit((TBPParsedVisitor)this));
            } else {
                result.append('(');
                this.addSpace(result);
                result.append((StringBuffer)childNode.visit((TBPParsedVisitor)this));
                this.addSpace(result);
                result.append(')');
            }
            if (i >= childCount - 1) continue;
            this.addSpace(result);
            result.append(operatorName);
            this.addSpace(result);
        }
        if (this.printAnnotations && node.getAnnotation() != null) {
            result.append(')');
        }
        return result;
    }

    public static String methodCall2String(MethodCall mc) {
        if (mc == null) {
            return "";
        }
        StringBuffer result = new StringBuffer(20);
        result.append('?');
        result.append(mc.getFullname());
        result.append('(');
        List params = mc.getParamDecl();
        if (params != null && !params.isEmpty()) {
            boolean first = true;
            for (String param : params) {
                if (first) {
                    first = false;
                } else {
                    result.append(", ");
                }
                result.append(param);
            }
        }
        result.append(')');
        String retVal = mc.getReturnValue();
        if (retVal != null && !retVal.isEmpty()) {
            result.append(':');
            result.append(retVal);
        }
        return result.toString();
    }

    public StringBuffer visitLimitedReentrancy(TBPLimitedReentrancy node) {
        int limit = 0;
        if (node != null) {
            limit = node.getLimit();
        }
        return this.processUnaryOperator((TBPParsedProvisionUnaryNode)node, "|" + Integer.toString(limit));
    }

    public StringBuffer visitParsedAlternative(TBPParsedAlternative node) {
        return this.processNAryOperator((TBPParsedNode)node, "+");
    }

    public StringBuffer visitParsedNull(TBPParsedProvisionNull node) {
        return this.processLeafNode((TBPParsedProvisionLeafNode)node, NULL);
    }

    public StringBuffer visitParsedParallel(TBPParsedParallel node) {
        return this.processNAryOperator((TBPParsedNode)node, "|");
    }

    public StringBuffer visitParsedParallelOr(TBPParsedParallelOr node) {
        return this.processNAryOperator((TBPParsedNode)node, "||");
    }

    public StringBuffer visitParsedProvisionContainerNode(TBPParsedProvisionContainerNode node) {
        String provisionName = "";
        if (node != null) {
            provisionName = node.getName();
        }
        String annotation = "";
        if (this.printAnnotations && node.getAnnotation() != null) {
            annotation = " " + node.getAnnotation().toString();
        }
        return this.processUnaryPrefixSuffix((TBPParsedProvisionUnaryNode)node, "provision " + provisionName + annotation + " {", "}");
    }

    public StringBuffer visitParsedAccept(TBPParsedAccept node) {
        String callingCode = INVALID_INPUT;
        if (node != null) {
            callingCode = ProvisionToString.methodCall2String(node.getMethodCall());
        }
        return this.processLeafNode((TBPParsedProvisionLeafNode)node, callingCode);
    }

    public StringBuffer visitParsedRepetition(TBPParsedRepetition node) {
        return this.processUnaryOperator((TBPParsedProvisionUnaryNode)node, "*");
    }

    public StringBuffer visitParsedSequence(TBPParsedSequence node) {
        return this.processNAryOperator((TBPParsedNode)node, ";");
    }

    public StringBuffer visitUnlimitedReentrancy(TBPUnlimitedReentrancy node) {
        return this.processUnaryOperator((TBPParsedProvisionUnaryNode)node, "|*");
    }

    public static enum Style {
        STYLE_SPACY,
        STYLE_COMPACT;

    }
}

