/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.dsrg.fm.tbpjava.envgen;

import java.io.PrintStream;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import org.ow2.dsrg.fm.tbpjava.EnvGenerator;
import org.ow2.dsrg.fm.tbpjava.envgen.Indenter;
import org.ow2.dsrg.fm.tbpjava.envgen.ProvisionToString;
import org.ow2.dsrg.fm.tbpjava.envgen.StubGenerator;
import org.ow2.dsrg.fm.tbpjava.utils.Configuration;
import org.ow2.dsrg.fm.tbpjava.utils.LineCouningOutputStream;
import org.ow2.dsrg.fm.tbpjava.utils.Type2String;
import org.ow2.dsrg.fm.tbplib.parsed.TBPLimitedReentrancy;
import org.ow2.dsrg.fm.tbplib.parsed.TBPParsedAccept;
import org.ow2.dsrg.fm.tbplib.parsed.TBPParsedAlternative;
import org.ow2.dsrg.fm.tbplib.parsed.TBPParsedNode;
import org.ow2.dsrg.fm.tbplib.parsed.TBPParsedParallel;
import org.ow2.dsrg.fm.tbplib.parsed.TBPParsedParallelOr;
import org.ow2.dsrg.fm.tbplib.parsed.TBPParsedProvisionContainerNode;
import org.ow2.dsrg.fm.tbplib.parsed.TBPParsedProvisionNull;
import org.ow2.dsrg.fm.tbplib.parsed.TBPParsedRepetition;
import org.ow2.dsrg.fm.tbplib.parsed.TBPParsedSequence;
import org.ow2.dsrg.fm.tbplib.parsed.TBPUnlimitedReentrancy;
import org.ow2.dsrg.fm.tbplib.parsed.visitor.TBPParsedCheckingVisitor;
import org.ow2.dsrg.fm.tbplib.parsed.visitor.TBPParsedVisitor;

public class CodeGenerator
extends TBPParsedCheckingVisitor<Object> {
    private static final boolean DEBUG = false;
    private static final boolean EXCEPTIONS_ACCEPT_TRY_CATCH_BLOCKS = false;
    private static final boolean REPETITION_AS_WHILE = false;
    private boolean errorFound = false;
    private Indenter indenter;
    private LineCouningOutputStream outFile;
    private PrintStream infoStream = System.out;
    private Configuration config = null;
    private boolean printAnnotations = true;
    private ProvisionToString prov2String = null;
    private EnvGenerator.EnvironmentDescription envDesc = null;
    private int cntThread = 0;
    private int cntOrParallel = 0;
    private int cntAlternative = 0;
    private int cntRepetition = 0;
    public static final String AlternativeVariableName = "alternativeChoice";
    public static final String ParallelOrVariableName = "parallel";
    public static final String RepetitionVariableName = "repetition";
    public static final String EnvValueSetsPropertyName = "envValues";
    public static final int REPETITION_LIMIT = 3;

    public CodeGenerator(PrintStream infoStream, LineCouningOutputStream outFile, Indenter indenter, EnvGenerator.EnvironmentDescription envDesc, Configuration config) {
        this.infoStream = infoStream;
        this.outFile = outFile;
        this.indenter = indenter;
        this.envDesc = envDesc;
        this.config = config;
        this.prov2String = new ProvisionToString(ProvisionToString.Style.STYLE_COMPACT, this.printAnnotations);
    }

    public static String patchName(String src) {
        src = src.replaceAll("<", "_");
        src = src.replaceAll(">", "_");
        src = src.replaceAll(" ", "_");
        src = src.replaceAll("\\.", "_");
        return src;
    }

    public void generateCode(TBPParsedProvisionContainerNode node) {
        if (node == null) {
            return;
        }
        Indenter.IndentLevel originalLevel = this.indenter.getIndentLevel();
        ((TBPParsedNode)node.getChild()).visit((TBPParsedVisitor)this);
        this.indenter.restoreIndentLevel(originalLevel);
    }

    public boolean wasError() {
        return this.errorFound;
    }

    private void printAnnotation(TBPParsedNode node) {
        if (!this.printAnnotations) {
            return;
        }
        if (node.getAnnotation() == null) {
            return;
        }
        String annotations = node.getAnnotation().toString();
        if (annotations.trim().isEmpty()) {
            return;
        }
        this.indenter.indent();
        this.outFile.println("// " + annotations);
    }

    private int threadProcessNodeInNewThread(TBPParsedNode node) {
        int myThreadNum = ++this.cntThread;
        Indenter.IndentLevel originalLevel = this.indenter.getIndentLevel();
        this.indenter.indent();
        this.outFile.println("Thread t" + Integer.toString(myThreadNum) + " = new Thread() {");
        this.indenter.addLevel();
        this.indenter.indent();
        this.outFile.println("public void run() {");
        this.indenter.indent();
        this.outFile.println("try {");
        this.indenter.addLevel();
        node.visit((TBPParsedVisitor)this);
        this.indenter.removeLevel();
        this.indenter.indent();
        this.outFile.println("} catch (Throwable e) {");
        this.indenter.addLevel();
        this.indenter.indent();
        this.outFile.println("throw new RuntimeException(e);");
        this.indenter.removeLevel();
        this.indenter.indent();
        this.outFile.println("}");
        this.indenter.removeLevel();
        this.indenter.indent();
        this.outFile.println("} // end of run method");
        this.indenter.restoreIndentLevel(originalLevel);
        this.indenter.indent();
        this.outFile.println("}; // end of class for thread t" + Integer.toString(myThreadNum));
        return myThreadNum;
    }

    private int threadCopyThread(int originalThreadNum) {
        int myThreadNum = ++this.cntThread;
        this.indenter.indent();
        this.outFile.println("Thread t" + myThreadNum + " = t" + originalThreadNum + ".getClass().getConstructor(this.getClass()).newInstance(this);");
        return myThreadNum;
    }

    private void threadNodeJoinBlock(int threadNum) {
        this.indenter.indent();
        this.outFile.println("t" + Integer.toString(threadNum) + ".join();");
    }

    public Object visitParsedAlternative(TBPParsedAlternative node) {
        Indenter.IndentLevel originalLevel = this.indenter.getIndentLevel();
        this.indenter.addLevel();
        int myAlternative = ++this.cntAlternative;
        this.indenter.indent();
        this.outFile.println("// visitParsedAlternative");
        this.indenter.indent();
        this.outFile.println("// " + node.visit((TBPParsedVisitor)this.prov2String));
        this.printAnnotation((TBPParsedNode)node);
        int depth = this.visitParsedAlternativeDepthCount(node);
        this.indenter.indent();
        this.outFile.println("int alternativeChoice" + Integer.toString(myAlternative) + " = Verify.random(" + Integer.toString(depth) + ");");
        this.indenter.indent();
        this.outFile.println();
        this.visitParsedAlternativeGenerateIfBlock(node, myAlternative, 0);
        this.outFile.println();
        this.indenter.restoreIndentLevel(originalLevel);
        return null;
    }

    private int visitParsedAlternativeGenerateIfBlock(TBPParsedAlternative node, int myAlternative, int processed) {
        if (node.getLeft() instanceof TBPParsedAlternative) {
            processed = this.visitParsedAlternativeGenerateIfBlock((TBPParsedAlternative)node.getLeft(), myAlternative, processed);
        } else {
            this.visitParsedAlternativeGenerateIfBlockCode((TBPParsedNode)node.getLeft(), myAlternative, processed);
            ++processed;
        }
        if (node.getRight() instanceof TBPParsedAlternative) {
            processed = this.visitParsedAlternativeGenerateIfBlock((TBPParsedAlternative)node.getRight(), myAlternative, processed);
        } else {
            this.visitParsedAlternativeGenerateIfBlockCode((TBPParsedNode)node.getRight(), myAlternative, processed);
            ++processed;
        }
        return processed;
    }

    private void visitParsedAlternativeGenerateIfBlockCode(TBPParsedNode node, int myAlternative, int processed) {
        if (processed == 0) {
            this.indenter.indent();
        } else {
            this.outFile.print(" else ");
        }
        this.outFile.println("if ( alternativeChoice" + Integer.toString(myAlternative) + " == " + Integer.toString(processed) + " ) {");
        node.visit((TBPParsedVisitor)this);
        this.indenter.indent();
        this.outFile.print("}");
    }

    private int visitParsedAlternativeDepthCount(TBPParsedAlternative node) {
        int count = 0;
        count = node.getLeft() instanceof TBPParsedAlternative ? (count += this.visitParsedAlternativeDepthCount((TBPParsedAlternative)node.getLeft())) : ++count;
        count = node.getRight() instanceof TBPParsedAlternative ? (count += this.visitParsedAlternativeDepthCount((TBPParsedAlternative)node.getRight())) : ++count;
        return count;
    }

    public Object visitParsedParallel(TBPParsedParallel node) {
        Indenter.IndentLevel originalLevel = this.indenter.getIndentLevel();
        this.indenter.addLevel();
        this.indenter.indent();
        this.outFile.println("// visitParsedParallel");
        this.indenter.indent();
        this.outFile.println("// " + node.visit((TBPParsedVisitor)this.prov2String));
        this.printAnnotation((TBPParsedNode)node);
        List<Integer> threads = this.visitParsedParallelGenerateThreads(node);
        this.visitParsedParallelGenerateStartBlock(threads);
        this.visitParsedParallelGenerateJoinBlock(threads);
        this.indenter.restoreIndentLevel(originalLevel);
        return null;
    }

    private List<Integer> visitParsedParallelGenerateThreads(TBPParsedParallel node) {
        List<Integer> childThreads;
        ArrayList<Integer> retVal = new ArrayList<Integer>();
        if (node.getLeft() instanceof TBPParsedParallel) {
            TBPParsedParallel left = (TBPParsedParallel)node.getLeft();
            childThreads = this.visitParsedParallelGenerateThreads(left);
            retVal.addAll(childThreads);
        } else {
            int threadNum = this.threadProcessNodeInNewThread((TBPParsedNode)node.getLeft());
            retVal.add(threadNum);
        }
        if (node.getRight() instanceof TBPParsedParallel) {
            TBPParsedParallel right = (TBPParsedParallel)node.getRight();
            childThreads = this.visitParsedParallelGenerateThreads(right);
            retVal.addAll(childThreads);
        } else {
            int threadNum = this.threadProcessNodeInNewThread((TBPParsedNode)node.getRight());
            retVal.add(threadNum);
        }
        return retVal;
    }

    private void visitParsedParallelGenerateStartBlock(List<Integer> threadNums) {
        for (int threadNum : threadNums) {
            this.indenter.indent();
            this.outFile.println("t" + Integer.toString(threadNum) + ".start();");
        }
    }

    private void visitParsedParallelGenerateJoinBlock(List<Integer> threadNums) {
        for (int threadNum : threadNums) {
            this.threadNodeJoinBlock(threadNum);
        }
    }

    public Object visitParsedParallelOr(TBPParsedParallelOr node) {
        Indenter.IndentLevel originalLevel = this.indenter.getIndentLevel();
        this.indenter.addLevel();
        int myOrParallel = ++this.cntOrParallel;
        this.indenter.indent();
        this.outFile.println("// visitParsedParallelOr");
        this.indenter.indent();
        this.outFile.println("// " + node.visit((TBPParsedVisitor)this.prov2String));
        this.printAnnotation((TBPParsedNode)node);
        int depth = this.visitParsedParallelOrDepthCount(node);
        this.indenter.indent();
        this.outFile.println("int parallel" + Integer.toString(myOrParallel) + " = Verify.random(" + Integer.toString(depth) + ");");
        List<Integer> threads = this.visitParsedParallelOrGenerateThreads(node);
        this.visitParsedParallelOrGenerateStartBlock(threads, myOrParallel);
        this.visitParsedParallelOrGenerateJoinBlock(threads);
        this.indenter.restoreIndentLevel(originalLevel);
        return null;
    }

    private int visitParsedParallelOrDepthCount(TBPParsedParallelOr node) {
        int retVal = 0;
        if (node.getLeft() instanceof TBPParsedParallelOr) {
            retVal += this.visitParsedParallelOrDepthCount((TBPParsedParallelOr)node.getLeft());
        } else if (node.getLeft() instanceof TBPLimitedReentrancy) {
            TBPLimitedReentrancy left = (TBPLimitedReentrancy)node.getLeft();
            retVal += this.visitLimitedReentrancyDepthCount(left);
        } else {
            ++retVal;
        }
        if (node.getRight() instanceof TBPParsedParallelOr) {
            retVal += this.visitParsedParallelOrDepthCount((TBPParsedParallelOr)node.getRight());
        } else if (node.getRight() instanceof TBPLimitedReentrancy) {
            TBPLimitedReentrancy right = (TBPLimitedReentrancy)node.getRight();
            retVal += this.visitLimitedReentrancyDepthCount(right);
        } else {
            ++retVal;
        }
        return retVal;
    }

    private List<Integer> visitParsedParallelOrGenerateThreads(TBPParsedParallelOr node) {
        List<Integer> createdThreads;
        ArrayList<Integer> retVal = new ArrayList<Integer>();
        if (node.getLeft() instanceof TBPParsedParallelOr) {
            TBPParsedParallelOr left = (TBPParsedParallelOr)node.getLeft();
            createdThreads = this.visitParsedParallelOrGenerateThreads(left);
            retVal.addAll(createdThreads);
        } else if (node.getLeft() instanceof TBPLimitedReentrancy) {
            TBPLimitedReentrancy left = (TBPLimitedReentrancy)node.getLeft();
            createdThreads = this.visitLimitedReentrancyGenerateThreads(left);
            retVal.addAll(createdThreads);
        } else {
            int newThreadNum = this.threadProcessNodeInNewThread((TBPParsedNode)node.getLeft());
            retVal.add(new Integer(newThreadNum));
        }
        if (node.getRight() instanceof TBPParsedParallelOr) {
            TBPParsedParallelOr right = (TBPParsedParallelOr)node.getRight();
            createdThreads = this.visitParsedParallelOrGenerateThreads(right);
            retVal.addAll(createdThreads);
        } else if (node.getRight() instanceof TBPLimitedReentrancy) {
            TBPLimitedReentrancy right = (TBPLimitedReentrancy)node.getRight();
            createdThreads = this.visitLimitedReentrancyGenerateThreads(right);
            retVal.addAll(createdThreads);
        } else {
            int newThreadNum = this.threadProcessNodeInNewThread((TBPParsedNode)node.getRight());
            retVal.add(new Integer(newThreadNum));
        }
        return retVal;
    }

    private void visitParsedParallelOrGenerateStartBlock(List<Integer> threadVariables, int variableOrNum) {
        int processed = 0;
        for (int threadNum : threadVariables) {
            this.indenter.indent();
            this.outFile.println("if ( (parallel" + Integer.toString(variableOrNum) + " == " + Integer.toString(processed) + ") || (Verify.getBoolean()) ) {");
            this.indenter.addLevel();
            this.indenter.indent();
            this.outFile.println("t" + Integer.toString(threadNum) + ".start();");
            this.indenter.removeLevel();
            this.indenter.indent();
            this.outFile.println("}");
            ++processed;
        }
    }

    private void visitParsedParallelOrGenerateJoinBlock(List<Integer> threadVariables) {
        for (int threadNum : threadVariables) {
            this.threadNodeJoinBlock(threadNum);
        }
    }

    public Object visitParsedSequence(TBPParsedSequence node) {
        Indenter.IndentLevel originalLevel = this.indenter.getIndentLevel();
        if (!(node.getParent() instanceof TBPParsedSequence)) {
            this.indenter.addLevel();
            this.indenter.indent();
            this.outFile.println("// visitParsedSequence");
            this.indenter.indent();
            this.outFile.println("// " + node.visit((TBPParsedVisitor)this.prov2String));
        }
        this.printAnnotation((TBPParsedNode)node);
        ((TBPParsedNode)node.getLeft()).visit((TBPParsedVisitor)this);
        ((TBPParsedNode)node.getRight()).visit((TBPParsedVisitor)this);
        this.indenter.restoreIndentLevel(originalLevel);
        return null;
    }

    public Object visitParsedRepetition(TBPParsedRepetition node) {
        Indenter.IndentLevel originalLevel = this.indenter.getIndentLevel();
        this.indenter.addLevel();
        this.indenter.indent();
        this.outFile.println("// visitParsedRepetition");
        this.indenter.indent();
        this.outFile.println("// " + node.visit((TBPParsedVisitor)this.prov2String));
        this.printAnnotation((TBPParsedNode)node);
        String varName = RepetitionVariableName + Integer.toString(this.cntRepetition++);
        this.indenter.indent();
        this.outFile.println("for(byte " + varName + " = 0; " + varName + " < " + 3 + "; " + varName + "++) {");
        this.indenter.addLevel();
        this.indenter.indent();
        this.outFile.println("if (Verify.getBoolean()) { break; }");
        this.indenter.removeLevel();
        ((TBPParsedNode)node.getChild()).visit((TBPParsedVisitor)this);
        this.indenter.indent();
        this.outFile.println("}");
        this.indenter.restoreIndentLevel(originalLevel);
        return null;
    }

    public Object visitLimitedReentrancy(TBPLimitedReentrancy node) {
        Indenter.IndentLevel originalLevel = this.indenter.getIndentLevel();
        this.indenter.addLevel();
        int myOrParallel = ++this.cntOrParallel;
        this.indenter.indent();
        this.outFile.println("// visitLimitedReentrancy " + node.getLimit());
        this.indenter.indent();
        this.outFile.println("// " + node.visit((TBPParsedVisitor)this.prov2String));
        this.printAnnotation((TBPParsedNode)node);
        int depth = this.visitLimitedReentrancyDepthCount(node);
        this.indenter.indent();
        this.outFile.println("int parallel" + Integer.toString(myOrParallel) + " = Verify.random(" + Integer.toString(depth) + ");");
        List<Integer> threads = this.visitLimitedReentrancyGenerateThreads(node);
        this.visitParsedParallelOrGenerateStartBlock(threads, myOrParallel);
        this.visitParsedParallelOrGenerateJoinBlock(threads);
        this.indenter.restoreIndentLevel(originalLevel);
        return null;
    }

    private int visitLimitedReentrancyDepthCount(TBPLimitedReentrancy node) {
        if (node.getChild() instanceof TBPParsedParallelOr) {
            return node.getLimit() * this.visitParsedParallelOrDepthCount((TBPParsedParallelOr)node.getChild());
        }
        if (node.getChild() instanceof TBPLimitedReentrancy) {
            TBPLimitedReentrancy left = (TBPLimitedReentrancy)node.getChild();
            return node.getLimit() * this.visitLimitedReentrancyDepthCount(left);
        }
        return node.getLimit();
    }

    private List<Integer> visitLimitedReentrancyGenerateThreads(TBPLimitedReentrancy node) {
        int limit = node.getLimit();
        ArrayList<Integer> retVal = new ArrayList<Integer>();
        for (int i = 0; i < limit; ++i) {
            TBPParsedParallelOr child;
            if (node.getChild() instanceof TBPParsedParallelOr) {
                child = (TBPParsedParallelOr)node.getChild();
                retVal.addAll(this.visitParsedParallelOrGenerateThreads(child));
                continue;
            }
            if (node.getChild() instanceof TBPLimitedReentrancy) {
                child = (TBPLimitedReentrancy)node.getChild();
                retVal.addAll(this.visitLimitedReentrancyGenerateThreads((TBPLimitedReentrancy)child));
                continue;
            }
            child = (TBPParsedNode)node.getChild();
            retVal.add(this.threadProcessNodeInNewThread((TBPParsedNode)child));
        }
        return retVal;
    }

    public Object visitUnlimitedReentrancy(TBPUnlimitedReentrancy node) {
        this.errorFound = true;
        this.infoStream.println("Internal error - unlimited reentrancy wasn't changes into limited reantrancy node");
        Indenter.IndentLevel originalLevel = this.indenter.getIndentLevel();
        this.indenter.addLevel();
        this.printAnnotation((TBPParsedNode)node);
        this.indenter.indent();
        this.outFile.println("throw new RuntimeException(\"Unprocessed unlimited reentrancy mode. Internal environment generator error.\");");
        this.indenter.restoreIndentLevel(originalLevel);
        return null;
    }

    public Object visitParsedNull(TBPParsedProvisionNull node) {
        this.indenter.addLevel();
        this.printAnnotation((TBPParsedNode)node);
        this.indenter.indent();
        this.outFile.println("// NULL");
        this.indenter.removeLevel();
        return null;
    }

    public Object visitParsedAccept(TBPParsedAccept node) {
        Indenter.IndentLevel originalLevel = this.indenter.getIndentLevel();
        this.indenter.addLevel();
        this.indenter.indent();
        this.outFile.println("// visitParsedAccept " + node.getFullname());
        this.printAnnotation((TBPParsedNode)node);
        if (!this.config.getComponentProvidedInterfaces().containsKey(node.getInterface())) {
            this.infoStream.println("Error - unknown provided interface name " + node.getInterface() + ". Cannot generate correct calling code.");
            this.indenter.indent();
            this.outFile.println("throw new RuntimeException(\"Call on provided interface cannot be generated\");");
            this.indenter.restoreIndentLevel(originalLevel);
            this.errorFound = true;
            return null;
        }
        String interfaceClassName = this.config.getComponentProvidedInterfaces().get(node.getInterface());
        if (interfaceClassName == null) {
            this.infoStream.println("Error - unknown name for interface name " + node.getInterface() + ". Cannot generate correct calling code.");
            this.indenter.indent();
            this.outFile.println("throw new RuntimeException(\"Call on provided interface cannot be generated\");");
            this.indenter.restoreIndentLevel(originalLevel);
            this.errorFound = true;
            return null;
        }
        Class<?> interfaceClass = null;
        try {
            interfaceClass = Thread.currentThread().getContextClassLoader().loadClass(Type2String.removeGenerics(interfaceClassName));
        }
        catch (ClassNotFoundException e) {
            this.infoStream.println("Error - cannot load Class (" + Type2String.removeGenerics(interfaceClassName) + ") where " + node.getInterface() + " interface is defined.");
            this.indenter.indent();
            this.outFile.println("throw new RuntimeException(\"Call on provided interface cannot be generated\");");
            this.indenter.restoreIndentLevel(originalLevel);
            this.errorFound = true;
            return null;
        }
        String interfacePropertyName = this.envDesc.provItfs2envFieldName.get(node.getInterface());
        if (interfacePropertyName == null) {
            this.infoStream.println("Internal Error - no property name for provided interface " + node.getInterface() + ".");
            this.indenter.indent();
            this.outFile.println("throw new RuntimeException(\"Call on provided interface cannot be generated\");");
            this.indenter.restoreIndentLevel(originalLevel);
            this.errorFound = true;
            return null;
        }
        Method calledMethod = null;
        for (Method m : interfaceClass.getMethods()) {
            if (!m.getName().equals(node.getMethod())) continue;
            calledMethod = m;
            break;
        }
        if (calledMethod == null) {
            this.infoStream.println("Error - provided interface " + node.getInterface() + " (" + interfaceClassName + ") doesn't contain method with name " + node.getMethod() + ".");
            this.indenter.indent();
            this.outFile.println("throw new RuntimeException(\"Call on provided interface cannot be generated\");");
            this.indenter.restoreIndentLevel(originalLevel);
            this.errorFound = true;
            return null;
        }
        this.visitParsedAcceptExceptionsTryBlock(calledMethod);
        this.indenter.indent();
        this.outFile.println(interfacePropertyName + "." + node.getMethod() + "(");
        int line = this.outFile.getLine();
        this.indenter.addLevel();
        this.indenter.addLevel();
        Type[] params = calledMethod.getGenericParameterTypes();
        for (int i = 0; i < params.length; ++i) {
            this.indenter.indent();
            this.outFile.print(StubGenerator.genCodeObtainingValue(params[i], this.config.getComponentName(), interfaceClassName, node.getMethod()));
            if (i < params.length - 1) {
                this.outFile.println(", ");
                continue;
            }
            this.outFile.println();
        }
        this.indenter.removeLevel();
        this.indenter.indent();
        this.outFile.println(");");
        this.indenter.removeLevel();
        this.visitParsedAcceptExceptionsCatchBlock(calledMethod);
        this.indenter.restoreIndentLevel(originalLevel);
        this.envDesc.line2ProvidedCall.put(line, node);
        return null;
    }

    private void visitParsedAcceptExceptionsTryBlock(Method calledMethod) {
    }

    private void visitParsedAcceptExceptionsCatchBlock(Method calledMethod) {
    }

    public static boolean isRepetitionOperAsWhile() {
        return false;
    }

    public static String getStaticConfiguration() {
        return "Repetetion operator is generated as for cycle with up to 3 iterations";
    }
}

