/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.dsrg.fm.tbpjava.checker;

import org.ow2.dsrg.fm.tbpjava.checker.AutomatonState;

public final class ThreadStateStack {
    private final AutomatonState as;
    private final ThreadStateStack previous;
    private final String returnValue;
    private final ReturnValues returnValueType;
    private final String lastCallReturnValue;
    private final ReturnValues lastCallReturnValueType;
    private final int hashCode;
    private final int HASH_CONSTANT = 83;

    public ThreadStateStack(AutomatonState as, ThreadStateStack previous) {
        assert (as != null);
        assert (as.getEdge() == null);
        this.as = as;
        this.previous = previous != null && as.getThreadNum() == previous.as.getThreadNum() ? previous : null;
        this.returnValue = null;
        this.returnValueType = ReturnValues.RET_VAL_NOT_SET;
        this.lastCallReturnValue = null;
        this.lastCallReturnValueType = ReturnValues.RET_VAL_NOT_SET;
        this.hashCode = this.calculateHashCode();
    }

    public ThreadStateStack(ThreadStateStack source, String retVal) {
        assert (source != null);
        assert (retVal != null);
        this.as = source.as;
        this.previous = source.previous;
        this.lastCallReturnValue = source.lastCallReturnValue;
        this.lastCallReturnValueType = source.lastCallReturnValueType;
        this.returnValue = retVal;
        this.returnValueType = ReturnValues.RET_VAL_SET;
        this.hashCode = this.calculateHashCode();
    }

    public ThreadStateStack(ThreadStateStack source, AutomatonState as, int i) {
        assert (source != null);
        assert (as != null);
        this.as = as;
        this.previous = source.previous;
        this.lastCallReturnValue = source.lastCallReturnValue;
        this.lastCallReturnValueType = source.lastCallReturnValueType;
        this.returnValue = source.returnValue;
        this.returnValueType = source.returnValueType;
        this.hashCode = this.calculateHashCode();
    }

    protected ThreadStateStack(ThreadStateStack source, ReturnValues newLastCallReturnValueType, String newLastCallReturnValue) {
        assert (source != null);
        this.as = source.as;
        this.previous = source.previous;
        this.returnValue = source.returnValue;
        this.returnValueType = source.returnValueType;
        assert (newLastCallReturnValueType == ReturnValues.RET_VAL_NOT_SET && newLastCallReturnValue == null || newLastCallReturnValueType == ReturnValues.RET_VAL_SET && newLastCallReturnValue != null || newLastCallReturnValueType == ReturnValues.RET_VAL_UNDEFINED_EMIT && newLastCallReturnValue == null);
        this.lastCallReturnValue = newLastCallReturnValue;
        this.lastCallReturnValueType = newLastCallReturnValueType;
        this.hashCode = this.calculateHashCode();
    }

    public ThreadStateStack processReturnEvent(ThreadStateStack returningTss) {
        assert (returningTss != null);
        return new ThreadStateStack(this, returningTss.getReturnValueType(), returningTss.getReturnValue());
    }

    public ThreadStateStack changeAutomatonState(AutomatonState as) {
        assert (as != null);
        return new ThreadStateStack(this, as, 1);
    }

    public ThreadStateStack changeLastCallRetValTypeUndefEmit() {
        assert (this.as != null);
        return new ThreadStateStack(this, ReturnValues.RET_VAL_UNDEFINED_EMIT, null);
    }

    public final AutomatonState getAutomatonState() {
        return this.as;
    }

    public final ThreadStateStack getPrevious() {
        return this.previous;
    }

    public final String getReturnValue() {
        return this.returnValue;
    }

    public final ReturnValues getReturnValueType() {
        return this.returnValueType;
    }

    public final String getLastCallReturnValue() {
        return this.lastCallReturnValue;
    }

    public final ReturnValues getLastCallReturnValueType() {
        return this.lastCallReturnValueType;
    }

    public final int hashCode() {
        return this.hashCode;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("as=");
        sb.append(this.as.toString());
        sb.append(", hash=");
        sb.append(this.hashCode());
        sb.append(", prevHash=");
        sb.append(this.previous == null ? "null" : Integer.valueOf(this.previous.hashCode()));
        sb.append(", retVal=");
        sb.append(this.returnValue);
        sb.append(", retValType=");
        sb.append((Object)this.returnValueType);
        sb.append(", lastCallretVal=");
        sb.append(this.lastCallReturnValue);
        sb.append(", lastCallRetValType=");
        sb.append((Object)this.lastCallReturnValueType);
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ThreadStateStack other = (ThreadStateStack)obj;
        if (other.hashCode() != this.hashCode()) {
            return false;
        }
        if (this.as == null ? other.as != null : !this.as.equals(other.as)) {
            return false;
        }
        if (this.lastCallReturnValue == null ? other.lastCallReturnValue != null : !this.lastCallReturnValue.equals(other.lastCallReturnValue)) {
            return false;
        }
        if (this.lastCallReturnValueType == null ? other.lastCallReturnValueType != null : !this.lastCallReturnValueType.equals((Object)other.lastCallReturnValueType)) {
            return false;
        }
        if (this.returnValue == null ? other.returnValue != null : !this.returnValue.equals(other.returnValue)) {
            return false;
        }
        if (this.returnValueType == null ? other.returnValueType != null : !this.returnValueType.equals((Object)other.returnValueType)) {
            return false;
        }
        return !(this.previous == null ? other.previous != null : !this.previous.equals(other.previous));
    }

    private final int calculateHashCode() {
        int result = 0;
        result = result * 83 + this.as.hashCode();
        result = result * 83 + (this.previous != null ? this.previous.hashCode() : 0);
        result = result * 83 + (this.returnValue != null ? this.returnValue.hashCode() : 0);
        result = result * 83 + this.returnValueType.hashCode();
        result = result * 83 + (this.lastCallReturnValue != null ? this.lastCallReturnValue.hashCode() : 0);
        result = result * 83 + this.lastCallReturnValueType.hashCode();
        return result;
    }

    public static enum ReturnValues {
        RET_VAL_SET,
        RET_VAL_NOT_SET,
        RET_VAL_UNDEFINED_EMIT;

    }
}

