/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.dsrg.fm.tbpjava.checker;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.ow2.dsrg.fm.tbpjava.EnvGenerator;
import org.ow2.dsrg.fm.tbpjava.checker.AutomatonState;
import org.ow2.dsrg.fm.tbpjava.checker.AutomatonsMoves;
import org.ow2.dsrg.fm.tbpjava.checker.EventItem;
import org.ow2.dsrg.fm.tbpjava.checker.StatesMapper;
import org.ow2.dsrg.fm.tbpjava.checker.VariablesEvaluation;
import org.ow2.dsrg.fm.tbplib.ltsa.LTSAAutomaton;
import org.ow2.dsrg.fm.tbplib.ltsa.LTSAComponentSpecification;
import org.ow2.dsrg.fm.tbplib.parsed.TBPParsedAccept;
import org.ow2.dsrg.fm.tbplib.resolved.Reference;
import org.ow2.dsrg.fm.tbplib.resolved.util.Binding;

public class ThreadAutomatons {
    private static final boolean DEBUG = false;
    private final LTSAComponentSpecification specification;
    private final StatesMapper varStatesMap;
    private final AutomatonsMoves mover;
    private final ThreadType threadType;
    private final int threadNum;
    private final Stack<EventItem> eventStack = new Stack();
    private int reqItfsCallDepth = 0;
    private int provItfsCallDepth = 0;
    private final ThreadAutomatons prev;
    private final AutomatonsType type;
    private int eventParserRoundNum;
    private final EnvGenerator.EnvironmentDescription envDesc;
    private Set<AutomatonState> automStates = new HashSet<AutomatonState>();
    private boolean errorFlag = false;
    private String errorString = null;

    public ThreadAutomatons(LTSAComponentSpecification specification, StatesMapper varStatesMap, ThreadType threadType, int eventParserRoundNum, int threadNum, EnvGenerator.EnvironmentDescription envDesc) {
        this.specification = specification;
        this.varStatesMap = varStatesMap;
        this.prev = null;
        this.threadType = threadType;
        this.type = ThreadAutomatons.getDefaultAutomatonsTypeForThreadType(threadType);
        this.eventParserRoundNum = eventParserRoundNum;
        this.threadNum = threadNum;
        this.envDesc = envDesc;
        this.mover = new AutomatonsMoves(specification, varStatesMap);
        if (this.type == AutomatonsType.THREAD_SECTION) {
            Map threadMap = specification.getThreads();
            for (Map.Entry threadMapEntry : threadMap.entrySet()) {
                LTSAAutomaton threadAutomaton = (LTSAAutomaton)threadMapEntry.getValue();
                AutomatonState threadStartAS = new AutomatonState(threadAutomaton, threadAutomaton.getStart(), threadNum);
                this.automStates.add(threadStartAS);
                varStatesMap.setMappingsAllStatesAsCall(threadStartAS);
                this.moveAutomatonsForward();
            }
        }
    }

    protected ThreadAutomatons(ThreadAutomatons prev, int eventParserRoundNum) {
        assert (prev != null);
        this.specification = prev.specification;
        this.varStatesMap = prev.varStatesMap;
        this.threadNum = prev.threadNum;
        this.mover = prev.mover;
        this.prev = prev;
        this.type = ThreadAutomatons.getSuccessorAutomatonsType(prev.type);
        this.threadType = prev.threadType;
        this.eventParserRoundNum = eventParserRoundNum;
        this.envDesc = prev.envDesc;
    }

    protected ThreadAutomatons(ThreadAutomatons source, int eventParserRoundNum, boolean ignored) {
        assert (source != null);
        assert (ignored);
        this.specification = source.specification;
        this.varStatesMap = source.varStatesMap;
        this.threadNum = source.threadNum;
        this.mover = source.mover;
        this.prev = source.prev;
        this.type = source.type;
        this.threadType = source.threadType;
        this.eventParserRoundNum = eventParserRoundNum;
        this.errorFlag = source.errorFlag;
        this.errorString = source.errorString;
        this.reqItfsCallDepth = source.reqItfsCallDepth;
        this.provItfsCallDepth = source.provItfsCallDepth;
        this.eventStack.addAll(source.eventStack);
        this.envDesc = source.envDesc;
        this.automStates = new HashSet<AutomatonState>(source.automStates);
    }

    public ThreadAutomatons clone(int eventParserRoundNum) {
        return new ThreadAutomatons(this, eventParserRoundNum, true);
    }

    public int getEventParserRoundNum() {
        return this.eventParserRoundNum;
    }

    public ThreadAutomatons getPrevThreadAutomaton() {
        return this.prev;
    }

    public final boolean getError() {
        return this.errorFlag;
    }

    public final String getErrorString() {
        return this.errorString;
    }

    public ThreadAutomatons processEventProvidedCall(EventItem event, int eventParserRoundNum) {
        if (this.type == AutomatonsType.NONE_EVENTS) {
            String errorStr = "Provided call event (event=" + event + ") from thread where no events expected (threadNum=" + this.threadNum + ", threadType=" + (Object)((Object)this.threadType) + ")";
            this.setError(errorStr);
            throw new RuntimeException(errorStr);
        }
        if (this.provItfsCallDepth > 0) {
            ++this.provItfsCallDepth;
            this.eventStack.push(event);
            return this;
        }
        ThreadAutomatons result = new ThreadAutomatons(this, eventParserRoundNum);
        TBPParsedAccept call = this.envDesc.line2ProvidedCall.get(event.line);
        if (call == null) {
            throw new RuntimeException("ERROR - Unexpected provided call " + event.fullName + " on line " + event.line);
        }
        Binding binding = ThreadAutomatons.findAutomaton(this.specification, event, call);
        LTSAAutomaton automaton = (LTSAAutomaton)this.specification.getReactions().get(binding);
        AutomatonState startState = new AutomatonState(automaton, automaton.getStart(), event.thread);
        result.automStates.add(startState);
        result.varStatesMap.setMappingsAllStatesAsCall(startState);
        result.moveAutomatonsForward();
        ++result.provItfsCallDepth;
        result.eventStack.push(event);
        return result;
    }

    public ThreadAutomatons processEventRequiredCall(EventItem event, int currentEventParserRoundNum) {
        if (this.type == AutomatonsType.NONE_EVENTS) {
            String errorStr = "Required call event (event=" + event + ") from thread where no events expected (threadNum=" + this.threadNum + ", threadType=" + (Object)((Object)this.threadType) + ")";
            this.setError(errorStr);
            throw new RuntimeException(errorStr);
        }
        ++this.reqItfsCallDepth;
        this.eventStack.push(event);
        if (this.reqItfsCallDepth > 1) {
            return this;
        }
        this.automStates = this.mover.moveAutomatonsEnterMutexes(this.automStates);
        this.automStates = this.mover.filterStates(this.automStates, event);
        if (this.automStates.isEmpty()) {
            this.setError("Implementation violates specification - no possible automaton move found");
            return this;
        }
        ThreadAutomatons newLayer = new ThreadAutomatons(this, currentEventParserRoundNum);
        ++newLayer.reqItfsCallDepth;
        newLayer.eventStack.push(event);
        boolean startStateFound = this.mover.mapCallingStatesWithCalledStartState(this, this.automStates, newLayer.automStates);
        if (startStateFound) {
            newLayer.moveAutomatonsForward();
            return newLayer;
        }
        return this;
    }

    public ThreadAutomatons processEventRequiredReturn(EventItem event, int currentEventParserRoundNum) {
        if (this.type == AutomatonsType.NONE_EVENTS) {
            String errorStr = "Required return event (event=" + event + ") from thread where no events expected (threadNum=" + this.threadNum + ", threadType=" + (Object)((Object)this.threadType) + ")";
            this.setError(errorStr);
            throw new RuntimeException(errorStr);
        }
        if (this.reqItfsCallDepth <= 0) {
            this.setError("Illegal required return - not paired with any call (more returns than calls)");
            return this;
        }
        EventItem callEvent = this.eventStack.pop();
        --this.reqItfsCallDepth;
        if (!callEvent.isAssociatedEvent(event)) {
            this.setError("Illegal required return - not paired with stored call (different return than call)");
        }
        if (this.reqItfsCallDepth == 0 && !this.eventStack.isEmpty()) {
            this.automStates = this.mover.edgeActicionProcess(this.automStates);
            this.moveAutomatonsForward();
            return this;
        }
        if (this.reqItfsCallDepth == 0 && this.eventStack.isEmpty()) {
            if (this.prev == null) {
                this.setError("Illegal required return - not associated call found (return on unknown call)");
                return null;
            }
            EventItem prevLastCallEvent = this.prev.eventStack.pop();
            --this.prev.reqItfsCallDepth;
            if (!prevLastCallEvent.isAssociatedEvent(event)) {
                this.setError("Illegal required return - not asociated with call (return=" + event + ", call=" + prevLastCallEvent);
                return null;
            }
            this.automStates = this.mover.filterStates(this.automStates, event);
            if (this.automStates.isEmpty()) {
                this.setError("Implementation violates specification - no possible automaton move found");
                return this;
            }
            ThreadAutomatons resultLayer = this.prev;
            if (resultLayer.getEventParserRoundNum() != currentEventParserRoundNum) {
                resultLayer = resultLayer.clone(currentEventParserRoundNum);
            }
            this.mover.processReturnValues(this, this.automStates, event.thread);
            resultLayer.automStates = this.mover.edgeActicionProcess(resultLayer.automStates);
            resultLayer.moveAutomatonsForward();
            return resultLayer;
        }
        return this;
    }

    public ThreadAutomatons processEventProvidedReturn(EventItem event, int currentEventParserRoundNum) {
        if (this.type == AutomatonsType.NONE_EVENTS) {
            String errorStr = "Provided return event (event=" + event + ") from thread where no events expected (threadNum=" + this.threadNum + ", threadType=" + (Object)((Object)this.threadType) + ")";
            this.setError(errorStr);
            throw new RuntimeException(errorStr);
        }
        EventItem provCallEvent = this.eventStack.pop();
        --this.provItfsCallDepth;
        if (!provCallEvent.isAssociatedEvent(event)) {
            this.setError("Illegal provided return - not asociated with call (return=" + event + ", call=" + provCallEvent);
            return null;
        }
        if (this.provItfsCallDepth > 0) {
            return this;
        }
        this.automStates = this.mover.moveAutomatonsEnterMutexes(this.automStates);
        TBPParsedAccept call = this.envDesc.line2ProvidedCall.get(provCallEvent.line);
        if (call == null) {
            throw new RuntimeException("Return from invalid call (invalid call line) - " + provCallEvent.line);
        }
        this.automStates = this.mover.filterStates(this.automStates, event);
        this.automStates = this.mover.filterStatesOnReturnValue(this.automStates, event, call.getReturnValue());
        if (this.automStates.isEmpty()) {
            this.setError("Implementation violates specification - no possible automaton move found");
            return this;
        }
        ThreadAutomatons resultLayer = this.prev;
        if (resultLayer != null && resultLayer.getEventParserRoundNum() != currentEventParserRoundNum) {
            resultLayer = resultLayer.clone(currentEventParserRoundNum);
        }
        this.varStatesMap.setMappingsAllStatesAsReturn(event.thread);
        return resultLayer;
    }

    public boolean isEndState() {
        return this.type == AutomatonsType.THREAD_SECTION && AutomatonsMoves.isEndStateInSet(this.automStates) || this.type == AutomatonsType.PROVISION_EVENTS && this.automStates.size() == 0 && this.prev == null || this.type == AutomatonsType.PROVISION_EVENTS && AutomatonsMoves.isEndStateInSet(this.automStates) || this.type == AutomatonsType.NONE_EVENTS;
    }

    void setError(String errorString) {
        if (!this.errorFlag) {
            this.errorFlag = true;
            this.errorString = errorString;
        }
    }

    private void moveAutomatonsForward() {
        this.automStates = this.mover.moveAutomatons(this.automStates);
        if (this.automStates.isEmpty()) {
            this.setError("Implementation violates specification - no possible automaton move found");
        }
    }

    private static AutomatonsType getDefaultAutomatonsTypeForThreadType(ThreadType threadType) {
        if (threadType == ThreadType.ENVIRONMENT_THREAD) {
            return AutomatonsType.PROVISION_EVENTS;
        }
        if (threadType == ThreadType.THREAD_SECTION) {
            return AutomatonsType.THREAD_SECTION;
        }
        if (threadType == ThreadType.NONE_EVENT_THREAD) {
            return AutomatonsType.NONE_EVENTS;
        }
        throw new RuntimeException("New unknown " + ThreadType.class.getSimpleName() + " entry type " + (Object)((Object)threadType));
    }

    private static AutomatonsType getSuccessorAutomatonsType(AutomatonsType prevAutomatonsType) {
        if (prevAutomatonsType == AutomatonsType.PROVISION_EVENTS) {
            return AutomatonsType.PROVISION_EVENTS;
        }
        if (prevAutomatonsType == AutomatonsType.THREAD_SECTION) {
            return AutomatonsType.PROVISION_EVENTS;
        }
        if (prevAutomatonsType == AutomatonsType.NONE_EVENTS) {
            return AutomatonsType.NONE_EVENTS;
        }
        throw new RuntimeException("New unknown " + AutomatonsType.class.getSimpleName() + " entry type " + (Object)((Object)prevAutomatonsType));
    }

    public final ThreadType getThreadType() {
        return this.threadType;
    }

    private static final Binding findAutomaton(LTSAComponentSpecification specification, EventItem event, TBPParsedAccept call) {
        Binding result = null;
        String searchedMethod = event.fullName;
        for (Binding binding : specification.getReactions().keySet()) {
            boolean sameParameters;
            if (!searchedMethod.equals(binding.getFullname()) || !(sameParameters = ThreadAutomatons.checkParameters(binding.getValues(), call.getMethodCall().getParamDecl()))) continue;
            result = binding;
        }
        return result;
    }

    private static final boolean checkParameters(List<Reference> params1, List<String> params2) {
        if (params1 == null || params2 == null) {
            return false;
        }
        if (params1.size() != params2.size()) {
            return false;
        }
        for (int i = 0; i < params1.size(); ++i) {
            if (params1.get(i).getName().equals(params2.get(i))) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(ThreadAutomatons.class.getSimpleName());
        sb.append("\n");
        sb.append("  Internal state: myHash=" + this.hashCode());
        sb.append(", threadNum=" + this.threadNum);
        sb.append(", type=" + (Object)((Object)this.type));
        sb.append("\n");
        sb.append("    errorFlag=" + this.errorFlag);
        sb.append(", errorString=" + this.errorString);
        sb.append("\n");
        sb.append("    eventParserRoundNum=" + this.eventParserRoundNum);
        sb.append(", prev=" + (this.prev != null ? Integer.valueOf(this.prev.hashCode()) : "null"));
        sb.append("\n");
        sb.append("    provItfsCallDepth=" + this.provItfsCallDepth);
        sb.append(", reqItfsCallDepth=" + this.reqItfsCallDepth);
        sb.append("\n");
        sb.append("    eventStack=" + this.eventStack);
        sb.append("\n");
        sb.append("  Dumping states:\n");
        sb.append(ThreadAutomatons.DEBUG_StatesToString(4, this.automStates, this.varStatesMap));
        return sb.toString();
    }

    public static String DEBUG_StatesToString(int indent, Set<AutomatonState> states, StatesMapper varStatesMap) {
        StringBuffer sb = new StringBuffer();
        for (AutomatonState as : states) {
            ThreadAutomatons.DEBUG_indetStringBuffer(sb, indent);
            sb.append(as);
            sb.append("\n");
            Set<VariablesEvaluation> automatonStates = varStatesMap.DEBUG_getAssociatedMappings(as);
            if (automatonStates == null) continue;
            for (VariablesEvaluation state : automatonStates) {
                ThreadAutomatons.DEBUG_indetStringBuffer(sb, indent + 2);
                sb.append(state);
                sb.append('\n');
            }
        }
        return sb.toString();
    }

    public static StringBuffer DEBUG_indetStringBuffer(StringBuffer sb, int indent) {
        if (sb == null) {
            sb = new StringBuffer();
        }
        for (int i = 0; i < indent; ++i) {
            sb.append(' ');
        }
        return sb;
    }

    public static enum AutomatonsType {
        THREAD_SECTION,
        PROVISION_EVENTS,
        NONE_EVENTS;

    }

    public static enum ThreadType {
        ENVIRONMENT_THREAD,
        THREAD_SECTION,
        NONE_EVENT_THREAD;

    }
}

