/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.dsrg.fm.tbpjava.checker;

import java.io.PrintStream;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import org.ow2.dsrg.fm.tbpjava.checker.StatesMapperLayer;

public final class StateMementoToIndexTransformer {
    private static final boolean DEBUG = false;
    private static final boolean DEBUG_INFO = false;
    private static final boolean DEBUG_COLLISIONS = false;
    private static final boolean INTERNAL_CHECKS = false;
    private final PrintStream out = System.out;
    private final Map<StatesMapperLayer.MappedStateHashableMemento, StatesMapperLayer.MappedStateHashableMemento> stateMementos = new HashMap<StatesMapperLayer.MappedStateHashableMemento, StatesMapperLayer.MappedStateHashableMemento>();
    private int lastAssignedMementoIndex = -1;
    private int cntGetMementoIndex = 0;
    private int cntEqualMementoInstances = 0;

    public int getMementoIndex(StatesMapperLayer.MappedStateHashableMemento memento) {
        assert (memento != null);
        ++this.cntGetMementoIndex;
        StatesMapperLayer.MappedStateHashableMemento equalMemento = this.stateMementos.get(memento);
        if (equalMemento != null) {
            ++this.cntEqualMementoInstances;
            assert (equalMemento.equals(memento));
        } else {
            this.stateMementos.put(memento, memento);
            memento.setMementoIndex(++this.lastAssignedMementoIndex);
            equalMemento = memento;
        }
        return equalMemento.getMementoIndex();
    }

    public String toString() {
        return this.getClass().getSimpleName() + " - Statictics: uniqueStateMementos=" + this.stateMementos.size() + ", seen equalsMementos=" + this.cntEqualMementoInstances + ", getMementoIndex calls=" + this.cntGetMementoIndex;
    }

    public String reportHashCollisions() {
        StringBuffer result = new StringBuffer();
        HashMap<Integer, StatesMapperLayer.MappedStateHashableMemento> positionsByHashCode = new HashMap<Integer, StatesMapperLayer.MappedStateHashableMemento>();
        int collisions = 0;
        for (StatesMapperLayer.MappedStateHashableMemento memento : this.stateMementos.keySet()) {
            assert (memento != null);
            int memHash = memento.hashCode();
            if (positionsByHashCode.containsKey(memHash)) {
                ++collisions;
                continue;
            }
            positionsByHashCode.put(memHash, memento);
        }
        if (collisions > 0) {
            result.append("Notice: Detected" + collisions + " hash collisions. Colisions do not influence the result.\n");
        } else {
            result.append("Fine: No hashCode() collisions in the stored states detected.\n");
        }
        return result.toString();
    }

    public void DEBUG_checkStructure() {
        if (this.stateMementos.size() != this.lastAssignedMementoIndex + 1) {
            throw new RuntimeException(this.getClass().getSimpleName() + " - memento index counter and number of stored mementos not match");
        }
        for (StatesMapperLayer.MappedStateHashableMemento memento : this.stateMementos.values()) {
            assert (memento != null);
            if (memento.getMementoIndex() == -1) {
                throw new RuntimeException(this.getClass().getSimpleName() + " - memento with invalid index.");
            }
            if (memento.getMementoIndex() <= this.lastAssignedMementoIndex) continue;
            throw new RuntimeException(this.getClass().getSimpleName() + " - memento index to big.");
        }
        StatesMapperLayer.MappedStateHashableMemento[] storedData = this.stateMementos.values().toArray(new StatesMapperLayer.MappedStateHashableMemento[0]);
        for (int i = 0; i < storedData.length; ++i) {
            StatesMapperLayer.MappedStateHashableMemento iMem = storedData[i];
            for (int j = i + 1; j < storedData.length; ++j) {
                StatesMapperLayer.MappedStateHashableMemento jMem = storedData[j];
                if (iMem.equals(jMem)) {
                    throw new RuntimeException(this.getClass().getSimpleName() + " more equal memtos in list.");
                }
                if (iMem.getMementoIndex() != jMem.getMementoIndex()) continue;
                throw new RuntimeException(this.getClass().getSimpleName() + " more mementos with same index.");
            }
        }
    }

    public void DEBUG_printMapping() {
        this.out.println(this.getClass().getSimpleName() + " - printing stored mapping (sorting)");
        StatesMapperLayer.MappedStateHashableMemento[] storedData = this.stateMementos.values().toArray(new StatesMapperLayer.MappedStateHashableMemento[0]);
        Comparator<StatesMapperLayer.MappedStateHashableMemento> comp = new Comparator<StatesMapperLayer.MappedStateHashableMemento>(){

            @Override
            public int compare(StatesMapperLayer.MappedStateHashableMemento left, StatesMapperLayer.MappedStateHashableMemento right) {
                return left.getMementoIndex() - right.getMementoIndex();
            }
        };
        Arrays.sort(storedData, comp);
        for (int i = 0; i < storedData.length; ++i) {
            this.out.println("  " + i + " --> " + storedData[i].toString(4));
        }
    }
}

