/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.dsrg.fm.tbpjava.checker;

import gov.nasa.jpf.Config;
import gov.nasa.jpf.jvm.DynamicArea;
import gov.nasa.jpf.jvm.ElementInfo;
import gov.nasa.jpf.jvm.ExceptionInfo;
import gov.nasa.jpf.jvm.JVM;
import gov.nasa.jpf.jvm.MJIEnv;
import gov.nasa.jpf.jvm.MethodInfo;
import gov.nasa.jpf.jvm.NoUncaughtExceptionsProperty;
import gov.nasa.jpf.jvm.ThreadInfo;
import gov.nasa.jpf.search.Search;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import org.ow2.dsrg.fm.tbpjava.utils.Configuration;

public class PropertyUncaughtExceptions
extends NoUncaughtExceptionsProperty {
    private static final boolean DEBUG = false;
    private static final String RUNTIME_EXCEPTION_NAME = "java.lang.RuntimeException";
    private PrintStream out = System.out;
    private final Configuration checkerConfig;
    private final String checkedEnviromentClassName;

    public PropertyUncaughtExceptions(Config config, Configuration checkerConfig, String enviromentClassName, PrintStream out) {
        super(config);
        assert (checkerConfig != null);
        assert (enviromentClassName != null);
        if (out != null) {
            this.out = out;
        }
        this.checkerConfig = checkerConfig;
        this.checkedEnviromentClassName = enviromentClassName;
    }

    public String getExplanation() {
        return "Tested method throw exception. Typicaly it is bad method call (illegal parameter or invalid call time). Check provision definition (int TPB protocol) or parameter definition in " + this.checkerConfig.getEnvValueSets() + " class";
    }

    public String getErrorMessage() {
        ExceptionInfo expI = this.getUncaughtExceptionInfo();
        if (expI != null && this.checkIfCheckerException(expI)) {
            int excRef = expI.getExceptionReference();
            DynamicArea da = DynamicArea.getHeap();
            assert (da != null);
            ElementInfo expElemI = da.get(excRef);
            if (expElemI == null) {
                throw new RuntimeException("Problem with JPF exception representation");
            }
            int origExcRef = expElemI.getReferenceField("cause");
            if (origExcRef == -1) {
                throw new RuntimeException("Unexpected JPF behavior");
            }
            ElementInfo origExcElemI = da.get(origExcRef);
            if (origExcElemI == null) {
                throw new RuntimeException("Unexpected JPF behavior");
            }
            return PropertyUncaughtExceptions.exceptionInfoPrintOn(expI.getThread(), origExcRef);
        }
        return super.getErrorMessage();
    }

    private boolean checkIfCheckerException(ExceptionInfo ei) {
        assert (ei != null);
        if (!RUNTIME_EXCEPTION_NAME.equals(ei.getExceptionClassname())) {
            return false;
        }
        DynamicArea da = DynamicArea.getHeap();
        assert (da != null);
        int excRef = ei.getExceptionReference();
        ElementInfo expElemI = da.get(excRef);
        if (expElemI == null) {
            throw new RuntimeException("Problem with JPF exception representation");
        }
        int stackTraceRef = expElemI.getReferenceField("snapshot");
        if (stackTraceRef == -1) {
            throw new RuntimeException("Unexpected JPF behavior");
        }
        MJIEnv env = ei.getThread().getEnv();
        int[] snapshot = env.getIntArrayObject(stackTraceRef);
        if (snapshot == null) {
            throw new RuntimeException("Unexpected JPF behavior");
        }
        int len = snapshot.length / 2;
        if (len == 0) {
            throw new RuntimeException("Unexpected JPF behavior");
        }
        MethodInfo mi = MethodInfo.getMethodInfo((int)snapshot[0]);
        if (mi == null) {
            throw new RuntimeException("Unexpected JPF behavior");
        }
        String className = "unknownMethod";
        className = mi.isDirectCallStub() ? "java.lang.reflect.Method" : mi.getClassName();
        if (className == null) {
            throw new RuntimeException("Unexpected JPF behavior");
        }
        return className.startsWith(this.checkedEnviromentClassName);
    }

    public boolean check(Search search, JVM vm) {
        return super.check(search, vm);
    }

    public void reset() {
        super.reset();
    }

    private static String exceptionInfoPrintOn(ThreadInfo ti, int excReference) {
        StringWriter sw = new StringWriter();
        ti.printStackTrace(new PrintWriter(sw), excReference);
        return sw.toString();
    }
}

