/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.dsrg.fm.tbpjava.checker;

import gov.nasa.jpf.util.Pair;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import org.ow2.dsrg.fm.tbpjava.checker.EventItem;
import org.ow2.dsrg.fm.tbpjava.checker.JPFProgramStateMapping;
import org.ow2.dsrg.fm.tbpjava.checker.StateMementoToIndexTransformer;
import org.ow2.dsrg.fm.tbpjava.checker.StatesMapper;
import org.ow2.dsrg.fm.tbpjava.checker.StatesMapperLayer;

public final class JPFProgramStateMappingPrecise
implements JPFProgramStateMapping {
    private static final boolean DEBUG = false;
    private static final boolean DEBUG_INFO = false;
    private static final boolean INTERNLAL_TESTS = false;
    private final PrintStream out = System.out;
    private final StatesMapper varMapper;
    private final StateMementoToIndexTransformer indexer;
    private static final int INVALID_INDEX = -1;
    private static final int INITIAL_SIZE = 16384;
    private int[] jpfState2listIndex = new int[16384];
    private int[] tbpStateList = new int[32768];
    private int tbpStateListEnd = -1;
    private final Stack<Pair<Integer, Integer>> stack = new Stack();

    public JPFProgramStateMappingPrecise(StatesMapper varMapper) {
        assert (varMapper != null);
        this.varMapper = varMapper;
        this.indexer = new StateMementoToIndexTransformer();
        Arrays.fill(this.jpfState2listIndex, 0, this.jpfState2listIndex.length, -1);
    }

    @Override
    public void addMapping(int stateID) {
        StatesMapperLayer.MappedStateHashableMemento currentTBPPosition = this.varMapper.getTBPPosition();
        int currentTBPPositionIndex = this.indexer.getMementoIndex(currentTBPPosition);
        if (stateID >= this.jpfState2listIndex.length) {
            int newSize;
            for (newSize = this.jpfState2listIndex.length * 2; newSize <= stateID; newSize *= 2) {
            }
            int origLen = this.jpfState2listIndex.length;
            this.jpfState2listIndex = Arrays.copyOf(this.jpfState2listIndex, newSize);
            Arrays.fill(this.jpfState2listIndex, origLen, newSize - 1, -1);
        }
        if (this.jpfState2listIndex[stateID] == -1) {
            if (this.tbpStateList.length <= this.tbpStateListEnd + 2) {
                this.tbpStateList = Arrays.copyOf(this.tbpStateList, this.tbpStateList.length * 2);
            }
            this.jpfState2listIndex[stateID] = ++this.tbpStateListEnd;
            this.tbpStateList[this.tbpStateListEnd] = stateID;
            ++this.tbpStateListEnd;
            this.tbpStateList[this.tbpStateListEnd] = -1;
        } else {
            int currIndex = this.jpfState2listIndex[stateID];
            int prevIndex = -1;
            while (currIndex != -1 && this.tbpStateList[currIndex] != currentTBPPositionIndex) {
                prevIndex = currIndex;
                currIndex = this.tbpStateList[currIndex + 1];
            }
            if (currIndex == -1) {
                assert (prevIndex != -1);
                if (this.tbpStateList.length <= this.tbpStateListEnd + 2) {
                    this.tbpStateList = Arrays.copyOf(this.tbpStateList, this.tbpStateList.length * 2);
                }
                ++this.tbpStateListEnd;
                this.tbpStateList[this.tbpStateListEnd] = stateID;
                ++this.tbpStateListEnd;
                this.tbpStateList[this.tbpStateListEnd] = -1;
                this.tbpStateList[prevIndex + 1] = this.tbpStateListEnd - 1;
            }
        }
    }

    @Override
    public boolean wasProcessed(int stateID) {
        StatesMapperLayer.MappedStateHashableMemento currentTBPPosition = this.varMapper.getTBPPosition();
        int currentTBPPositionIndex = this.indexer.getMementoIndex(currentTBPPosition);
        boolean findMap = this.isStoredInTBPStateList(stateID, currentTBPPositionIndex);
        if (findMap) {
            return true;
        }
        boolean findStack = this.isStoredInTheStack(stateID, currentTBPPositionIndex);
        return findStack;
    }

    private boolean isStoredInTheStack(int stateID, int currentTBPPositionIndex) {
        Iterator it = this.stack.iterator();
        for (int i = 0; i < this.stack.size() - 1; ++i) {
            Pair entry = (Pair)it.next();
            if ((Integer)entry.a != stateID || (Integer)entry.b != currentTBPPositionIndex) continue;
            return true;
        }
        return false;
    }

    private boolean isStoredInTBPStateList(int stateID, int currentTBPPositionIndex) {
        assert (stateID >= 0);
        assert (currentTBPPositionIndex >= 0);
        if (stateID >= this.jpfState2listIndex.length) {
            return false;
        }
        int listIndex = this.jpfState2listIndex[stateID];
        if (listIndex == -1) {
            return false;
        }
        do {
            if (this.tbpStateList[listIndex] != stateID) continue;
            return true;
        } while ((listIndex = this.tbpStateList[listIndex + 1]) != -1);
        return false;
    }

    @Override
    public void advancedEvents(List<EventItem> events, int jpfStateID) {
        StatesMapperLayer.MappedStateHashableMemento currentTBPPosition = this.varMapper.getTBPPosition();
        int currentTBPPositionIndex = this.indexer.getMementoIndex(currentTBPPosition);
        this.stack.push((Pair<Integer, Integer>)new Pair((Object)jpfStateID, (Object)currentTBPPositionIndex));
    }

    @Override
    public void undoEvents() {
        this.stack.pop();
    }

    @Override
    public String getUsageStatistics() {
        int i;
        StringBuffer result = new StringBuffer();
        result.append(this.indexer.reportHashCollisions());
        int[] lengthListCounts = new int[1024];
        Arrays.fill(lengthListCounts, 0, lengthListCounts.length, 0);
        for (i = 0; i < this.jpfState2listIndex.length; ++i) {
            if (this.jpfState2listIndex[i] == -1) continue;
            int listLen = 0;
            int listIndex = this.jpfState2listIndex[i];
            do {
                ++listLen;
            } while ((listIndex = this.tbpStateList[listIndex + 1]) != -1);
            if (listLen > lengthListCounts.length) {
                int[] newLengthListCounts = Arrays.copyOf(lengthListCounts, listLen * 2);
                Arrays.fill(newLengthListCounts, lengthListCounts.length, newLengthListCounts.length - 1, 0);
                lengthListCounts = newLengthListCounts;
            }
            int n = listLen;
            lengthListCounts[n] = lengthListCounts[n] + 1;
        }
        result.append("Dumping histogram of Number of the TBPStatem mapped to JPFState -> Number of occurences\n");
        for (i = 0; i < lengthListCounts.length; ++i) {
            if (lengthListCounts[i] == 0) continue;
            result.append("\t" + i + " ->" + lengthListCounts[i] + '\n');
        }
        result.append("Cross test Extended JPF states : " + (this.tbpStateListEnd + 1) / 2);
        return result.toString();
    }

    public void DEBUG_checkStructure() {
        if (this.tbpStateListEnd >= this.tbpStateList.length) {
            throw new RuntimeException("tbpStateListEnd is too BIG");
        }
        for (int i = 0; i < this.jpfState2listIndex.length; ++i) {
            if (this.jpfState2listIndex[i] == -1) continue;
            if (this.jpfState2listIndex[i] < 0 || this.jpfState2listIndex[i] >= this.tbpStateListEnd) {
                throw new RuntimeException("jpfState2listIndex invalid value ...jpfState2listIndex[" + i + "]=" + this.jpfState2listIndex[i]);
            }
            if ((this.jpfState2listIndex[i] & 1) == this.jpfState2listIndex[i]) continue;
            throw new RuntimeException("Index points into the second pard of the pair - odd asress  ...jpfState2listIndex[" + i + "]=" + this.jpfState2listIndex[i]);
        }
        HashSet<Integer> visitedIndexes = new HashSet<Integer>(this.tbpStateListEnd);
        HashSet<Integer> mementoIndexesInList = new HashSet<Integer>();
        for (int i = 0; i < this.jpfState2listIndex.length; ++i) {
            if (this.jpfState2listIndex[i] == -1) continue;
            int listIndex = this.jpfState2listIndex[i];
            do {
                if (visitedIndexes.contains(listIndex)) {
                    throw new RuntimeException("multiple entries in jpfState2listIndex points into same linked list jpfState2listIndex[" + i + "]=" + this.jpfState2listIndex[i]);
                }
                visitedIndexes.add(listIndex);
                if (mementoIndexesInList.contains(this.tbpStateList[listIndex])) {
                    throw new RuntimeException("same memento ID entries in one linked list jpfState2listIndex[" + i + "]=" + this.jpfState2listIndex[i] + " ... tbpStateList[" + listIndex + "]=" + this.tbpStateList[listIndex]);
                }
                mementoIndexesInList.add(this.tbpStateList[listIndex]);
            } while ((listIndex = this.tbpStateList[listIndex + 1]) != -1);
            mementoIndexesInList.clear();
        }
        if (2 * visitedIndexes.size() - 1 != this.tbpStateListEnd) {
            throw new RuntimeException("Unexpected total size of linked lists.");
        }
    }

    public void DEBUG_printMapping() {
        int i;
        this.out.println(this.getClass().getSimpleName() + "DEBUG_printMapping - stored mapping");
        for (i = 0; i < this.jpfState2listIndex.length; ++i) {
            this.out.print("\t - " + i + " --> ");
            int listIdx = this.jpfState2listIndex[i];
            if (listIdx == -1) {
                this.out.println("no mapped state");
                continue;
            }
            this.out.print(this.tbpStateList[listIdx]);
            listIdx = this.tbpStateList[listIdx + 1];
            while (listIdx != -1) {
                this.out.print(", " + this.tbpStateList[listIdx]);
                listIdx = this.tbpStateList[listIdx + 1];
            }
            this.out.println();
        }
        this.out.println(this.getClass().getSimpleName() + "DEBUG_printMapping - dumping actual stack [Depth -> jpfStateID,TBPProtocolStateID]");
        for (i = 0; i < this.stack.size(); ++i) {
            Pair pair = (Pair)this.stack.get(i);
            this.out.print(91 + i + " --> " + pair.a + ", " + pair.b + ']');
        }
        this.out.println();
    }
}

