/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.dsrg.fm.tbpjava.checker;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.ow2.dsrg.fm.tbpjava.checker.EventItem;
import org.ow2.dsrg.fm.tbpjava.checker.JPFProgramStateMapping;
import org.ow2.dsrg.fm.tbpjava.checker.ThreadAutomatons;

class JPFProgramStateMappingEventList
implements JPFProgramStateMapping {
    private static final boolean DEBUG = false;
    private static final boolean DEBUG_INFO = false;
    private SetTBPProtocolEvent.TBPProtocolEventList eventListBottom;
    private Map<Integer, SetTBPProtocolEvent> mapJPFState2TBPProtocolState;
    private Stack<SetTBPProtocolEvent.TBPProtocolEventList> eventStack = new Stack();

    public JPFProgramStateMappingEventList() {
        this.mapJPFState2TBPProtocolState = new HashMap<Integer, SetTBPProtocolEvent>();
        EventItem ei = new EventItem(-1, EventItem.EventTypes.EVENT_CALL, "noMethodCalled", "noInterface", -1);
        this.eventListBottom = new SetTBPProtocolEvent.TBPProtocolEventList(null, ei);
        this.eventStack.push(this.eventListBottom);
    }

    @Override
    public void addMapping(int stateID) {
        SetTBPProtocolEvent holder = this.mapJPFState2TBPProtocolState.get(stateID);
        if (holder == null) {
            holder = new SetTBPProtocolEvent();
            this.mapJPFState2TBPProtocolState.put(stateID, holder);
        }
        holder.addToProcessedList(this.eventStack.peek());
    }

    @Override
    public void advancedEvents(List<EventItem> events, int jpfStateID) {
        SetTBPProtocolEvent.TBPProtocolEventList currentEventList = this.eventStack.peek();
        if (events != null) {
            for (int eventIndex = 0; eventIndex < events.size(); ++eventIndex) {
                currentEventList = new SetTBPProtocolEvent.TBPProtocolEventList(currentEventList, events.get(eventIndex));
            }
        }
        this.eventStack.push(currentEventList);
    }

    @Override
    public void undoEvents() {
        if (this.eventStack.size() == 1) {
            throw new RuntimeException("Too many undo events - not complemented processEvent found");
        }
        this.eventStack.pop();
    }

    @Override
    public boolean wasProcessed(int stateID) {
        SetTBPProtocolEvent holder = this.mapJPFState2TBPProtocolState.get(stateID);
        if (holder == null) {
            holder = new SetTBPProtocolEvent();
            this.mapJPFState2TBPProtocolState.put(stateID, holder);
        }
        return holder.sameState(this.eventStack.peek());
    }

    @Override
    public String getUsageStatistics() {
        return "";
    }

    static class SetTBPProtocolEvent {
        private Set<TBPProtocolEventList> eventSet = new HashSet<TBPProtocolEventList>();
        private int DEBUG_sameStateCalls = 0;
        private int DEBUG_sameStateSuccess = 0;
        private int DEBUG_sameStateFail = 0;
        private int DEBUG_List_sameStateCalls = 0;
        private int DEBUG_List_sameStateDepth = 0;

        SetTBPProtocolEvent() {
        }

        public void addToProcessedList(TBPProtocolEventList newList) {
            this.eventSet.add(newList);
        }

        public boolean sameState(TBPProtocolEventList other) {
            ++this.DEBUG_sameStateCalls;
            if (this.eventSet.contains(other)) {
                ++this.DEBUG_sameStateSuccess;
                return true;
            }
            for (TBPProtocolEventList event : this.eventSet) {
                int areSame = event.sameState(other);
                ++this.DEBUG_List_sameStateCalls;
                if (areSame > 0) {
                    this.DEBUG_List_sameStateDepth += areSame;
                    ++this.DEBUG_sameStateSuccess;
                    return true;
                }
                this.DEBUG_List_sameStateDepth -= areSame;
            }
            ++this.DEBUG_sameStateFail;
            return false;
        }

        static class TBPProtocolEventList {
            private static final int STATES_NOT_SAME = -1;
            private static final int STATES_SAME = 1;
            private final TBPProtocolEventList previous;
            private final EventItem eventItem;

            public TBPProtocolEventList(TBPProtocolEventList previous, EventItem eventItem) {
                assert (eventItem != null);
                this.previous = previous;
                this.eventItem = eventItem;
            }

            public int sameState(TBPProtocolEventList other) {
                if (other == null) {
                    return -1;
                }
                if (other == this) {
                    return 1;
                }
                if (this.eventItem.equals(other.eventItem)) {
                    if (this.previous == null) {
                        if (other.previous == null) {
                            return 1;
                        }
                        return -1;
                    }
                    int previousSameState = this.previous.sameState(other.previous);
                    if (previousSameState >= 0) {
                        return previousSameState + 1;
                    }
                    return previousSameState - 1;
                }
                return -1;
            }

            public String toString(int indent) {
                StringBuffer sb = new StringBuffer();
                ThreadAutomatons.DEBUG_indetStringBuffer(sb, indent);
                sb.append(this.eventItem.toString());
                sb.append('\n');
                if (this.previous != null) {
                    sb.append(this.previous.toString(indent));
                }
                return sb.toString();
            }

            public String toString() {
                return this.toString(0);
            }
        }
    }
}

