/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.dsrg.fm.tbpjava.checker;

import org.ow2.dsrg.fm.tbpjava.checker.ProtocolListener;

class EventItem {
    public final EventTypes type;
    public final int thread;
    public final String methodName;
    public final String interfaceName;
    public final String fullName;
    public final int line;
    public static final int PRINT_EVENT_TRACE_START_OFFET_EVENT_TYPE = 0;
    public static final int PRINT_EVENT_TRACE_START_OFFET_THREAD = 15;
    public static final int PRINT_EVENT_TRACE_START_OFFET_INTERFACE_TYPE = 23;
    public static final int PRINT_EVENT_TRACE_START_OFFET_INTERFACE_NAME = 34;
    public static final int PRINT_EVENT_TRACE_START_OFFET_METHOD_NAME = 70;
    public static final int PRINT_EVENT_TRACE_START_OFFET_END = 81;

    public EventItem(int thread, EventTypes type, String methodName, String interfaceName, int line) {
        this.type = type;
        this.thread = thread;
        this.methodName = methodName;
        this.interfaceName = interfaceName;
        this.line = line;
        this.fullName = interfaceName + "." + methodName;
    }

    public boolean isAssociatedEvent(EventItem event) {
        assert (event != null);
        return this.type != event.type && this.thread == event.thread && this.methodName == event.methodName && this.interfaceName == event.interfaceName;
    }

    public String toString() {
        return "EventItem( type=" + (Object)((Object)this.type) + ", thread=" + this.thread + ", methodName=" + this.methodName + ", interfaceName=" + this.interfaceName + ", line=" + this.line + ")";
    }

    public String toStringEventTrace(ProtocolListener pl) {
        StringBuffer result = new StringBuffer();
        EventItem.fillSpacesToLen(result, 0);
        if (this.type == EventTypes.EVENT_CALL) {
            result.append("call");
        } else if (this.type == EventTypes.EVENT_RETURN) {
            result.append("return");
        }
        EventItem.fillSpacesToLen(result, 15);
        result.append("| ");
        result.append(this.thread);
        EventItem.fillSpacesToLen(result, 23);
        result.append("| ");
        if (pl.getProvItfs2implClass().containsKey(this.interfaceName)) {
            result.append("provided");
        } else if (pl.getReqItfs2implClass().containsKey(this.interfaceName)) {
            result.append("required");
        } else {
            result.append("????");
        }
        EventItem.fillSpacesToLen(result, 34);
        result.append("| ");
        result.append(this.interfaceName);
        EventItem.fillSpacesToLen(result, 70);
        result.append("| ");
        result.append(this.methodName);
        return result.toString();
    }

    public static String eventTraceHeader() {
        StringBuffer result = new StringBuffer();
        EventItem.fillSpacesToLen(result, 0);
        result.append("Event type");
        EventItem.fillSpacesToLen(result, 15);
        result.append("| ");
        result.append("Thread");
        EventItem.fillSpacesToLen(result, 23);
        result.append("| ");
        result.append("IF type");
        EventItem.fillSpacesToLen(result, 34);
        result.append("| ");
        result.append("Interface name");
        EventItem.fillSpacesToLen(result, 70);
        result.append("| ");
        result.append("Method name");
        return result.toString();
    }

    public static String eventTraceSeparator() {
        StringBuffer result = new StringBuffer(81);
        for (int i = 0; i < 81; ++i) {
            result.append('-');
        }
        return result.toString();
    }

    private static void fillSpacesToLen(StringBuffer sb, int len) {
        for (int i = sb.length(); i < len; ++i) {
            sb.append(' ');
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.fullName == null ? 0 : this.fullName.hashCode());
        result = 31 * result + (this.interfaceName == null ? 0 : this.interfaceName.hashCode());
        result = 31 * result + (this.methodName == null ? 0 : this.methodName.hashCode());
        result = 31 * result + this.thread;
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EventItem)) {
            return false;
        }
        EventItem other = (EventItem)obj;
        if (this.fullName == null ? other.fullName != null : !this.fullName.equals(other.fullName)) {
            return false;
        }
        if (this.interfaceName == null ? other.interfaceName != null : !this.interfaceName.equals(other.interfaceName)) {
            return false;
        }
        if (this.methodName == null ? other.methodName != null : !this.methodName.equals(other.methodName)) {
            return false;
        }
        if (this.thread != other.thread) {
            return false;
        }
        return !(this.type == null ? other.type != null : !this.type.equals((Object)other.type));
    }

    public static enum EventTypes {
        EVENT_CALL,
        EVENT_RETURN;

    }
}

